package me.rufia.fightorflight;

import com.cobblemon.mod.common.client.CobblemonClient;
import com.cobblemon.mod.common.client.storage.ClientStorageManager;
import com.cobblemon.mod.common.pokemon.Pokemon;
import dev.architectury.registry.client.level.entity.EntityModelLayerRegistry;
import me.rufia.fightorflight.client.hud.moveslots.MoveSlotsRender;
import me.rufia.fightorflight.client.keybinds.KeybindFightOrFlight;
import me.rufia.fightorflight.client.model.*;
import me.rufia.fightorflight.client.renderer.*;
import me.rufia.fightorflight.entity.EntityFightOrFlight;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.client.rendering.v1.EntityRendererRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.minecraft.class_304;
import net.minecraft.class_310;

public final class FabricClient implements ClientModInitializer {
    @Override
    public void onInitializeClient() {
        EntityRendererRegistry.register(EntityFightOrFlight.TRACING_BULLET.get(), PokemonTracingBulletRenderer::new);
        EntityRendererRegistry.register(EntityFightOrFlight.ARROW_PROJECTILE.get(), PokemonArrowRenderer::new);
        EntityRendererRegistry.register(EntityFightOrFlight.BULLET.get(), PokemonBulletRenderer::new);
        EntityRendererRegistry.register(EntityFightOrFlight.SPIKE.get(), PokemonSpikeRenderer::new);
        EntityRendererRegistry.register(EntityFightOrFlight.FLOATING_SPIKE.get(), PokemonSpikeRenderer::new);
        EntityRendererRegistry.register(EntityFightOrFlight.STICKY_WEB.get(), PokemonStickyWebRenderer::new);
        EntityRendererRegistry.register(EntityFightOrFlight.TORNADO.get(), PokemonAreaEffectTornadoRenderer::new);
        EntityRendererRegistry.register(EntityFightOrFlight.WHIRLPOOL.get(), PokemonAreaEffectWhirlpoolRenderer::new);
        EntityRendererRegistry.register(EntityFightOrFlight.MAGIC_EFFECT.get(), PokemonAreaEffectMagicRenderer::new);

        registerModelLayerLocation();
        for (class_304 keyMapping : KeybindFightOrFlight.bindings) {
            KeyBindingHelper.registerKeyBinding(keyMapping);
        }
        HudRenderCallback.EVENT.register(((drawContext, tickCounter) -> {
            if (!class_310.method_1551().field_1690.field_1842) {
                var storage = CobblemonClient.INSTANCE.getStorage();
                int slot = storage.getSelectedSlot();
                var pokemon = storage.getMyParty().get(slot);
                if (pokemon != null) {
                    MoveSlotsRender.render(drawContext, tickCounter.method_60637(true), pokemon);
                }
            }
        }));
    }

    public void registerModelLayerLocation() {
        EntityModelLayerRegistry.register(PokemonSpikeModel.LAYER_LOCATION, PokemonSpikeModel::createBodyLayer);
        EntityModelLayerRegistry.register(PokemonTransformingProjectileModel.LAYER_LOCATION, PokemonTransformingProjectileModel::createBodyLayer);
        EntityModelLayerRegistry.register(PokemonAreaEffectTornadoModel.LAYER_LOCATION, PokemonAreaEffectTornadoModel::createBodyLayer);
        EntityModelLayerRegistry.register(PokemonAreaEffectWhirlpoolModel.LAYER_LOCATION, PokemonAreaEffectWhirlpoolModel::createBodyLayer);
        EntityModelLayerRegistry.register(PokemonAreaEffectMagicModel.LAYER_LOCATION, PokemonAreaEffectMagicModel::createBodyLayer);
    }
}
