package me.rufia.fightorflight.client.renderer;

import me.rufia.fightorflight.CobblemonFightOrFlight;
import me.rufia.fightorflight.client.model.PokemonAreaEffectMagicModel;
import me.rufia.fightorflight.entity.PokemonAttackEffect;
import me.rufia.fightorflight.entity.areaeffect.PokemonAreaEffectMagic;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_3883;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5253;
import net.minecraft.class_5617;
import net.minecraft.class_7833;
import net.minecraft.class_897;
import java.awt.*;
import java.util.Arrays;
import java.util.List;

public class PokemonAreaEffectMagicRenderer extends class_897<PokemonAreaEffectMagic> implements class_3883<PokemonAreaEffectMagic, PokemonAreaEffectMagicModel<PokemonAreaEffectMagic>> {
    private static final class_2960 LIGHTNING_TEXTURE_LOCATION = class_2960.method_60655(CobblemonFightOrFlight.MODID, "textures/entity/lightning.png");
    private static final class_2960 ERUPTION_TEXTURE_LOCATION = class_2960.method_60655(CobblemonFightOrFlight.MODID, "textures/entity/eruption.png");
    private static final class_2960 MAGIC_TEXTURE_LOCATION = class_2960.method_60655(CobblemonFightOrFlight.MODID, "textures/entity/magic.png");
    private static final class_2960 ERUPTION_FIRE_TEXTURE_LOCATION = class_2960.method_60655(CobblemonFightOrFlight.MODID, "textures/entity/eruption_fire.png");
    private static final List<String> specialTypes = Arrays.asList("fire", "ground", "electric");
    private final PokemonAreaEffectMagicModel<PokemonAreaEffectMagic> model;

    public PokemonAreaEffectMagicRenderer(class_5617.class_5618 context) {
        super(context);
        model = new PokemonAreaEffectMagicModel<>(context.method_32167(PokemonAreaEffectMagicModel.LAYER_LOCATION));
    }

    @Override
    public void render(PokemonAreaEffectMagic entity, float entityYaw, float partialTicks, class_4587 poseStack, class_4597 buffer, int packedLight) {
        boolean isWaiting = entity.isWaiting();
        poseStack.method_22903();
        float d = entity.getRadius() * 2;
        poseStack.method_22905(d, d, d);
        poseStack.method_22907(class_7833.field_40718.rotationDegrees(180f));
        poseStack.method_22904(0, -0.05, 0);
        class_4588 vertexConsumer = buffer.getBuffer(model.method_23500(getTextureLocation(entity)));
        Color color = getColor(entity);
        int colorCode = class_5253.class_5254.method_59554(0.4F, (float) color.getRed() / 255, (float) color.getGreen() / 255, (float) color.getBlue() / 255);
        model.renderBottom(poseStack, vertexConsumer, packedLight, class_4608.field_21444, colorCode);
        if (!isWaiting) {
            int waitTime = entity.getWaitTime();
            float tick = entity.field_6012 + partialTicks - waitTime;
            float yScale;
            if (entity.getElementalType().equals("electric")) {
                poseStack.method_46416(0, -2, 0);
                yScale = class_3532.method_37166(0.2f, 1f, tick / 4);
                poseStack.method_22905(1, yScale, 1);
                model.renderBeam(poseStack, vertexConsumer, packedLight, class_4608.field_21444, colorCode);
            } else {
                yScale = -class_3532.method_37166(0.2f, 1f, tick / 4);
                poseStack.method_22904(0, 0.2, 0);
                poseStack.method_22905(1, yScale, 1);
                model.renderBeam(poseStack, vertexConsumer, packedLight, class_4608.field_21444, colorCode);
                class_4588 vertexConsumer1 = buffer.getBuffer(class_1921.method_42600(ERUPTION_FIRE_TEXTURE_LOCATION));
                model.renderBeam(poseStack, vertexConsumer1, packedLight, class_4608.field_21444, colorCode);
            }
        }
        poseStack.method_22909();
    }

    @Override
    public class_2960 getTextureLocation(PokemonAreaEffectMagic entity) {
        String typeName = entity.getElementalType();
        return switch (typeName) {
            case "electric" -> LIGHTNING_TEXTURE_LOCATION;
            case "ground", "fire" -> ERUPTION_TEXTURE_LOCATION;
            default -> MAGIC_TEXTURE_LOCATION;
        };
    }

    public static boolean hasSpecialTexture(PokemonAreaEffectMagic entity) {
        String typeName = entity.getElementalType();
        return specialTypes.contains(typeName);
    }

    public static Color getColor(PokemonAreaEffectMagic entity) {
        return hasSpecialTexture(entity) ? Color.WHITE : PokemonAttackEffect.getColorFromType(entity.getElementalType());
    }

    @Override
    public PokemonAreaEffectMagicModel<PokemonAreaEffectMagic> method_4038() {
        return model;
    }
}
