package me.rufia.fightorflight.client.renderer;

import me.rufia.fightorflight.CobblemonFightOrFlight;
import me.rufia.fightorflight.client.model.PokemonAreaEffectTornadoModel;
import me.rufia.fightorflight.entity.PokemonAttackEffect;
import me.rufia.fightorflight.entity.areaeffect.AbstractPokemonAreaEffect;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5253;
import net.minecraft.class_5617;
import net.minecraft.class_7833;
import net.minecraft.class_897;
import java.awt.*;

public class PokemonAreaEffectTornadoRenderer extends class_897<AbstractPokemonAreaEffect> {
    private static final class_2960 TEXTURE_LOCATION = class_2960.method_60655(CobblemonFightOrFlight.MODID, "textures/entity/tornado.png");
    private final PokemonAreaEffectTornadoModel<AbstractPokemonAreaEffect> model;

    public PokemonAreaEffectTornadoRenderer(class_5617.class_5618 context) {
        super(context);
        model = new PokemonAreaEffectTornadoModel<>(context.method_32167(PokemonAreaEffectTornadoModel.LAYER_LOCATION));
    }

    @Override
    public void render(AbstractPokemonAreaEffect entity, float entityYaw, float partialTicks, class_4587 poseStack, class_4597 buffer, int packedLight) {
        boolean isWaiting = entity.isWaiting();
        poseStack.method_22903();
        float tick = entity.field_6012 + partialTicks;
        float d = entity.getRadius() * 2;
        float rotSpeed = isWaiting ? 0.2f : (entity.isActivated() ? 0.1f : 0.3f);
        poseStack.method_22905(d, d, d);
        poseStack.method_22907(class_7833.field_40716.rotationDegrees(class_3532.method_15362(tick * rotSpeed) * 180f));
        poseStack.method_22907(class_7833.field_40718.rotationDegrees(180f));
        poseStack.method_22904(0, -1.55, 0);
        class_4588 vertexConsumer = buffer.getBuffer(this.model.method_23500(TEXTURE_LOCATION));
        Color color = PokemonAttackEffect.getColorFromType(entity.getElementalType());
        int colorCode = class_5253.class_5254.method_59554(0.4F, (float) color.getRed() / 255, (float) color.getGreen() / 255, (float) color.getBlue() / 255);
        if (isWaiting) {
            model.renderPreEffect(poseStack, vertexConsumer, packedLight, class_4608.field_21444, colorCode);
        } else {
            model.renderTornado(poseStack, vertexConsumer, packedLight, class_4608.field_21444, colorCode);
        }
        poseStack.method_22909();
    }

    @Override
    public class_2960 getTextureLocation(AbstractPokemonAreaEffect entity) {
        return TEXTURE_LOCATION;
    }
}
