package me.rufia.fightorflight.client.renderer;

import me.rufia.fightorflight.CobblemonFightOrFlight;
import me.rufia.fightorflight.entity.PokemonAttackEffect;
import me.rufia.fightorflight.entity.projectile.PokemonArrow;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5617;
import net.minecraft.class_7833;
import net.minecraft.class_897;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

import java.awt.*;

public class PokemonArrowRenderer extends class_897<PokemonArrow> {
    private static final class_2960 TEXTURE_LOCATION = class_2960.method_60655(CobblemonFightOrFlight.MODID, "textures/entity/arrow_bullet.png");

    public PokemonArrowRenderer(class_5617.class_5618 context) {
        super(context);
    }

    public void render(PokemonArrow entity, float entityYaw, float partialTicks, class_4587 poseStack, class_4597 buffer, int packedLight) {
        Color color = Color.white;
        if (entity.getElementalType() != null) {
            color = PokemonAttackEffect.getColorFromType(entity.getElementalType());
        }
        poseStack.method_22903();
        poseStack.method_22907(class_7833.field_40716.rotationDegrees(class_3532.method_16439(partialTicks, entity.field_5982, entity.method_36454()) - 90.0F));
        poseStack.method_22907(class_7833.field_40718.rotationDegrees(class_3532.method_16439(partialTicks, entity.field_6004, entity.method_36455())));
        boolean i = false;
        float f = 0.0F;
        float g = 0.5F;
        float h = 0.0F;
        float j = 0.15625F;
        float k = 0.0F;
        float l = 0.15625F;
        float m = 0.15625F;
        float n = 0.3125F;
        float o = 0.05625F;
        float p = 0f - partialTicks;
        if (p > 0.0F) {
            float q = -class_3532.method_15374(p * 3.0F) * p;
            poseStack.method_22907(class_7833.field_40718.rotationDegrees(q));
        }

        poseStack.method_22907(class_7833.field_40714.rotationDegrees(45.0F));
        poseStack.method_22905(0.05625F, 0.05625F, 0.05625F);
        poseStack.method_46416(-4.0F, 0.0F, 0.0F);
        class_4588 vertexConsumer = buffer.getBuffer(class_1921.method_23576(this.getTextureLocation(entity)));
        class_4587.class_4665 pose = poseStack.method_23760();

        this.vertex(pose,  vertexConsumer, -7, -2, -2, 0.0F, 0.15625F, -1, 0, 0, packedLight, color);
        this.vertex(pose,  vertexConsumer, -7, -2, 2, 0.15625F, 0.15625F, -1, 0, 0, packedLight, color);
        this.vertex(pose,  vertexConsumer, -7, 2, 2, 0.15625F, 0.3125F, -1, 0, 0, packedLight, color);
        this.vertex(pose,  vertexConsumer, -7, 2, -2, 0.0F, 0.3125F, -1, 0, 0, packedLight, color);
        this.vertex(pose,  vertexConsumer, -7, 2, -2, 0.0F, 0.15625F, 1, 0, 0, packedLight, color);
        this.vertex(pose,  vertexConsumer, -7, 2, 2, 0.15625F, 0.15625F, 1, 0, 0, packedLight, color);
        this.vertex(pose,  vertexConsumer, -7, -2, 2, 0.15625F, 0.3125F, 1, 0, 0, packedLight, color);
        this.vertex(pose,  vertexConsumer, -7, -2, -2, 0.0F, 0.3125F, 1, 0, 0, packedLight, color);

        for (int r = 0; r < 4; ++r) {
            poseStack.method_22907(class_7833.field_40714.rotationDegrees(90.0F));
            this.vertex(pose, vertexConsumer, -8, -2, 0, 0.0F, 0.0F, 0, 1, 0, packedLight, color);
            this.vertex(pose, vertexConsumer, 8, -2, 0, 0.5F, 0.0F, 0, 1, 0, packedLight, color);
            this.vertex(pose, vertexConsumer, 8, 2, 0, 0.5F, 0.15625F, 0, 1, 0, packedLight, color);
            this.vertex(pose, vertexConsumer, -8, 2, 0, 0.0F, 0.15625F, 0, 1, 0, packedLight, color);
        }

        poseStack.method_22909();
        super.method_3936(entity, entityYaw, partialTicks, poseStack, buffer, packedLight);
    }

    public void vertex(class_4587.class_4665 pose, class_4588 consumer, int x, int y, int z, float u, float v, int normalX, int normalZ, int normalY, int packedLight, Color col) {
        consumer.method_56824(pose, (float) x, (float) y, (float) z).method_1336(col.getRed(), col.getGreen(), col.getBlue(), 255).method_22913(u, v).method_22922(class_4608.field_21444).method_60803(packedLight).method_60831(pose, (float) normalX, (float) normalY, (float) normalZ);
    }

    public class_2960 getTextureLocation(PokemonArrow entity) {
        return TEXTURE_LOCATION;
    }
}
