package me.rufia.fightorflight.client.renderer;

import me.rufia.fightorflight.CobblemonFightOrFlight;
import me.rufia.fightorflight.entity.PokemonAttackEffect;
import me.rufia.fightorflight.client.model.PokemonBulletModel;
import me.rufia.fightorflight.entity.projectile.PokemonTracingBullet;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5253;
import net.minecraft.class_5602;
import net.minecraft.class_5617;
import net.minecraft.class_7833;
import net.minecraft.class_897;
import java.awt.*;


public class PokemonTracingBulletRenderer extends class_897<PokemonTracingBullet> {
    private static final class_2960 TEXTURE_LOCATION = class_2960.method_60655(CobblemonFightOrFlight.MODID, "textures/entity/tracing_bullet_spark.png");
    private static final class_1921 RENDER_TYPE;
    private final PokemonBulletModel<PokemonTracingBullet> model;

    public PokemonTracingBulletRenderer(class_5617.class_5618 context) {
        super(context);
        this.model = new PokemonBulletModel<>(context.method_32167(class_5602.field_27597));
    }

    protected int getBlockLightLevel(PokemonTracingBullet entity, class_2338 pos) {
        return 15;
    }

    public void render(PokemonTracingBullet entity, float entityYaw, float partialTicks, class_4587 poseStack, class_4597 buffer, int packedLight) {
        Color color = Color.white;
        if (entity.getElementalType() != null) {
            color = PokemonAttackEffect.getColorFromType(entity.getElementalType());
        }

        poseStack.method_22903();
        float f = class_3532.method_17821(partialTicks, entity.field_5982, entity.method_36454());
        float g = class_3532.method_16439(partialTicks, entity.field_6004, entity.method_36455());
        float h = (float) entity.field_6012 + partialTicks;
        poseStack.method_46416(0.0F, 0.15F, 0.0F);
        poseStack.method_22907(class_7833.field_40716.rotationDegrees(class_3532.method_15374(h * 0.1F) * 180.0F));
        poseStack.method_22907(class_7833.field_40714.rotationDegrees(class_3532.method_15362(h * 0.1F) * 180.0F));
        poseStack.method_22907(class_7833.field_40718.rotationDegrees(class_3532.method_15374(h * 0.15F) * 360.0F));
        poseStack.method_22905(-0.5F, -0.5F, 0.5F);
        this.model.method_2819(entity, 0.0F, 0.0F, 0.0F, f, g);
        class_4588 vertexConsumer = buffer.getBuffer(this.model.method_23500(TEXTURE_LOCATION));
        this.model.method_60879(poseStack, vertexConsumer, packedLight, class_4608.field_21444);
        poseStack.method_22905(1.5F, 1.5F, 1.5F);
        class_4588 vertexConsumer2 = buffer.getBuffer(RENDER_TYPE);
        int colorCode = class_5253.class_5254.method_59554(0.75F, (float) color.getRed() / 255, (float) color.getGreen() / 255, (float) color.getBlue() / 255);
        this.model.method_2828(poseStack, vertexConsumer2, packedLight, class_4608.field_21444, colorCode);
        poseStack.method_22909();
        super.method_3936(entity, entityYaw, partialTicks, poseStack, buffer, packedLight);
    }

    public class_2960 getTextureLocation(PokemonTracingBullet entity) {
        return TEXTURE_LOCATION;
    }

    static {
        RENDER_TYPE = class_1921.method_23580(TEXTURE_LOCATION);
    }
}
