package me.rufia.fightorflight.entity.areaeffect;

import com.cobblemon.mod.common.api.moves.Move;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import me.rufia.fightorflight.CobblemonFightOrFlight;
import me.rufia.fightorflight.entity.IPokemonAttack;
import me.rufia.fightorflight.entity.PokemonAttackEffect;
import me.rufia.fightorflight.utils.PokemonUtils;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_3619;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.world.entity.*;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.Arrays;
import java.util.List;
import java.util.UUID;

public abstract class AbstractPokemonAreaEffect extends class_1297 implements IPokemonAttack {
    private static final class_2940<Float> DATA_RADIUS;
    private static final class_2940<Float> DATA_HEIGHT;
    private static final class_2940<String> DATA_TYPE;
    private static final class_2940<Boolean> DATA_WAITING;
    private static final class_2940<String> DATA_MOVE_NAME;
    protected int duration;
    protected int waitTime;
    protected boolean isInstant;
    protected boolean activated;
    @Nullable
    protected class_1309 owner;
    @Nullable
    protected UUID ownerUUID;


    public AbstractPokemonAreaEffect(class_1299<? extends AbstractPokemonAreaEffect> entityType, class_1937 level) {
        super(entityType, level);
        this.duration = 100;
        this.waitTime = 10;
        this.field_5960 = true;
        this.isInstant = false;
        this.activated = false;
    }

    public static AbstractPokemonAreaEffect tryToCreate(PokemonEntity owner, class_1309 target, Move move) {
        if (move == null) {
            return null;
        }
        String moveName = move.getName();
        boolean canFloat = Arrays.stream(CobblemonFightOrFlight.moveConfig().delayed_aoe_can_float).toList().contains(moveName);
        boolean isInstant = Arrays.stream(CobblemonFightOrFlight.moveConfig().delayed_aoe_is_instant).toList().contains(moveName);
        boolean isTornado = Arrays.stream(CobblemonFightOrFlight.moveConfig().delayed_aoe_rise_up_tornado).toList().contains(moveName);
        boolean isWhirlpool = Arrays.stream(CobblemonFightOrFlight.moveConfig().delayed_aoe_bounding_whirlpool).toList().contains(moveName);
        float r = class_3532.method_15363(owner.method_17681(), 1f, 3f) * 1.5f;
        AbstractPokemonAreaEffect aoe;
        if (isTornado) {
            aoe = new PokemonTornado(owner);
        } else if (isWhirlpool) {
            aoe = new PokemonWhirlPool(owner);
        } else {
            aoe = new PokemonAreaEffectMagic(owner);
        }

        aoe.setMoveName(moveName);
        aoe.setOwner(owner);
        aoe.init(target, 30, 10, canFloat, isInstant);
        aoe.refreshHeight();
        aoe.setRadius(r);

        return aoe;
    }


    public void init(class_1309 target, int duration, int waitTime, boolean canFloat, boolean isInstant) {
        this.duration = duration;
        this.waitTime = waitTime;
        this.isInstant = isInstant;

        if (canFloat) {
            method_33574(target.method_19538());
        } else {
            class_2338 blockPos = target.method_23312();
            int y = blockPos.method_10264();
            boolean yFound = false;
            while (!yFound && y > method_37908().method_31607()) {
                class_2680 blockState = target.method_37908().method_8320(blockPos);
                if (blockState.method_51366()) {
                    yFound = true;
                } else {
                    --y;
                    blockPos = blockPos.method_10074();
                }
            }
            if (yFound) {
                method_5814(target.method_23317(), y + 1, target.method_23321());
            }
        }
    }

    public void refreshHeight() {
        float r = getRadius();
        if (this instanceof PokemonTornado) {
            setHeight(r);
        } else {
            setHeight(0.5f);
        }
        //CobblemonFightOrFlight.LOGGER.info("AOE Height:{}", getHeight());
    }

    @Override
    public void method_5773() {
        super.method_5773();
        if (!method_37908().field_9236) {
            boolean wasWaiting = isWaiting();
            visualEffect();

            if (this.field_6012 > duration || getOwner() == null) {
                method_31472();
                return;
            }

            boolean isWaitingNow = field_6012 < waitTime;
            if (wasWaiting != isWaitingNow) {
                setWaiting(isWaitingNow);
            }

            if (isWaitingNow) {
                return;
            }

            if ((field_6012 + 1) % getApplicationTime() == 0) {
                if (!activated || !isInstant) {
                    activate();
                }
            }
        }
    }

    protected abstract void visualEffect();

    protected void activate() {
        if (!activated) {
            onActivated();
        }
        activated = true;
    }

    protected void onActivated() {
        playActivateSound();
    }

    protected void playActivateSound() {
        String typeName = getElementalType();
        if (typeName.equals("electric")) {
            method_5783(class_3417.field_14865, 4f, (1.0F + (method_37908().field_9229.method_43057() - method_37908().field_9229.method_43057()) * 0.2F) * 0.7F);
        } else if (typeName.equals("fire")) {
            method_5783(class_3417.field_14821, 4f, (1.0F + (method_37908().field_9229.method_43057() - method_37908().field_9229.method_43057()) * 0.2F) * 0.7F);
        } else if (typeName.equals("water")) {
            method_5783(class_3417.field_14737, 4f, (1.0F + (method_37908().field_9229.method_43057() - method_37908().field_9229.method_43057()) * 0.2F) * 0.7F);
        } else {
            playDefaultSound();
        }
    }

    protected void playDefaultSound() {
        method_5783(class_3417.field_15152.comp_349(), 3f, (1.0F + (method_37908().field_9229.method_43057() - method_37908().field_9229.method_43057()) * 0.2F) * 0.7F);
    }

    protected void dealDamageInTheArea() {
        if (owner instanceof PokemonEntity pokemonEntity && pokemonEntity.method_5805()) {
            List<class_1309> list = method_37908().method_18467(class_1309.class, this.method_5829());
            for (class_1309 target : list) {
                if (!PokemonUtils.pokemonTryForceEncounter(pokemonEntity, target)) {
                    Move move = PokemonUtils.findMove(pokemonEntity, getMoveName());
                    if (move != null) {
                        if (PokemonAttackEffect.shouldHurtAllyMob(pokemonEntity, target)) {
                            boolean success = target.method_5643(pokemonEntity.method_48923().method_48815(pokemonEntity, pokemonEntity), PokemonAttackEffect.calculatePokemonDamage(pokemonEntity, target, move));
                            PokemonUtils.setHurtByPlayer(pokemonEntity, target);
                            PokemonAttackEffect.applyOnHitVisualEffect(pokemonEntity, target, getMoveName());
                            PokemonAttackEffect.applyPostEffect(pokemonEntity, target, move, success);
                            applyExtraEffect(target);
                        }
                    }
                }
            }
        }
    }

    protected void applyExtraEffect(class_1309 target) {

    }

    public int getApplicationTime() {
        return 5;
    }

    public float getRadius() {
        return field_6011.method_12789(DATA_RADIUS);
    }

    public void setRadius(float r) {
        field_6011.method_12778(DATA_RADIUS, r);
    }

    public float getHeight() {
        return field_6011.method_12789(DATA_HEIGHT);
    }

    public void setHeight(float h) {
        field_6011.method_12778(DATA_HEIGHT, h);
    }

    public boolean isActivated() {
        return activated;
    }

    @Override
    public @NotNull class_3619 method_5657() {
        return class_3619.field_15975;
    }

    @Override
    public @NotNull class_4048 method_18377(class_4050 pose) {
        //CobblemonFightOrFlight.LOGGER.info("AOE Height before refreshing dimensions:{}", height);
        return class_4048.method_18384(getRadius() * 2.0F, getHeight());
    }

    @Override
    public void method_18382() {
        double d = this.method_23317();
        double e = this.method_23318();
        double f = this.method_23321();
        super.method_18382();
        this.method_5814(d, e, f);
    }

    @Override
    protected void method_5693(class_2945.class_9222 builder) {
        builder.method_56912(DATA_RADIUS, 3f);
        builder.method_56912(DATA_HEIGHT, 0.5f);
        builder.method_56912(DATA_TYPE, "normal");
        builder.method_56912(DATA_WAITING, true);
        builder.method_56912(DATA_MOVE_NAME, "");
    }

    @Override
    public void method_5674(class_2940<?> dataAccessor) {
        if (DATA_RADIUS.equals(dataAccessor)) {
            this.method_18382();
        }

        super.method_5674(dataAccessor);
    }

    @Override
    protected void method_5749(class_2487 compound) {
        field_6012 = compound.method_10550("Age");
        duration = compound.method_10550("Duration");
        waitTime = compound.method_10550("WaitTime");
        setHeight(compound.method_10583("Height"));
        setRadius(compound.method_10583("Radius"));
        if (compound.method_25928("Owner")) {
            this.ownerUUID = compound.method_25926("Owner");
        }
    }

    @Override
    protected void method_5652(class_2487 compound) {
        compound.method_10569("Age", field_6012);
        compound.method_10569("Duration", duration);
        compound.method_10569("WaitTime", waitTime);
        compound.method_10548("Radius", getRadius());
        compound.method_10548("Height", getHeight());
        if (ownerUUID != null) {
            compound.method_25927("Owner", this.ownerUUID);
        }
    }

    public void setOwner(@Nullable class_1309 owner) {
        this.owner = owner;
        this.ownerUUID = owner == null ? null : owner.method_5667();
    }

    @Nullable
    public class_1309 getOwner() {
        if (this.owner == null && this.ownerUUID != null && this.method_37908() instanceof class_3218) {
            class_1297 entity = ((class_3218) this.method_37908()).method_14190(this.ownerUUID);
            if (entity instanceof class_1309) {
                this.owner = (class_1309) entity;
            }
        }

        return this.owner;
    }

    @Override
    public String getElementalType() {
        return field_6011.method_12789(DATA_TYPE);
    }

    @Override
    public void setElementalType(String type) {
        field_6011.method_12778(DATA_TYPE, type);
    }

    protected void setWaiting(boolean waiting) {
        this.method_5841().method_12778(DATA_WAITING, waiting);
    }

    public boolean isWaiting() {
        return this.method_5841().method_12789(DATA_WAITING);
    }

    public void setMoveName(String moveName) {
        field_6011.method_12778(DATA_MOVE_NAME, moveName);
    }

    public String getMoveName() {
        return field_6011.method_12789(DATA_MOVE_NAME);
    }

    public int getDuration() {
        return duration;
    }

    public int getWaitTime() {
        return waitTime;
    }

    static {
        DATA_RADIUS = class_2945.method_12791(AbstractPokemonAreaEffect.class, class_2943.field_13320);
        DATA_HEIGHT = class_2945.method_12791(AbstractPokemonAreaEffect.class, class_2943.field_13320);
        DATA_TYPE = class_2945.method_12791(AbstractPokemonAreaEffect.class, class_2943.field_13326);
        DATA_WAITING = class_2945.method_12791(AbstractPokemonAreaEffect.class, class_2943.field_13323);
        DATA_MOVE_NAME = class_2945.method_12791(AbstractPokemonAreaEffect.class, class_2943.field_13326);
    }
}
