package me.rufia.fightorflight.entity.areaeffect;

import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import me.rufia.fightorflight.entity.EntityFightOrFlight;
import me.rufia.fightorflight.entity.PokemonAttackEffect;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1937;

public class PokemonAreaEffectMagic extends AbstractPokemonAreaEffect {
    public PokemonAreaEffectMagic(class_1299<? extends AbstractPokemonAreaEffect> entityType, class_1937 level) {
        super(entityType, level);
    }

    public PokemonAreaEffectMagic(class_1309 owner) {
        super(EntityFightOrFlight.MAGIC_EFFECT.get(), owner.method_37908());
        setOwner(owner);
    }

    @Override
    protected void visualEffect() {
        if (owner instanceof PokemonEntity) {
            if (isWaiting()) {
                PokemonAttackEffect.makeTypeEffectParticle(6, this, getElementalType());
            }
        }
    }

    @Override
    protected void activate() {
        super.activate();
        if (owner instanceof PokemonEntity pokemonEntity && pokemonEntity.method_5805()) {
            dealDamageInTheArea();
        } else {
            method_31472();
        }
    }
}
