package me.rufia.fightorflight.goals;

import F;
import com.cobblemon.mod.common.api.moves.Move;
import com.cobblemon.mod.common.battles.BattleRegistry;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.activestate.ShoulderedState;
import me.rufia.fightorflight.CobblemonFightOrFlight;
import me.rufia.fightorflight.PokemonInterface;
import me.rufia.fightorflight.entity.PokemonAttackEffect;
import me.rufia.fightorflight.utils.FOFUtils;
import me.rufia.fightorflight.utils.PokemonUtils;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1352;
import net.minecraft.class_2338;
import net.minecraft.class_2398;
import net.minecraft.class_3222;
import java.util.Arrays;
import java.util.EnumSet;

public class PokemonAttackGoal extends class_1352 {
    private int ticksUntilNewAngerParticle = 0;
    private int ticksUntilNewAngerCry = 0;

    private int seeTime;
    private final float attackRadiusSqr;

    private boolean strafingClockwise;
    private boolean strafingBackwards;
    private int strafingTime = -1;

    private int ticksUntilNextPathFinding = 0;

    private final double speedModifier;

    protected PokemonEntity pokemonEntity;
    private class_1309 target;

    public PokemonAttackGoal(PokemonEntity pokemonEntity, double speedModifier) {
        this.pokemonEntity = pokemonEntity;
        this.speedModifier = speedModifier;

        attackRadiusSqr = 64;
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18406, class_1352.class_4134.field_18405));
    }

    protected void setAttackTime(int i) {
        ((PokemonInterface) pokemonEntity).setAttackTime(i);
    }

    protected int getAttackTime() {
        return ((PokemonInterface) pokemonEntity).getAttackTime();
    }

    protected void resetAttackTime(double d) {
        PokemonAttackEffect.resetAttackTime(pokemonEntity, d);
    }

    @Override
    public boolean method_38846() {
        return true;
    }

    @Override
    public void method_6268() {
        super.method_6268();
        class_1309 owner = pokemonEntity.method_35057();
        angerEffectUpdate(owner);
        ticksUntilNextPathFinding = Math.max(ticksUntilNextPathFinding - 1, 0);
        if (!tryToUseAdvancedMechanic()) {
            if (PokemonUtils.shouldMelee(pokemonEntity)) {
                meleePathFinding();
                checkAndPerformAttack(target);
            } else if (PokemonUtils.shouldShoot(pokemonEntity)) {
                rangeAttackTick();
            }
        }
        changeMoveSpeed();
    }

    @Override
    public boolean method_6264() {
        if (PokemonUtils.moveCommandAvailable(pokemonEntity) || pokemonEntity.getPokemon().getState() instanceof ShoulderedState) {
            return false;
        }
        if (PokemonUtils.shouldShoot(pokemonEntity) || PokemonUtils.shouldMelee(pokemonEntity)) {
            class_1309 livingEntity = pokemonEntity.method_5968();
            if (livingEntity != null && livingEntity.method_5805() && PokemonUtils.shouldFightTarget(pokemonEntity)) {
                target = livingEntity;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean method_6266() {
        if (target == null || !(PokemonUtils.shouldShoot(pokemonEntity) || PokemonUtils.shouldMelee(pokemonEntity))) {
            return false;
        }
        return (method_6264() || !pokemonEntity.method_5942().method_6357()) && !isTargetInBattle();
    }

    @Override
    public void method_6270() {
        target = null;
        seeTime = 0;
        pokemonEntity.method_5942().method_6340();
    }

    private void angerEffectUpdate(class_1309 owner) {
        if (owner == null) {
            if (ticksUntilNewAngerParticle < 1) {
                CobblemonFightOrFlight.PokemonEmoteAngry(pokemonEntity);
                ticksUntilNewAngerParticle = 10;
            } else {
                ticksUntilNewAngerParticle -= 1;
            }

            if (ticksUntilNewAngerCry < 1) {
                pokemonEntity.cry();
                ticksUntilNewAngerCry = 100 + (int) (Math.random() * 200);
            } else {
                ticksUntilNewAngerCry -= 1;
            }
        }
    }

    //Return true if advanced mechanic is triggered
    private boolean tryToUseAdvancedMechanic() {
        int tickCount = pokemonEntity.field_6012;
        if ((tickCount - 11) % 20 == 0 && target != null && getAttackTime() == 0) {
            Move move = PokemonUtils.getMove(pokemonEntity);
            if (move != null) {
                //TODO I can predicate that this will be changed in the future.
                String moveName = move.getName();
                if (Arrays.stream(CobblemonFightOrFlight.moveConfig().quick_attack_like_move).toList().contains(moveName)) {
                    float distance = pokemonEntity.method_5739(target);
                    if (distance >= 1.5f && distance <= 10f) {
                        class_2338 targetBlockPos = target.method_24515();
                        if (FOFUtils.multiSamplingCollisionCheckBlock(pokemonEntity, target, 5, 3)) {
                            PokemonUtils.makeParticle(4, pokemonEntity, class_2398.field_46911);
                            pokemonEntity.method_5859(targetBlockPos.method_10263(), targetBlockPos.method_10264(), targetBlockPos.method_10260());
                            PokemonUtils.makeParticle(4, target, class_2398.field_46911);
                        }
                    } else {
                        meleePathFinding();
                    }
                }
            }
        }

        return false;
    }


    private void changeMoveSpeed() {
        if (!CobblemonFightOrFlight.commonConfig().do_pokemon_attack_in_battle && isTargetInBattle()) {
            pokemonEntity.method_5942().method_6344(0);
        } else {
            pokemonEntity.method_5942().method_6344(speedModifier);
        }
    }

    public boolean isTargetInBattle() {
        if (pokemonEntity.method_5968() instanceof class_3222 targetAsPlayer) {
            return BattleRegistry.INSTANCE.getBattleByParticipatingPlayer(targetAsPlayer) != null;
        }
        return false;
    }

    private void meleePathFinding() {
        if (ticksUntilNextPathFinding <= 0) {
            ticksUntilNextPathFinding = 4 + pokemonEntity.method_59922().method_43048(7);
            var distance = pokemonEntity.method_5739(target);
            if (distance > 256) {
                ticksUntilNextPathFinding += 10;
            }
            if (!pokemonEntity.method_5942().method_6335(target, speedModifier)) {
                ticksUntilNextPathFinding += 15;
            }
        }
    }

    private void rangeAttackPathFinding(boolean canSee, double distance) {
        if (!(distance > (double) attackRadiusSqr) && seeTime >= 5 && canSee) {
            pokemonEntity.method_5942().method_6340();
            ++strafingTime;
        } else {
            pokemonEntity.method_5942().method_6335(target, speedModifier);
            strafingTime = -1;
        }
        if (strafingTime >= 10) {
            if ((double) pokemonEntity.method_59922().method_43057() < 0.3) {
                strafingClockwise = !strafingClockwise;
            }
            if ((double) pokemonEntity.method_59922().method_43057() < 0.3) {
                strafingBackwards = !strafingBackwards;
            }
            strafingTime = 0;
        }
        if (strafingTime > -1) {
            if (distance > (double) (attackRadiusSqr * 0.8F)) {
                strafingBackwards = false;
            } else if (distance < (double) (attackRadiusSqr * 0.2F)) {
                strafingBackwards = true;
            }
            pokemonEntity.method_5962().method_6243(strafingBackwards ? -0.5F : 0.5F, strafingClockwise ? 0.5F : -0.5F);
            class_1297 vehicle = pokemonEntity.method_49694();
            if (vehicle instanceof class_1308 mob) {
                mob.method_5951(pokemonEntity, 30.0F, 30.0F);
            }
        }
        pokemonEntity.method_5988().method_35111(target);
    }

    protected boolean canPerformAttack(class_1309 entity) {
        return getAttackTime() == 0 && pokemonEntity.method_42150(entity) && pokemonEntity.method_5985().method_6369(entity);
    }

    protected void checkAndPerformAttack(class_1309 target) {
        if (canPerformAttack(target)) {
            resetAttackTime(0);
            PokemonAttackEffect.resetAttackTime(pokemonEntity, 1);
            pokemonDoHurtTarget(target);
        }
    }

    public boolean pokemonDoHurtTarget(class_1297 hurtTarget) {
        if (!CobblemonFightOrFlight.commonConfig().do_pokemon_attack_in_battle) {
            if (isTargetInBattle()) {
                return false;
            }
        }
        //CobblemonFightOrFlight.LOGGER.info("Trying to use melee attack");
        if (!PokemonUtils.pokemonTryForceEncounter(pokemonEntity, hurtTarget)) {
            Move move = PokemonUtils.getMove(pokemonEntity);
            if (move != null) {
                if (Arrays.stream(CobblemonFightOrFlight.moveConfig().self_centered_aoe_moves).toList().contains(move.getName())) {
                    PokemonAttackEffect.dealAoEDamage(pokemonEntity, pokemonEntity, true, PokemonUtils.isMeleeAttackMove(move));
                    if (PokemonUtils.isPhysicalMove(move)) {
                        PokemonUtils.sendAnimationPacket(pokemonEntity, "physical");
                    } else {
                        PokemonUtils.sendAnimationPacket(pokemonEntity, "special");
                    }
                    return true;
                }
            }
            PokemonUtils.sendAnimationPacket(pokemonEntity, "physical");
            return PokemonAttackEffect.pokemonAttack(pokemonEntity, hurtTarget);
        }

        return false;
    }

    private void rangeAttackTick() {
        double d = pokemonEntity.method_5649(target.method_23317(), target.method_23318(), target.method_23321());
        boolean canSee = pokemonEntity.method_5985().method_6369(target);
        if (canSee) {
            ++seeTime;
        } else {
            seeTime = 0;
            resetAttackTime(d);
        }
        rangeAttackPathFinding(canSee, d);
        if (getAttackTime() == 7 && (((PokemonInterface) pokemonEntity).usingSound())) {
            PokemonUtils.createSonicBoomParticle(pokemonEntity, target);
        }
        if (getAttackTime() % 5 == 0 && (((PokemonInterface) pokemonEntity).usingMagic())) {
            PokemonAttackEffect.makeMagicAttackParticle(pokemonEntity, target);
        }
        if (getAttackTime() == 0) {
            if (!canSee) {
                return;
            }
            resetAttackTime(d);
            performRangedAttack(target);
        } else if (getAttackTime() < 0) {
            resetAttackTime(d);
        }
    }

    protected void performRangedAttack(class_1309 target) {
        PokemonAttackEffect.pokemonPerformRangedAttack(pokemonEntity, target);
    }
}
