package me.rufia.fightorflight.goals.targeting;

import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import me.rufia.fightorflight.PokemonInterface;
import me.rufia.fightorflight.item.component.PokeStaffComponent;
import me.rufia.fightorflight.utils.PokemonUtils;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1400;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PokemonCommandedTargetGoal<T extends class_1309> extends class_1400<T> {
    protected PokemonEntity pokemonEntity;
    protected float safeDistanceSqr = 64;

    public PokemonCommandedTargetGoal(class_1308 mob, Class<T> targetType, boolean mustSee) {
        super(mob, targetType, 5, mustSee, false, (entity) -> {
            if (entity == mob) {
                return false;
            }
            if (mob instanceof PokemonEntity pokemonEntity) {
                if (PokemonUtils.getCommandMode(pokemonEntity).equals(PokeStaffComponent.CMDMODE.ATTACK)) {
                    String data = ((PokemonInterface) (Object) pokemonEntity).getCommandData();
                    if (data.startsWith("ENTITY_")) {
                        Pattern pattern = Pattern.compile("ENTITY_([a-z\\d]{8}-[a-z\\d]{4}-[a-z\\d]{4}-[a-z\\d]{4}-[a-z\\d]{12})");
                        Matcher m = pattern.matcher(data);
                        if (m.find()) {
                            //CobblemonFightOrFlight.LOGGER.info(m.group(1));
                            return entity.method_5845().equals(m.group(1));
                        }
                    }
                }
            }
            return false;
        });
        pokemonEntity = (PokemonEntity) mob;
    }

    public void method_6270() {
        PokemonUtils.clearCommand(pokemonEntity);
    }

    @Override
    public boolean method_6264() {
        if (pokemonEntity.isBusy() || pokemonEntity.method_35057() == null) {
            return false;
        }
        return super.method_6264();
    }
}
