package me.rufia.fightorflight.goals.targeting;

import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.activestate.ShoulderedState;
import me.rufia.fightorflight.CobblemonFightOrFlight;
import me.rufia.fightorflight.compat.LivelierPokemonCompat;
import me.rufia.fightorflight.utils.TargetingWhitelist;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1400;
import net.minecraft.class_1548;
import net.minecraft.class_5354;
import org.jetbrains.annotations.Nullable;

import java.util.Objects;
import java.util.function.Predicate;

public class PokemonProactiveTargetGoal<T extends class_1309> extends class_1400<T> {

    public float safeDistanceSqr;

    public PokemonProactiveTargetGoal(class_1308 mob, Class<T> targetType, float safeDistanceSqr, int randomInterval, boolean mustSee, boolean mustReach, @Nullable Predicate<class_1309> targetPredicate) {
        super(mob, targetType, randomInterval, mustSee, mustReach, targetPredicate);
        this.safeDistanceSqr = safeDistanceSqr;
    }

    public boolean method_6264() {
        if (!CobblemonFightOrFlight.commonConfig().do_pokemon_defend_proactive) {
            return false;
        }
        PokemonEntity pokemonEntity = (PokemonEntity) this.field_6660;
        if (pokemonEntity.getPokemon().getState() instanceof ShoulderedState) {
            return false;
        }
        if (!pokemonEntity.getPokemon().isPlayerOwned()) {
            return false;
        }

        return super.method_6264();
    }

    protected void method_18415() {
        super.method_18415();
        if (!(field_6660 instanceof PokemonEntity pokemonEntity)) {
            return;
        }

        if (this.field_6644 != null) {
            if (this.field_6644.method_5858(this.field_6660) > safeDistanceSqr) {
                this.field_6644 = null;
            } else if (TargetingWhitelist.getWhitelist(pokemonEntity).contains(field_6644.method_5653())) {
                this.field_6644 = null;
            } else if (field_6644 instanceof class_1548 && !(CobblemonFightOrFlight.commonConfig().do_pokemon_defend_creeper_proactive || (CobblemonFightOrFlight.commonConfig().do_cat_pokemon_defend_creeper_proactive && LivelierPokemonCompat.isLoaded() && LivelierPokemonCompat.getCats().contains(pokemonEntity.getPokemon().getSpecies().getName())))) {
                this.field_6644 = null;
            } else if (CobblemonFightOrFlight.commonConfig().pokemon_proactive_level == 1) {
                if (field_6644 instanceof class_5354 neutralMob) {
                    var mobTarget = neutralMob.method_5968();
                    if (!Objects.equals(mobTarget, pokemonEntity.method_35057())) {
                        this.field_6644 = null;
                    }
                }
            }
        }
    }
}
