package me.rufia.fightorflight.item;

import com.cobblemon.mod.common.CobblemonItems;
import com.cobblemon.mod.common.api.moves.Move;
import com.cobblemon.mod.common.client.CobblemonClient;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import dev.architectury.networking.NetworkManager;
import me.rufia.fightorflight.PokemonInterface;
import me.rufia.fightorflight.item.component.ItemComponentFOF;
import me.rufia.fightorflight.item.component.PokeStaffComponent;
import me.rufia.fightorflight.net.packet.SendCommandPacket;
import me.rufia.fightorflight.net.packet.SendMoveSlotPacket;
import me.rufia.fightorflight.utils.FOFUtils;
import me.rufia.fightorflight.utils.RayTrace;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import java.util.List;
import java.util.Objects;

public class PokeStaff extends class_1792 {
    public PokeStaff(class_1792.class_1793 properties) {
        super(properties);
    }

    @Override
    public void method_7851(class_1799 stack, class_9635 context, List<class_2561> tooltipComponents, class_1836 isAdvanced) {
        String mode = getMode(stack);
        if (!mode.isEmpty()) {
            int d = getMoveSlot(stack);
            String cmdMode = getCommandMode(stack);
            class_2561 component;
            //CobblemonFightOrFlight.LOGGER.info(mode);
            switch (PokeStaffComponent.MODE.valueOf(mode)) {
                case SEND -> component = class_2561.method_43471("item.fightorflight.pokestaff.mode.send");
                case SETMOVE -> component = class_2561.method_43471("item.fightorflight.pokestaff.mode.selectmoveslot");
                case SETCMDMODE ->
                        component = class_2561.method_43471("item.fightorflight.pokestaff.mode.selectcommand");
                default -> component = class_2561.method_43470("");
            }

            tooltipComponents.add(class_2561.method_43471("item.fightorflight.pokestaff.desc1").method_10852(component));
            tooltipComponents.add(class_2561.method_43469("item.fightorflight.pokestaff.desc2", d + 1));
            tooltipComponents.add(class_2561.method_43469("item.fightorflight.pokestaff.desc3", getTranslatedCmdModeName(cmdMode).getString()));
        }
    }

    @Override
    public class_1271<class_1799> method_7836(class_1937 level, class_1657 player, class_1268 usedHand) {
        class_1799 stack = player.method_5998(usedHand);

        if (player.method_21823()) {
            setMode(stack, PokeStaffComponent.getNextMode(getMode(stack)));
            switch (PokeStaffComponent.MODE.valueOf(getMode(stack))) {
                case SETMOVE -> {
                    if (player.method_37908().field_9236) {
                        player.method_43496(class_2561.method_43471("item.fightorflight.pokestaff.mode.selectmoveslot"));
                    }
                }
                case SEND -> {
                    if (player.method_37908().field_9236) {
                        player.method_43496(class_2561.method_43471("item.fightorflight.pokestaff.mode.send"));
                    }
                }
                case SETCMDMODE -> {
                    if (player.method_37908().field_9236) {
                        player.method_43496(class_2561.method_43471("item.fightorflight.pokestaff.mode.selectcommand"));
                    }
                }
            }
            return class_1271.method_22427(player.method_5998(usedHand));
        }

        String mode = getMode(stack);
        if (mode.equals(PokeStaffComponent.MODE.SETMOVE.name())) {
            //CobblemonFightOrFlight.LOGGER.info("SELECTING MOVES");
            int nextMoveSlot = getMoveSlot(stack) + 1;
            setMoveSlot(stack, nextMoveSlot);
            setCommandMode(stack, PokeStaffComponent.CMDMODE.NOCMD.name());
            if (player.method_37908().field_9236) {
                player.method_43496(class_2561.method_43469("item.fightorflight.pokestaff.desc2", nextMoveSlot % 4 + 1));
            }
        }
        if (mode.equals(PokeStaffComponent.MODE.SETCMDMODE.name())) {
            commandModeSelectNext(stack, getCommandMode(stack));
            setMoveSlot(stack, -1);
            if (player.method_37908().field_9236) {
                player.method_43496(getTranslatedCmdModeName(getCommandMode(stack)));
            }
        }

        if (mode.equals(PokeStaffComponent.MODE.SEND.name())) {
            //CobblemonFightOrFlight.LOGGER.info("SENDING COMMAND");
            PokeStaffComponent.CMDMODE cmdmode = PokeStaffComponent.CMDMODE.valueOf(getCommandMode(stack));
            String cmdData = FOFUtils.createCommandData(player, cmdmode);

            if (player.method_37908().field_9236) {
                int slot = CobblemonClient.INSTANCE.getStorage().getSelectedSlot();
                if (!Objects.equals(getCommandMode(stack), PokeStaffComponent.CMDMODE.NOCMD.name())) {
                    NetworkManager.sendToServer(new SendCommandPacket(slot, getCommandMode(stack), cmdData, true));
                } else {
                    NetworkManager.sendToServer(new SendMoveSlotPacket(slot, getMoveSlot(stack), true));
                }
            }
        }
        return class_1271.method_22427(player.method_5998(usedHand));
    }

    @Override
    public void method_7888(class_1799 stack, class_1937 level, class_1297 entity, int slotId, boolean isSelected) {
        super.method_7888(stack, level, entity, slotId, isSelected);
    }

    protected String getMode(class_1799 itemStack) {
        if (itemStack.method_57826(ItemComponentFOF.POKE_STAFF_COMMAND_MODE_COMPONENT)) {
            PokeStaffComponent component = itemStack.method_57824(ItemComponentFOF.POKE_STAFF_COMMAND_MODE_COMPONENT);
            if (component != null) {
                return component.mode();//if it has the component it shouldn't be null, I'm not sure.
            }
        }
        return "";
    }

    public int getMoveSlot(class_1799 itemStack) {
        if (itemStack.method_57826(ItemComponentFOF.POKE_STAFF_COMMAND_MODE_COMPONENT)) {
            PokeStaffComponent component = itemStack.method_57824(ItemComponentFOF.POKE_STAFF_COMMAND_MODE_COMPONENT);
            if (component != null) {
                return component.moveSlot();//if it has the component it shouldn't be null, I'm not sure.
            }
        }
        return -1;
    }

    public String getCommandMode(class_1799 itemStack) {
        if (itemStack.method_57826(ItemComponentFOF.POKE_STAFF_COMMAND_MODE_COMPONENT)) {
            PokeStaffComponent component = itemStack.method_57824(ItemComponentFOF.POKE_STAFF_COMMAND_MODE_COMPONENT);
            if (component != null) {
                return component.cmdmode();//if it has the component it shouldn't be null, I'm not sure.
            }
        }
        return PokeStaffComponent.CMDMODE.NOCMD.name();
    }

    @Override
    public boolean method_7838(class_1799 stack) {
        return true;
    }

    public void setMoveSlot(class_1799 stack, int moveSlot) {
        if (stack.method_57826(ItemComponentFOF.POKE_STAFF_COMMAND_MODE_COMPONENT)) {
            PokeStaffComponent component = stack.method_57824(ItemComponentFOF.POKE_STAFF_COMMAND_MODE_COMPONENT);
            if (component != null) {
                component.setMoveSlot(moveSlot % 4, stack);//if it has the component it shouldn't be null, I'm not sure.
            }
        }
    }

    public void setCommandMode(class_1799 stack, String mode) {
        if (stack.method_57826(ItemComponentFOF.POKE_STAFF_COMMAND_MODE_COMPONENT)) {
            PokeStaffComponent component = stack.method_57824(ItemComponentFOF.POKE_STAFF_COMMAND_MODE_COMPONENT);
            if (component != null) {
                component.setCmdmode(mode, stack);//if it has the component it shouldn't be null, I'm not sure.
            }
        }
    }

    public void setMode(class_1799 stack, String mode) {
        if (stack.method_57826(ItemComponentFOF.POKE_STAFF_COMMAND_MODE_COMPONENT)) {
            PokeStaffComponent component = stack.method_57824(ItemComponentFOF.POKE_STAFF_COMMAND_MODE_COMPONENT);
            if (component != null) {
                component.setMode(mode, stack);//if it has the component it shouldn't be null, I'm not sure.
            }
        }
    }

    protected void commandModeSelectNext(class_1799 stack, String mode) {
        String cmd;
        switch (PokeStaffComponent.CMDMODE.valueOf(mode)) {
            case MOVE_ATTACK -> cmd = PokeStaffComponent.CMDMODE.MOVE.name();
            case MOVE -> cmd = PokeStaffComponent.CMDMODE.STAY.name();
            case STAY -> cmd = PokeStaffComponent.CMDMODE.ATTACK.name();
            case ATTACK -> cmd = PokeStaffComponent.CMDMODE.ATTACK_POSITION.name();
            case ATTACK_POSITION -> cmd = PokeStaffComponent.CMDMODE.NOCMD.name();
            case NOCMD -> cmd = PokeStaffComponent.CMDMODE.CLEAR.name();
            case CLEAR -> cmd = PokeStaffComponent.CMDMODE.MOVE_ATTACK.name();
            default -> cmd = PokeStaffComponent.CMDMODE.NOCMD.name();
        }
        setCommandMode(stack, cmd);
    }

    public static class_2561 getTranslatedCmdModeName(String cmdModeName) {
        class_2561 component;
        switch (PokeStaffComponent.CMDMODE.valueOf(cmdModeName)) {
            case MOVE_ATTACK -> component = class_2561.method_43471("item.fightorflight.pokestaff.command.move_attack");
            case MOVE -> component = class_2561.method_43471("item.fightorflight.pokestaff.command.move");
            case STAY -> component = class_2561.method_43471("item.fightorflight.pokestaff.command.stay");
            case ATTACK -> component = class_2561.method_43471("item.fightorflight.pokestaff.command.attack_target");
            case ATTACK_POSITION ->
                    component = class_2561.method_43471("item.fightorflight.pokestaff.command.attack_position");
            case CLEAR -> component = class_2561.method_43471("item.fightorflight.pokestaff.command.clear_cmd");
            default -> component = class_2561.method_43471("item.fightorflight.pokestaff.command.no_cmd");
        }
        return component;
    }

    @Override
    public boolean method_7870(class_1799 stack) {
        return false;
    }
}
