package me.rufia.fightorflight.mixin;

import com.cobblemon.mod.common.api.entity.PokemonSideDelegate;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.entity.pokemon.PokemonServerDelegate;
import me.rufia.fightorflight.CobblemonFightOrFlight;
import me.rufia.fightorflight.utils.PokemonUtils;
import net.minecraft.class_5134;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(PokemonServerDelegate.class)
public abstract class PokemonServerDelegateMixin implements PokemonSideDelegate {
    @Shadow(remap = false)
    public PokemonEntity entity;

    @Inject(method = "updateMaxHealth", at = @At("HEAD"), cancellable = true, remap = false)
    public void updateMaxHealthMixin(CallbackInfo ci) {
        //Attention: this mixin influences the init of max health and the health sync from pokemon to pokemon entity.
        if (CobblemonFightOrFlight.commonConfig().shouldOverrideUpdateMaxHealth) {
            if (entity.getPokemon().getSpecies().getName().equals("shedinja")) {
                entity.method_5996(class_5134.field_23716).method_6192(1.0);
                entity.method_6033(1.0f);//if you can send it, it should be alive,right?
            } else {
                int hpStat = entity.getPokemon().getMaxHealth();
                int currentHealth = entity.getPokemon().getCurrentHealth();
                int entityMaxHealth = PokemonUtils.getMaxHealth(entity);
                boolean notUpdated = entityMaxHealth != 20 && entity.method_6063() == 20;//Attention: I'm not sure what bugs it might cause currently
                float newHealth = entity.method_35057() == null && !CobblemonFightOrFlight.commonConfig().enable_health_sync_for_wild_pokemon ? (notUpdated ? entityMaxHealth : entity.method_6032()) : Math.round((float) currentHealth / hpStat * entityMaxHealth);
                entity.method_5996(class_5134.field_23716).method_6192(entityMaxHealth);
                entity.method_6033(currentHealth > 0 && newHealth == 0 ? 1 : newHealth);
            }
            ci.cancel();
        }
    }
}
