package me.rufia.fightorflight.net.handler;

import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import dev.architectury.networking.NetworkManager;
import me.rufia.fightorflight.PokemonInterface;
import me.rufia.fightorflight.item.PokeStaff;
import me.rufia.fightorflight.item.component.PokeStaffComponent;
import me.rufia.fightorflight.net.packet.SendCommandPacket;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2561;

public class SendCommandHandler extends PokeStaffCmdHandler<SendCommandPacket> {
    private String cmdData;
    private String cmdMode;

    @Override
    public void handle(SendCommandPacket packet, NetworkManager.PacketContext context) {
        cmdData = packet.getCommandData();
        cmdMode = packet.getCommand();
        handlePacket(packet, context);
    }

    @Override
    protected void editStaff(class_1799 stack, SendCommandPacket packet) {
        PokeStaff staff = (PokeStaff) stack.method_7909();
        if (!packet.isFromPokeStaff()) {
            staff.setMoveSlot(stack, -1);
            staff.setCommandMode(stack, cmdMode);
            staff.setMode(stack, PokeStaffComponent.MODE.SEND.name());
        }
    }

    @Override
    protected void finalProcess(PokemonEntity pokemonEntity, class_1657 player, SendCommandPacket packet) {
        ((PokemonInterface) pokemonEntity).setCommand(cmdMode);
        ((PokemonInterface) pokemonEntity).setCommandData(cmdData);
        player.method_43496(class_2561.method_43469("item.fightorflight.pokestaff.command", pokemonEntity.getPokemon().getDisplayName(), PokeStaff.getTranslatedCmdModeName(cmdMode)));
    }
}
