package me.rufia.fightorflight.utils;

import me.rufia.fightorflight.CobblemonFightOrFlight;
import me.rufia.fightorflight.data.movedata.MoveData;
import me.rufia.fightorflight.item.component.PokeStaffComponent;
import net.minecraft.class_1309;
import net.minecraft.class_1321;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_5819;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FOFUtils {
    public static class_2382 stringToVec3i(String data) {
        if (data.startsWith("VEC3i_")) {
            Pattern p = Pattern.compile("VEC3i_([-\\d]*)_([-\\d]*)_([-\\d]*)");//I know it's not safe, but who will send other data?
            Matcher m = p.matcher(data);
            if (m.find()) {
                try {
                    int x = Integer.parseInt(m.group(1));
                    int y = Integer.parseInt(m.group(2));
                    int z = Integer.parseInt(m.group(3));
                    return new class_2382(x, y, z);
                    //CobblemonFightOrFlight.LOGGER.info("Generated position:x: %d y: %d z: %d".formatted(x, y, z));
                } catch (NumberFormatException e) {
                    CobblemonFightOrFlight.LOGGER.warn("Failed to converse the vec");
                }
            }
        }
        return null;
    }

    public static String createCommandData(class_1657 player, PokeStaffComponent.CMDMODE cmdmode) {
        String cmdData = "";
        switch (cmdmode) {
            case MOVE, ATTACK_POSITION, MOVE_ATTACK -> {
                class_3965 result = RayTrace.rayTraceBlock(player, 16);
                class_2338 blockPos = result.method_17777();
                //CobblemonFightOrFlight.LOGGER.info("VEC3_%s_%s_%s".formatted(blockPos.getX(), blockPos.getY(), blockPos.getZ()));
                cmdData = "VEC3i_%s_%s_%s".formatted(blockPos.method_10263(), blockPos.method_10264(), blockPos.method_10260());
            }
            case ATTACK -> {
                class_1309 livingEntity = RayTrace.rayTraceEntity(player, 16);
                if (livingEntity != null) {
                    cmdData = "ENTITY_%s".formatted(livingEntity.method_5845());
                    //CobblemonFightOrFlight.LOGGER.info("ENTITY_%s".formatted(livingEntity.getStringUUID()));
                }
            }
            case STAY -> cmdData = "POS_SELF";
            default -> cmdData = "";
        }
        return cmdData;
    }

    public static boolean chanceTest(List<Boolean> conditions, List<Float> chances, class_5819 source) {
        if (conditions.size() != chances.size()) {
            CobblemonFightOrFlight.LOGGER.info("The size of the two arrays are not the same");
            return false;
        }
        float chance = source.method_43057();
        for (int i = 0; i < conditions.size(); ++i) {
            if (conditions.get(i)) {
                return chances.get(i) > chance;
            }
        }
        return false;
    }

    public static float toAngle(double num) {
        return (float) (num * 57.2957763671875);
    }

    public static float toRad(double num) {
        return (float) (num / 180 * 3.1415927f);
    }

    public static void registerMoveData(String moveName, MoveData data) {
        if (MoveData.moveData.containsKey(moveName)) {
            if (MoveData.moveData.get(moveName) != null) {
                MoveData.moveData.get(moveName).add(data);
            }
        } else {
            MoveData.moveData.put(moveName, new ArrayList<>());
            MoveData.moveData.get(moveName).add(data);
        }
    }

    public static boolean teamCheck(class_1309 entity1, class_1309 entity2) {
        if (entity1 instanceof class_1321 animal1 && animal1.method_35057() != null) {
            if (entity2 instanceof class_1321 animal2 && animal2.method_35057() != null) {
                class_1309 owner1 = animal1.method_35057();
                class_1309 owner2 = animal2.method_35057();
                if (owner1.method_5781() != null || owner2.method_5781() != null) {
                    return owner1.method_5781() == owner2.method_5781() || owner1.method_5781() == animal2.method_5781() && owner1.method_5781() != null || animal1.method_5781() == owner2.method_5781() && owner2.method_5781() != null;
                }
            }
        }
        if (entity1.method_5781() != null || entity2.method_5781() != null) {
            return entity1.method_5781() == entity2.method_5781();
        }
        return false;
    }

    public static boolean multiSamplingCollisionCheckBlock(class_1309 viewer, class_1309 target, int verticalSampleCount, int horizontalSampleCount, int allowedHit) {
        var level = viewer.method_37908();
        class_243 viewerPos = viewer.method_19538();
        class_243 targetPos = target.method_19538();
        float viewerHeight = viewer.method_17682();
        float targetHeight = target.method_17682();
        float viewerWidth = viewer.method_17681();
        int hit = 0;
        for (int i = 0; i < verticalSampleCount; ++i) {
            for (int j = 0; j < horizontalSampleCount; ++j) {
                for (int k = 0; k < horizontalSampleCount; ++k) {
                    class_243 v = viewerPos.method_1031(-viewerWidth / 2 + viewerWidth * (j + 1) / horizontalSampleCount, viewerHeight * i / verticalSampleCount, -viewerWidth / 2 + viewerWidth * (k + 1) / horizontalSampleCount);
                    class_3959 context = new class_3959(v, targetPos.method_1031(0, targetHeight / 2, 0), class_3959.class_3960.field_17558, class_3959.class_242.field_1347, viewer);
                    class_3965 result = level.method_17742(context);
                    if (!result.method_17783().equals(class_239.class_240.field_1333)) {
                        ++hit;
                    }
                }
            }
        }

        return hit <= allowedHit;
    }

    public static boolean multiSamplingCollisionCheckBlock(class_1309 viewer, class_1309 target, int verticalSampleCount, int horizontalSampleCount) {
        return multiSamplingCollisionCheckBlock(viewer, target, verticalSampleCount, horizontalSampleCount, 0);
    }
}
