/*
 * Decompiled with CFR 0.152.
 */
package me.rufia.fightorflight.entity;

import com.cobblemon.mod.common.CobblemonItems;
import com.cobblemon.mod.common.api.moves.Move;
import com.cobblemon.mod.common.api.moves.categories.DamageCategories;
import com.cobblemon.mod.common.api.types.ElementalType;
import com.cobblemon.mod.common.api.types.ElementalTypes;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.Pokemon;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import me.rufia.fightorflight.CobblemonFightOrFlight;
import me.rufia.fightorflight.PokemonInterface;
import me.rufia.fightorflight.data.movedata.MoveData;
import me.rufia.fightorflight.entity.areaeffect.AbstractPokemonAreaEffect;
import me.rufia.fightorflight.entity.projectile.AbstractPokemonProjectile;
import me.rufia.fightorflight.entity.projectile.AbstractPokemonSpike;
import me.rufia.fightorflight.entity.projectile.PokemonArrow;
import me.rufia.fightorflight.entity.projectile.PokemonBullet;
import me.rufia.fightorflight.entity.projectile.PokemonFloatingSpike;
import me.rufia.fightorflight.entity.projectile.PokemonSpike;
import me.rufia.fightorflight.entity.projectile.PokemonStickyWeb;
import me.rufia.fightorflight.entity.projectile.PokemonTracingBullet;
import me.rufia.fightorflight.utils.FOFHeldItemManager;
import me.rufia.fightorflight.utils.FOFUtils;
import me.rufia.fightorflight.utils.PokemonMultipliers;
import me.rufia.fightorflight.utils.PokemonUtils;
import me.rufia.fightorflight.utils.TypeEffectiveness;
import me.rufia.fightorflight.utils.explosion.FOFExplosion;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1321;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2398;
import net.minecraft.class_2400;
import net.minecraft.class_3483;
import net.minecraft.class_3532;
import net.minecraft.class_5819;

public class PokemonAttackEffect {
    public static class_2400 getParticleFromType(String name) {
        return switch (name) {
            case "fire" -> class_2398.field_11240;
            case "ice" -> class_2398.field_28013;
            case "poison" -> class_2398.field_11219;
            case "psychic" -> class_2398.field_11214;
            case "fairy" -> class_2398.field_43379;
            case "fighting", "ground", "rock" -> class_2398.field_11203;
            case "steel" -> class_2398.field_29643;
            case "ghost" -> class_2398.field_23114;
            case "dark" -> class_2398.field_11251;
            case "electric" -> class_2398.field_29644;
            case "bug" -> class_2398.field_28803;
            case "grass" -> class_2398.field_17741;
            case "dragon" -> class_2398.field_11216;
            case "flying" -> class_2398.field_11227;
            case "water" -> class_2398.field_11202;
            case "normal" -> class_2398.field_11205;
            default -> class_2398.field_11205;
        };
    }

    public static Color getColorFromType(String typeName) {
        return switch (typeName) {
            case "fire" -> new Color(230, 40, 41);
            case "ice" -> new Color(63, 216, 255);
            case "poison" -> new Color(145, 65, 203);
            case "psychic" -> new Color(239, 65, 121);
            case "fairy" -> new Color(239, 112, 239);
            case "fighting" -> new Color(255, 128, 0);
            case "steel" -> new Color(96, 161, 184);
            case "ghost" -> new Color(112, 65, 112);
            case "dark" -> new Color(80, 65, 63);
            case "ground" -> new Color(145, 81, 33);
            case "rock" -> new Color(175, 169, 129);
            case "electric" -> new Color(250, 192, 0);
            case "bug" -> new Color(145, 161, 25);
            case "grass" -> new Color(63, 161, 41);
            case "dragon" -> new Color(80, 96, 225);
            case "flying" -> new Color(129, 185, 239);
            case "water" -> new Color(41, 128, 239);
            case "normal" -> new Color(159, 161, 159);
            default -> new Color(68, 104, 94);
        };
    }

    public static class_2400 getParticleFromType(ElementalType type) {
        return PokemonAttackEffect.getParticleFromType(type.getName());
    }

    public static Color getColorFromType(ElementalType type) {
        return PokemonAttackEffect.getColorFromType(type.getName());
    }

    public static Color getColorFromType(Pokemon pokemon) {
        return PokemonAttackEffect.getColorFromType(pokemon.getPrimaryType());
    }

    public static float calculatePokemonDamage(PokemonEntity pokemonEntity, class_1297 target, boolean isSpecial) {
        return PokemonAttackEffect.calculatePokemonDamage(pokemonEntity, target, isSpecial, CobblemonFightOrFlight.moveConfig().base_power, null);
    }

    public static float calculatePokemonDamage(PokemonEntity pokemonEntity, class_1297 target, boolean isSpecial, float movePower, ElementalType type) {
        int attack = isSpecial ? pokemonEntity.getPokemon().getSpecialAttack() : pokemonEntity.getPokemon().getAttack();
        int maxStat = isSpecial ? CobblemonFightOrFlight.commonConfig().maximum_special_attack_stat : CobblemonFightOrFlight.commonConfig().maximum_attack_stat;
        boolean isUsingRangeAttack = PokemonUtils.shouldShoot(pokemonEntity);
        boolean isUsingMeleeAttack = PokemonUtils.shouldMelee(pokemonEntity);
        PokemonMultipliers multipliers = new PokemonMultipliers(pokemonEntity);
        float attackModifier = CobblemonFightOrFlight.commonConfig().max_bonus_from_stat * class_3532.method_15355((float)((float)Math.min(attack, maxStat) / (float)maxStat));
        float moveModifier = movePower / 40.0f * CobblemonFightOrFlight.moveConfig().move_power_multiplier;
        float minDmg = isSpecial ? multipliers.getMinimumRangeAttackDamage() : multipliers.getMinimumAttackDamage();
        float maxDmg = isSpecial ? multipliers.getMaximumRangeAttackDamage() : multipliers.getMaximumAttackDamage();
        float sheerForceMultiplier = PokemonUtils.canActivateSheerForce(pokemonEntity) ? 1.3f : 1.0f;
        float multiplier = PokemonAttackEffect.extraDamageFromEntityFeature(pokemonEntity, target, type) * PokemonAttackEffect.getHeldItemDmgMultiplier(pokemonEntity, target) * sheerForceMultiplier * multipliers.getPlayerOwnedDamageMultiplier(isUsingRangeAttack, isUsingMeleeAttack);
        float mobEffectBoost = PokemonAttackEffect.getMobEffectBoost(pokemonEntity);
        PokemonInterface pokemonInterface = (PokemonInterface)pokemonEntity;
        if (pokemonInterface.usingBeam() || pokemonInterface.usingSound() || pokemonInterface.usingMagic()) {
            multiplier *= CobblemonFightOrFlight.moveConfig().indirect_attack_move_power_multiplier;
        }
        float value = Math.min(Math.max(multiplier * (moveModifier * attackModifier + mobEffectBoost), minDmg), maxDmg);
        return value;
    }

    public static float calculatePokemonDamage(PokemonEntity pokemonEntity, class_1297 target, Move move) {
        if (move == null) {
            CobblemonFightOrFlight.LOGGER.info("Null move detected");
            return CobblemonFightOrFlight.commonConfig().minimum_ranged_attack_damage;
        }
        if (PokemonUtils.isStatusMove(move)) {
            return 0.0f;
        }
        boolean isSpecial = PokemonUtils.isSpecialMove(move);
        ElementalType primaryType = pokemonEntity.getPokemon().getPrimaryType();
        ElementalType secondaryType = pokemonEntity.getPokemon().getSecondaryType();
        if (secondaryType == null) {
            secondaryType = primaryType;
        }
        float STAB = primaryType.equals(move.getType()) || secondaryType.equals(move.getType()) ? (PokemonUtils.abilityIs(pokemonEntity, "adaptability") ? 2.0f : 1.5f) : 1.0f;
        return PokemonAttackEffect.calculatePokemonDamage(pokemonEntity, target, isSpecial, (float)(move.getPower() * (double)STAB), move.getType());
    }

    protected static float extraDamageFromEntityFeature(PokemonEntity pokemonEntity, class_1297 target, ElementalType moveType) {
        ElementalType type;
        if (target.method_37908().field_9236 || !(target instanceof class_1309)) {
            return 1.0f;
        }
        class_1309 livingEntity = (class_1309)target;
        ElementalType elementalType = type = moveType == null ? pokemonEntity.getPokemon().getPrimaryType() : moveType;
        if (!(livingEntity instanceof PokemonEntity)) {
            if (ElementalTypes.INSTANCE.getWATER().equals(type) && livingEntity.method_29503()) {
                return CobblemonFightOrFlight.commonConfig().water_type_super_effective_dmg_multiplier;
            }
            if (ElementalTypes.INSTANCE.getFIRE().equals(type) && livingEntity.method_5753()) {
                return CobblemonFightOrFlight.commonConfig().fire_type_no_effect_dmg_multiplier;
            }
            if (ElementalTypes.INSTANCE.getICE().equals(type)) {
                if (!livingEntity.method_32316()) {
                    return CobblemonFightOrFlight.commonConfig().ice_type_no_effect_dmg_multiplier;
                }
                if (livingEntity.method_5864().method_20210(class_3483.field_29826)) {
                    return CobblemonFightOrFlight.commonConfig().ice_type_super_effective_dmg_multiplier;
                }
            }
            if (ElementalTypes.INSTANCE.getPOISON().equals(type) && livingEntity.method_5864().method_20210(class_3483.field_46232)) {
                return CobblemonFightOrFlight.commonConfig().poison_type_no_effect_dmg_multiplier;
            }
        } else {
            PokemonEntity targetPokemon = (PokemonEntity)livingEntity;
            return TypeEffectiveness.getTypeEffectiveness(pokemonEntity, targetPokemon);
        }
        return 1.0f;
    }

    public static int getMobEffectBoost(PokemonEntity pokemonEntity) {
        class_1293 weaknessEffect;
        class_1293 strengthEffect;
        int strengthLevel = 0;
        int weaknessLevel = 0;
        if (pokemonEntity.method_6059(class_1294.field_5910) && (strengthEffect = pokemonEntity.method_6112(class_1294.field_5910)) != null) {
            strengthLevel = strengthEffect.method_5578() + 1;
        }
        if (pokemonEntity.method_6059(class_1294.field_5911) && (weaknessEffect = pokemonEntity.method_6112(class_1294.field_5911)) != null) {
            weaknessLevel = weaknessEffect.method_5578() + 1;
        }
        return strengthLevel * 3 - weaknessLevel * 4;
    }

    public static float getHeldItemDmgMultiplier(PokemonEntity pokemonEntity, class_1297 target) {
        if (!FOFHeldItemManager.canUseHeldItemDamageInfluencing()) {
            return 1.0f;
        }
        class_1799 heldItem = PokemonUtils.getHeldItem(pokemonEntity);
        Move move = PokemonUtils.getMove(pokemonEntity);
        ElementalType type = null;
        if (move != null) {
            type = move.getType();
        }
        if (heldItem.method_31574((class_1792)CobblemonItems.LIFE_ORB)) {
            return 1.3f;
        }
        if (move != null) {
            if (DamageCategories.INSTANCE.getPHYSICAL().equals(move.getDamageCategory())) {
                if (heldItem.method_31574((class_1792)CobblemonItems.MUSCLE_BAND)) {
                    return 1.1f;
                }
                if (heldItem.method_31574((class_1792)CobblemonItems.CHOICE_BAND)) {
                    return 1.5f;
                }
            } else if (DamageCategories.INSTANCE.getSPECIAL().equals(move.getDamageCategory())) {
                if (heldItem.method_31574((class_1792)CobblemonItems.WISE_GLASSES)) {
                    return 1.1f;
                }
                if (heldItem.method_31574((class_1792)CobblemonItems.CHOICE_SPECS)) {
                    return 1.5f;
                }
            }
        }
        if (type != null) {
            float typeEnhancingMultiplier = 1.2f;
            switch (type.getName()) {
                case "fire": {
                    if (!heldItem.method_31574((class_1792)CobblemonItems.CHARCOAL)) break;
                    return typeEnhancingMultiplier;
                }
                case "ice": {
                    if (!heldItem.method_31574((class_1792)CobblemonItems.NEVER_MELT_ICE)) break;
                    return typeEnhancingMultiplier;
                }
                case "poison": {
                    if (!heldItem.method_31574((class_1792)CobblemonItems.POISON_BARB)) break;
                    return typeEnhancingMultiplier;
                }
                case "psychic": {
                    if (!heldItem.method_31574((class_1792)CobblemonItems.TWISTED_SPOON)) break;
                    return typeEnhancingMultiplier;
                }
                case "fairy": {
                    if (!heldItem.method_31574((class_1792)CobblemonItems.FAIRY_FEATHER)) break;
                    return typeEnhancingMultiplier;
                }
                case "fighting": {
                    if (!heldItem.method_31574((class_1792)CobblemonItems.BLACK_BELT)) break;
                    return typeEnhancingMultiplier;
                }
                case "steel": {
                    if (!heldItem.method_31574((class_1792)CobblemonItems.METAL_COAT)) break;
                    return typeEnhancingMultiplier;
                }
                case "ghost": {
                    if (!heldItem.method_31574((class_1792)CobblemonItems.SPELL_TAG)) break;
                    return typeEnhancingMultiplier;
                }
                case "dark": {
                    if (!heldItem.method_31574((class_1792)CobblemonItems.BLACK_GLASSES)) break;
                    return typeEnhancingMultiplier;
                }
                case "ground": {
                    if (!heldItem.method_31574((class_1792)CobblemonItems.SOFT_SAND)) break;
                    return typeEnhancingMultiplier;
                }
                case "rock": {
                    if (!heldItem.method_31574((class_1792)CobblemonItems.HARD_STONE)) break;
                    return typeEnhancingMultiplier;
                }
                case "electric": {
                    if (!heldItem.method_31574((class_1792)CobblemonItems.MAGNET)) break;
                    return typeEnhancingMultiplier;
                }
                case "bug": {
                    if (!heldItem.method_31574((class_1792)CobblemonItems.SILVER_POWDER)) break;
                    return typeEnhancingMultiplier;
                }
                case "grass": {
                    if (!heldItem.method_31574((class_1792)CobblemonItems.MIRACLE_SEED)) break;
                    return typeEnhancingMultiplier;
                }
                case "dragon": {
                    if (!heldItem.method_31574((class_1792)CobblemonItems.DRAGON_FANG)) break;
                    return typeEnhancingMultiplier;
                }
                case "flying": {
                    if (!heldItem.method_31574((class_1792)CobblemonItems.SHARP_BEAK)) break;
                    return typeEnhancingMultiplier;
                }
                case "water": {
                    if (!heldItem.method_31574((class_1792)CobblemonItems.MYSTIC_WATER)) break;
                    return typeEnhancingMultiplier;
                }
                case "normal": {
                    if (!heldItem.method_31574((class_1792)CobblemonItems.SILK_SCARF)) break;
                    return typeEnhancingMultiplier;
                }
            }
        }
        return 1.0f;
    }

    public static boolean canChangeMove(PokemonEntity pokemonEntity) {
        class_1799 itemStack = PokemonUtils.getHeldItem(pokemonEntity);
        return !itemStack.method_31574((class_1792)CobblemonItems.CHOICE_BAND) && !itemStack.method_31574((class_1792)CobblemonItems.CHOICE_SCARF) && !itemStack.method_31574((class_1792)CobblemonItems.CHOICE_SPECS);
    }

    protected static void calculateTypeEffect(PokemonEntity pokemonEntity, class_1297 hurtTarget, String typeName, int pkmLevel) {
        if (PokemonUtils.isSheerForce(pokemonEntity)) {
            return;
        }
        if (hurtTarget instanceof class_1309) {
            class_1309 livingHurtTarget = (class_1309)hurtTarget;
            int effectStrength = Math.max(pkmLevel / 10, 1);
            switch (typeName) {
                case "fire": {
                    livingHurtTarget.method_20803(effectStrength * 20);
                    break;
                }
                case "ice": {
                    livingHurtTarget.method_32317(livingHurtTarget.method_32312() + effectStrength * 30);
                    break;
                }
                case "poison": {
                    livingHurtTarget.method_37222(new class_1293(class_1294.field_5899, effectStrength * 20, 0), (class_1297)pokemonEntity);
                    break;
                }
                case "psychic": {
                    livingHurtTarget.method_37222(new class_1293(class_1294.field_5902, effectStrength * 20, 0), (class_1297)pokemonEntity);
                    break;
                }
                case "fairy": 
                case "fighting": 
                case "steel": {
                    livingHurtTarget.method_37222(new class_1293(class_1294.field_5911, effectStrength * 20, 0), (class_1297)pokemonEntity);
                    break;
                }
                case "ghost": 
                case "dark": {
                    livingHurtTarget.method_37222(new class_1293(class_1294.field_38092, effectStrength * 25, 0), (class_1297)pokemonEntity);
                    break;
                }
                case "ground": 
                case "rock": {
                    livingHurtTarget.method_37222(new class_1293(class_1294.field_5901, effectStrength * 25, 0), (class_1297)pokemonEntity);
                    break;
                }
                case "electric": {
                    livingHurtTarget.method_37222(new class_1293(class_1294.field_5909, effectStrength * 25, 0), (class_1297)pokemonEntity);
                    break;
                }
                case "bug": {
                    livingHurtTarget.method_37222(new class_1293(class_1294.field_5903, effectStrength * 25, 0), (class_1297)pokemonEntity);
                    break;
                }
                case "grass": {
                    pokemonEntity.method_37222(new class_1293(class_1294.field_5924, effectStrength * 40, 0), (class_1297)pokemonEntity);
                    break;
                }
                case "water": {
                    livingHurtTarget.method_37222(new class_1293(class_1294.field_5909, (effectStrength + 2) * 25, 0), (class_1297)pokemonEntity);
                    break;
                }
            }
        }
    }

    public static void applyTypeEffect(PokemonEntity pokemonEntity, class_1297 hurtTarget, String typeName) {
        if (pokemonEntity == null) {
            return;
        }
        Pokemon pokemon = pokemonEntity.getPokemon();
        int pkmLevel = pokemon.getLevel();
        PokemonAttackEffect.calculateTypeEffect(pokemonEntity, hurtTarget, typeName, pkmLevel);
    }

    public static void applyTypeEffect(PokemonEntity pokemonEntity, class_1297 hurtTarget) {
        if (pokemonEntity == null) {
            return;
        }
        Pokemon pokemon = pokemonEntity.getPokemon();
        int pkmLevel = pokemon.getLevel();
        String primaryType = pokemon.getPrimaryType().getName();
        PokemonAttackEffect.calculateTypeEffect(pokemonEntity, hurtTarget, primaryType, pkmLevel);
    }

    public static void applyOnHitVisualEffect(PokemonEntity pokemonEntity, class_1297 hurtTarget, Move move) {
        if (move == null) {
            return;
        }
        String moveName = move.getName();
        PokemonAttackEffect.applyOnHitVisualEffect(pokemonEntity, hurtTarget, moveName);
    }

    public static void applyOnHitVisualEffect(PokemonEntity pokemonEntity, class_1297 hurtTarget, String moveName) {
        int particleAmount = 4;
        boolean b1 = Arrays.stream(CobblemonFightOrFlight.visualEffectConfig().self_angry_moves).toList().contains(moveName);
        boolean b2 = Arrays.stream(CobblemonFightOrFlight.visualEffectConfig().target_soul_fire_moves).toList().contains(moveName);
        boolean b3 = Arrays.stream(CobblemonFightOrFlight.visualEffectConfig().target_soul_moves).toList().contains(moveName);
        boolean b4 = Arrays.stream(CobblemonFightOrFlight.visualEffectConfig().slicing_moves).toList().contains(moveName);
        boolean b5 = Arrays.stream(CobblemonFightOrFlight.moveConfig().magic_attack_moves).toList().contains(moveName);
        if (b1) {
            PokemonUtils.makeParticle(particleAmount, (class_1297)pokemonEntity, class_2398.field_11231);
        }
        if (b2) {
            PokemonUtils.makeParticle(particleAmount, hurtTarget, class_2398.field_22246);
        }
        if (b3) {
            PokemonUtils.makeParticle(particleAmount, hurtTarget, class_2398.field_23114);
        }
        if (b4) {
            PokemonUtils.makeParticle(particleAmount, hurtTarget, class_2398.field_11227);
        }
        if (b5) {
            PokemonAttackEffect.makeMagicAttackParticle(pokemonEntity, hurtTarget);
        }
        if (hurtTarget instanceof PokemonEntity) {
            PokemonEntity targetPokemon = (PokemonEntity)hurtTarget;
            float typeEffectivenessMultiplier = TypeEffectiveness.getTypeEffectiveness(pokemonEntity, targetPokemon);
            if (typeEffectivenessMultiplier >= 1.3f) {
                PokemonUtils.makeParticle(particleAmount, hurtTarget, class_2398.field_29642);
            } else if (typeEffectivenessMultiplier < 1.0f) {
                PokemonUtils.makeParticle(particleAmount, hurtTarget, class_2398.field_29645);
            }
        }
    }

    public static void makeMagicAttackParticle(PokemonEntity pokemonEntity, class_1297 target) {
        int particleAmount = 8;
        Move move = PokemonUtils.getRangeAttackMove(pokemonEntity);
        if (move == null) {
            return;
        }
        PokemonAttackEffect.makeTypeEffectParticle(particleAmount, (class_1297)pokemonEntity, move.getType().getName());
        PokemonAttackEffect.makeTypeEffectParticle(particleAmount, target, move.getType().getName());
    }

    public static void makeTypeEffectParticle(int particleAmount, class_1297 entity, String typeName) {
        if (typeName == null) {
            return;
        }
        PokemonUtils.makeParticle(particleAmount, entity, PokemonAttackEffect.getParticleFromType(typeName));
    }

    public static void applyOnUseEffect(PokemonEntity pokemonEntity, class_1309 hurtTarget, Move move) {
        class_1937 level = hurtTarget.method_37908();
        if (move == null || level.field_9236) {
            return;
        }
        if (CobblemonFightOrFlight.commonConfig().activate_move_effect && MoveData.moveData.containsKey(move.getName())) {
            for (MoveData data : MoveData.moveData.get(move.getName())) {
                if (!data.isOnUse()) continue;
                data.invoke(pokemonEntity, hurtTarget);
            }
        }
    }

    public static void applyPostEffect(PokemonEntity pokemonEntity, class_1309 hurtTarget, Move move, boolean targetIsHurt) {
        String abilityName;
        class_1937 level = hurtTarget.method_37908();
        if (move == null || level.field_9236) {
            return;
        }
        String moveName = move.getName();
        boolean b1 = Arrays.stream(CobblemonFightOrFlight.moveConfig().switch_moves).toList().contains(moveName);
        boolean b2 = Arrays.stream(CobblemonFightOrFlight.moveConfig().explosive_moves).toList().contains(moveName);
        boolean b3 = Arrays.stream(CobblemonFightOrFlight.moveConfig().recoil_moves_allHP).toList().contains(moveName);
        boolean b4 = Arrays.stream(CobblemonFightOrFlight.moveConfig().hp_draining_moves_50).toList().contains(moveName);
        boolean b5 = Arrays.stream(CobblemonFightOrFlight.moveConfig().hp_draining_moves_75).toList().contains(moveName);
        boolean b6 = FOFHeldItemManager.canUse(pokemonEntity, (class_1792)CobblemonItems.LIFE_ORB);
        float dmg = PokemonAttackEffect.calculatePokemonDamage(pokemonEntity, (class_1297)hurtTarget, move);
        if (b1) {
            PokemonAttackEffect.pokemonRecallWithAnimation(pokemonEntity);
        }
        if (b2) {
            PokemonAttackEffect.pokemonExplode(pokemonEntity, level);
        }
        if (b3) {
            PokemonAttackEffect.pokemonRecoilSelf(pokemonEntity, 1.0f);
        }
        if (b4 || b5) {
            boolean hasBigRoot = FOFHeldItemManager.canUse(pokemonEntity, (class_1792)CobblemonItems.BIG_ROOT);
            float percent = (b4 ? 0.5f : 0.75f) * (hasBigRoot ? 1.3f : 1.0f);
            pokemonEntity.method_6025(dmg * percent);
        }
        if (b6 && !(abilityName = pokemonEntity.getPokemon().getAbility().getName()).equals("sheerforce") && !abilityName.equals("magicguard")) {
            PokemonAttackEffect.pokemonRecoilSelf(pokemonEntity, 0.1f);
        }
        if (CobblemonFightOrFlight.commonConfig().activate_type_effect) {
            PokemonAttackEffect.applyTypeEffect(pokemonEntity, (class_1297)hurtTarget, move.getType().getName());
        }
        if (CobblemonFightOrFlight.commonConfig().activate_move_effect && MoveData.moveData.containsKey(move.getName())) {
            for (MoveData data : MoveData.moveData.get(move.getName())) {
                if (!data.isOnHit() || !targetIsHurt) continue;
                data.invoke(pokemonEntity, hurtTarget);
            }
        }
        if (!PokemonUtils.isSheerForce(pokemonEntity) && FOFHeldItemManager.canUse(pokemonEntity, (class_1792)CobblemonItems.SHELL_BELL)) {
            float healAmount = dmg / 8.0f;
            pokemonEntity.method_6025(healAmount > 1.0f ? healAmount : 1.0f);
        }
    }

    public static void pokemonRecallWithAnimation(PokemonEntity pokemonEntity) {
        if (pokemonEntity.method_35057() != null) {
            pokemonEntity.recallWithAnimation();
        }
    }

    protected static void addProjectileEntity(PokemonEntity pokemonEntity, class_1309 target, AbstractPokemonProjectile projectile, Move move) {
        projectile.setElementalType(move.getType().getName());
        projectile.setDamage(PokemonAttackEffect.calculatePokemonDamage(pokemonEntity, (class_1297)target, move));
        pokemonEntity.method_37908().method_8649((class_1297)projectile);
    }

    protected static void addProjectileEntity(PokemonEntity pokemonEntity, class_1309 target, AbstractPokemonProjectile projectile) {
        projectile.setElementalType(pokemonEntity.getPokemon().getPrimaryType().getName());
        projectile.setDamage(PokemonAttackEffect.calculatePokemonDamage(pokemonEntity, (class_1297)target, true));
        pokemonEntity.method_37908().method_8649((class_1297)projectile);
    }

    protected static void shootProjectileEntity(PokemonEntity pokemonEntity, class_1309 target, AbstractPokemonProjectile projectile) {
        double d = target.method_23317() - pokemonEntity.method_23317();
        double e = target.method_23323(0.5) - projectile.method_23318();
        double f = target.method_23321() - pokemonEntity.method_23321();
        float velocity = 1.6f;
        projectile.accurateShoot(d, e, f, velocity, 0.1f);
    }

    public static void pokemonPerformRangedAttack(PokemonEntity pokemonEntity, class_1309 target) {
        if (pokemonEntity == null || target == null) {
            return;
        }
        Move move = PokemonUtils.getRangeAttackMove(pokemonEntity);
        PokemonUtils.sendAnimationPacket(pokemonEntity, "special");
        if (move != null) {
            String moveName = move.getName();
            Random rand = new Random();
            boolean b1 = Arrays.stream(CobblemonFightOrFlight.moveConfig().single_bullet_moves).toList().contains(moveName);
            boolean b2 = Arrays.stream(CobblemonFightOrFlight.moveConfig().multiple_bullet_moves).toList().contains(moveName);
            boolean b3 = Arrays.stream(CobblemonFightOrFlight.moveConfig().single_tracing_bullet_moves).toList().contains(moveName);
            boolean b4 = Arrays.stream(CobblemonFightOrFlight.moveConfig().multiple_tracing_bullet_moves).toList().contains(moveName);
            boolean b5 = Arrays.stream(CobblemonFightOrFlight.moveConfig().single_beam_moves).toList().contains(moveName);
            boolean b6 = PokemonUtils.isExplosiveMove(moveName);
            boolean b7 = Arrays.stream(CobblemonFightOrFlight.moveConfig().sound_based_moves).toList().contains(moveName);
            boolean b8 = Arrays.stream(CobblemonFightOrFlight.moveConfig().magic_attack_moves).toList().contains(moveName);
            boolean b9 = Arrays.stream(CobblemonFightOrFlight.moveConfig().delayed_aoe_at_target_position).toList().contains(moveName);
            if (b3 || b4) {
                for (int i = 0; i < (b3 ? 1 : rand.nextInt(3) + 1); ++i) {
                    PokemonTracingBullet bullet = new PokemonTracingBullet(pokemonEntity.method_37908(), (class_1309)pokemonEntity, (class_1297)target, pokemonEntity.method_5735().method_10166());
                    PokemonAttackEffect.addProjectileEntity(pokemonEntity, target, bullet, move);
                }
            } else if (b1 || b2) {
                for (int i = 0; i < (b1 ? 1 : rand.nextInt(3) + 1); ++i) {
                    PokemonBullet bullet = new PokemonBullet(pokemonEntity.method_37908(), (class_1309)pokemonEntity);
                    PokemonAttackEffect.shootProjectileEntity(pokemonEntity, target, bullet);
                    PokemonAttackEffect.addProjectileEntity(pokemonEntity, target, bullet, move);
                }
            } else if (b5 || b7 || b8) {
                if (!PokemonUtils.pokemonTryForceEncounter(pokemonEntity, (class_1297)target)) {
                    boolean success = target.method_5643(pokemonEntity.method_48923().method_48815((class_1297)pokemonEntity, (class_1297)pokemonEntity), PokemonAttackEffect.calculatePokemonDamage(pokemonEntity, (class_1297)target, move));
                    PokemonUtils.setHurtByPlayer(pokemonEntity, (class_1297)target);
                    PokemonAttackEffect.applyOnHitVisualEffect(pokemonEntity, (class_1297)target, move);
                    PokemonAttackEffect.applyPostEffect(pokemonEntity, target, move, success);
                }
            } else if (!b6) {
                if (b9) {
                    PokemonAttackEffect.createAOE(pokemonEntity, target, move);
                } else {
                    PokemonArrow bullet = new PokemonArrow(pokemonEntity.method_37908(), (class_1309)pokemonEntity, (class_1297)target);
                    PokemonAttackEffect.shootProjectileEntity(pokemonEntity, target, bullet);
                    PokemonAttackEffect.addProjectileEntity(pokemonEntity, target, bullet, move);
                }
            }
            if (CobblemonFightOrFlight.commonConfig().activate_move_effect) {
                PokemonAttackEffect.applyOnUseEffect(pokemonEntity, target, move);
            }
        } else {
            PokemonArrow bullet = new PokemonArrow(pokemonEntity.method_37908(), (class_1309)pokemonEntity, (class_1297)target);
            PokemonAttackEffect.shootProjectileEntity(pokemonEntity, target, bullet);
            PokemonAttackEffect.addProjectileEntity(pokemonEntity, target, bullet);
        }
    }

    public static void createAOE(PokemonEntity pokemonEntity, class_1309 target, Move move) {
        if (move == null) {
            return;
        }
        AbstractPokemonAreaEffect aoe = AbstractPokemonAreaEffect.tryToCreate(pokemonEntity, target, move);
        if (aoe != null) {
            aoe.setElementalType(move.getType().getName());
            pokemonEntity.method_37908().method_8649((class_1297)aoe);
        }
    }

    public static void spreadSpikes(PokemonEntity pokemonEntity, String type) {
        if (pokemonEntity == null || type == null || !CobblemonFightOrFlight.moveConfig().enable_spikes) {
            return;
        }
        class_5819 rand = pokemonEntity.method_37908().field_9229;
        int count = rand.method_39332(6, 8);
        double horizontal = 1.0f + pokemonEntity.method_17681() / 2.0f;
        float velocity = 0.8f;
        class_1309 class_13092 = pokemonEntity.method_5968();
        if (class_13092 instanceof class_1309) {
            class_1309 target = class_13092;
            double x = target.method_23317() - pokemonEntity.method_23317();
            double z = target.method_23321() - pokemonEntity.method_23321();
            PokemonAttackEffect.spreadFanShape(x, z, count, 3, pokemonEntity, type, rand, velocity);
        } else {
            PokemonAttackEffect.spreadAround(horizontal, count, pokemonEntity, type, rand, velocity);
        }
    }

    protected static void spreadFanShape(double xf, double zf, int count, int level, PokemonEntity pokemonEntity, String type, class_5819 rand, float velocity) {
        float length = class_3532.method_15355((float)((float)(xf * xf + zf * zf)));
        if (level > count) {
            level = 1;
        }
        ArrayList<Integer> lis = new ArrayList<Integer>();
        int tmp = count;
        for (int i = 0; i < level - 1; ++i) {
            int max = count / level;
            int n = rand.method_39332(1, max);
            lis.add(n);
            tmp -= n;
        }
        lis.add(tmp);
        for (int n = 0; n < level; ++n) {
            for (int i = 0; i < (Integer)lis.get(n); ++i) {
                float mul = (1.0f + (float)n) / length;
                float rad = FOFUtils.toRad(45.0 * ((double)rand.method_43057() - 0.5));
                AbstractPokemonSpike spike = PokemonAttackEffect.createSpike(pokemonEntity.method_37908(), (class_1309)pokemonEntity, type);
                spike.accurateShoot((double)mul * (xf * (double)class_3532.method_15362((float)rad) - zf * (double)class_3532.method_15374((float)rad)), 0.0, (double)mul * (xf * (double)class_3532.method_15374((float)rad) + zf * (double)class_3532.method_15362((float)rad)), velocity, 0.1f);
                pokemonEntity.method_37908().method_8649((class_1297)spike);
            }
        }
    }

    protected static void spreadAround(double r, int count, PokemonEntity pokemonEntity, String type, class_5819 rand, float velocity) {
        for (int i = 0; i < count; ++i) {
            AbstractPokemonSpike spike = PokemonAttackEffect.createSpike(pokemonEntity.method_37908(), (class_1309)pokemonEntity, type);
            if (spike == null) {
                return;
            }
            float rad = FOFUtils.toRad((double)(360.0f / (float)count) * ((double)i + ((double)rand.method_43057() - 0.5) / 2.0));
            spike.accurateShoot(r * (double)class_3532.method_15362((float)rad), 0.0, r * (double)class_3532.method_15374((float)rad), velocity, 0.1f);
            pokemonEntity.method_37908().method_8649((class_1297)spike);
        }
    }

    protected static AbstractPokemonSpike createSpike(class_1937 level, class_1309 shooter, String type) {
        if (type == null) {
            return null;
        }
        switch (type) {
            case "spikes": {
                PokemonSpike spike = new PokemonSpike(level, shooter);
                spike.setElementalType("ground");
                return spike;
            }
            case "toxic_spikes": {
                PokemonSpike spike = new PokemonSpike(level, shooter);
                spike.setElementalType("poison");
                return spike;
            }
            case "stealth_rock": {
                PokemonFloatingSpike spike = new PokemonFloatingSpike(level, shooter);
                spike.setElementalType("rock");
                return spike;
            }
            case "sticky_web": {
                PokemonStickyWeb spike = new PokemonStickyWeb(level, shooter);
                spike.setElementalType("bug");
                return spike;
            }
        }
        return null;
    }

    public static void pokemonExplode(PokemonEntity entity, class_1937 level) {
        if (!level.field_9236) {
            FOFExplosion explosion = FOFExplosion.createExplosion((class_1297)entity, entity, entity.method_23317(), entity.method_23318(), entity.method_23321(), true, false);
            if (explosion != null) {
                explosion.method_8348();
                explosion.finalizeExplosion();
            } else {
                CobblemonFightOrFlight.LOGGER.warn("Failed to create the explosion");
            }
        }
    }

    public static void dealAoEDamage(PokemonEntity pokemonEntity, class_1297 centerEntity, boolean shouldHurtAlly, boolean decreaseOverDistance, boolean hasDirectContact) {
        if (pokemonEntity == null) {
            return;
        }
        Move move = PokemonUtils.getMove(pokemonEntity);
        if (move == null) {
            CobblemonFightOrFlight.LOGGER.warn("No move for aoe.");
            return;
        }
        double radius = PokemonAttackEffect.getAoERadius(pokemonEntity, move);
        List list = centerEntity.method_37908().method_18467(class_1309.class, centerEntity.method_5829().method_1014(radius - (double)(centerEntity.method_17681() / 2.0f)));
        Iterator it = list.iterator();
        while (it.hasNext()) {
            float distance;
            class_1309 livingEntity = (class_1309)it.next();
            if (centerEntity.method_5858((class_1297)livingEntity) > 25.0 || livingEntity == pokemonEntity || !shouldHurtAlly || !PokemonAttackEffect.shouldHurtAllyMob(pokemonEntity, livingEntity)) continue;
            float dmgMultiplier = decreaseOverDistance ? ((distance = centerEntity.method_5739((class_1297)livingEntity)) < CobblemonFightOrFlight.moveConfig().min_AoE_radius ? 1.0f : CobblemonFightOrFlight.moveConfig().min_AoE_damage_multiplier) : CobblemonFightOrFlight.moveConfig().min_AoE_damage_multiplier;
            class_1282 dmgSource = hasDirectContact ? centerEntity.method_48923().method_48812((class_1309)pokemonEntity) : centerEntity.method_48923().method_48815((class_1297)pokemonEntity, (class_1297)pokemonEntity);
            boolean bl = livingEntity.method_5643(dmgSource, PokemonAttackEffect.calculatePokemonDamage(pokemonEntity, (class_1297)livingEntity, move) * dmgMultiplier);
            if (!bl) continue;
            PokemonUtils.setHurtByPlayer(pokemonEntity, (class_1297)livingEntity);
            PokemonAttackEffect.applyOnHitVisualEffect(pokemonEntity, (class_1297)livingEntity, move);
            PokemonAttackEffect.makeTypeEffectParticle(10, (class_1297)livingEntity, move.getType().getName());
        }
        return;
    }

    public static void dealAoEDamage(PokemonEntity pokemonEntity, class_1297 centerEntity, boolean shouldHurtAlly, boolean hasDirectContact) {
        if (pokemonEntity != null) {
            Move move = PokemonUtils.getMove(pokemonEntity);
            if (move != null) {
                PokemonAttackEffect.dealAoEDamage(pokemonEntity, centerEntity, shouldHurtAlly, true, hasDirectContact);
            } else {
                CobblemonFightOrFlight.LOGGER.warn("[FOF]:Failed to get move for aoe damage");
            }
        }
    }

    public static void pokemonRecoilSelf(PokemonEntity pokemonEntity, float percent) {
        float maxHealth;
        Pokemon pokemon = pokemonEntity.getPokemon();
        float curHealth = pokemonEntity.method_6032();
        float health = curHealth - (maxHealth = pokemonEntity.method_6063()) * percent;
        if (health > 0.0f) {
            pokemonEntity.method_6033(curHealth);
        } else {
            pokemonEntity.method_6033(0.0f);
        }
        PokemonUtils.entityHpToPokemonHp(pokemonEntity, maxHealth * percent, false);
        if (pokemonEntity.method_6032() == 0.0f) {
            pokemon.setCurrentHealth(0);
        }
    }

    public static float getAoERadius(PokemonEntity entity, Move move) {
        Pokemon pokemon = entity.getPokemon();
        boolean isSpecial = move.getDamageCategory().equals(DamageCategories.INSTANCE.getSPECIAL());
        int stat = isSpecial ? pokemon.getSpecialAttack() : pokemon.getAttack();
        int requiredStat = isSpecial ? CobblemonFightOrFlight.commonConfig().maximum_special_attack_stat : CobblemonFightOrFlight.commonConfig().maximum_attack_stat;
        return Math.min(class_3532.method_16439((float)((float)stat / (float)requiredStat), (float)CobblemonFightOrFlight.moveConfig().min_AoE_radius, (float)CobblemonFightOrFlight.moveConfig().max_AoE_radius), CobblemonFightOrFlight.moveConfig().max_AoE_radius);
    }

    public static int calculateAttackTime(PokemonEntity pokemonEntity, double distance) {
        if (pokemonEntity == null) {
            return -1;
        }
        boolean isMelee = PokemonUtils.shouldMelee(pokemonEntity);
        float attackSpeedModifier = Math.max(0.1f, 1.0f - pokemonEntity.method_6029() / (float)CobblemonFightOrFlight.commonConfig().speed_stat_limit);
        float f = (isMelee ? 0.2f : (float)Math.sqrt(distance) / PokemonUtils.getAttackRadius()) * attackSpeedModifier;
        if (isMelee) {
            return class_3532.method_15375((float)(20.0f * class_3532.method_16439((float)f, (float)CobblemonFightOrFlight.commonConfig().minimum_melee_attack_interval, (float)CobblemonFightOrFlight.commonConfig().maximum_melee_attack_interval)));
        }
        return class_3532.method_15375((float)(20.0f * class_3532.method_16439((float)f, (float)CobblemonFightOrFlight.commonConfig().minimum_ranged_attack_interval, (float)CobblemonFightOrFlight.commonConfig().maximum_ranged_attack_interval)));
    }

    public static void refreshAttackTime(PokemonEntity pokemonEntity, int attackTime) {
        ((PokemonInterface)pokemonEntity).setAttackTime(attackTime);
        ((PokemonInterface)pokemonEntity).setMaxAttackTime(attackTime);
    }

    public static void resetAttackTime(PokemonEntity pokemonEntity, double distance) {
        int attackTime = PokemonAttackEffect.calculateAttackTime(pokemonEntity, distance);
        PokemonAttackEffect.refreshAttackTime(pokemonEntity, attackTime);
    }

    public static boolean pokemonAttack(PokemonEntity pokemonEntity, class_1297 hurtTarget) {
        class_1309 livingEntity;
        float hurtDamage;
        Pokemon pokemon = pokemonEntity.getPokemon();
        float hurtKnockback = 1.0f;
        Move move = PokemonUtils.getMeleeMove(pokemonEntity);
        if (move != null) {
            boolean b1 = PokemonUtils.isExplosiveMove(move.getName());
            hurtDamage = b1 ? 0.0f : PokemonAttackEffect.calculatePokemonDamage(pokemonEntity, hurtTarget, move);
            if (hurtTarget instanceof class_1309) {
                livingEntity = (class_1309)hurtTarget;
                PokemonAttackEffect.makeTypeEffectParticle(10, (class_1297)livingEntity, move.getType().getName());
                PokemonUtils.updateMoveEvolutionProgress(pokemon, move.getTemplate());
                if (CobblemonFightOrFlight.commonConfig().activate_move_effect) {
                    PokemonAttackEffect.applyOnUseEffect(pokemonEntity, livingEntity, move);
                }
            }
        } else {
            if (CobblemonFightOrFlight.commonConfig().activate_type_effect) {
                PokemonAttackEffect.applyTypeEffect(pokemonEntity, hurtTarget);
            }
            PokemonAttackEffect.makeTypeEffectParticle(6, hurtTarget, pokemonEntity.getPokemon().getPrimaryType().getName());
            hurtDamage = PokemonAttackEffect.calculatePokemonDamage(pokemonEntity, hurtTarget, false);
        }
        PokemonAttackEffect.applyOnHitVisualEffect(pokemonEntity, hurtTarget, move);
        PokemonUtils.setHurtByPlayer(pokemonEntity, hurtTarget);
        boolean flag = hurtTarget.method_5643(pokemonEntity.method_37908().method_48963().method_48812((class_1309)pokemonEntity), hurtDamage);
        if (flag) {
            if (hurtTarget instanceof class_1309) {
                livingEntity = (class_1309)hurtTarget;
                if (CobblemonFightOrFlight.commonConfig().activate_type_effect) {
                    pokemonEntity.method_18799(pokemonEntity.method_18798().method_18805(0.6, 1.0, 0.6));
                }
                if (CobblemonFightOrFlight.commonConfig().activate_move_effect) {
                    PokemonAttackEffect.applyPostEffect(pokemonEntity, livingEntity, move, true);
                }
                livingEntity.method_6005(CobblemonFightOrFlight.commonConfig().activate_type_effect ? (double)(hurtKnockback * 0.5f) : 0.5, (double)class_3532.method_15374((float)(pokemonEntity.method_36454() * ((float)Math.PI / 180))), (double)(-class_3532.method_15362((float)(pokemonEntity.method_36454() * ((float)Math.PI / 180)))));
            }
            pokemonEntity.method_6114(hurtTarget);
        }
        return flag;
    }

    public static boolean shouldHurtAllyMob(PokemonEntity pokemonEntity, class_1309 target) {
        if (pokemonEntity == null || target == null) {
            return true;
        }
        boolean b = false;
        class_1309 class_13092 = pokemonEntity.method_35057();
        if (class_13092 instanceof class_1657) {
            class_1657 owner = (class_1657)class_13092;
            if (CobblemonFightOrFlight.commonConfig().pvp_immunity) {
                b = target instanceof class_1657;
            }
            if (CobblemonFightOrFlight.commonConfig().friendly_fire_immunity_team) {
                boolean bl = b = b || FOFUtils.teamCheck((class_1309)pokemonEntity, target);
            }
            if (CobblemonFightOrFlight.commonConfig().friendly_fire_immunity_owner) {
                boolean bl = b = b || owner.equals((Object)target);
                if (target instanceof class_1321) {
                    class_1321 tar = (class_1321)target;
                    b = b || owner.equals((Object)tar.method_35057());
                }
            }
            return !b;
        }
        return true;
    }

    public static boolean shouldBeHurtByAllyMob(PokemonEntity pokemonEntity, class_1309 attacker) {
        if (pokemonEntity == null || attacker == null) {
            return true;
        }
        class_1309 class_13092 = pokemonEntity.method_35057();
        if (class_13092 instanceof class_1657) {
            class_1657 owner = (class_1657)class_13092;
            if (CobblemonFightOrFlight.commonConfig().pvp_immunity) {
                return !(attacker instanceof class_1657);
            }
            if (CobblemonFightOrFlight.commonConfig().friendly_fire_immunity_team) {
                return !Objects.equals(owner.method_5781(), attacker.method_5781());
            }
            if (CobblemonFightOrFlight.commonConfig().friendly_fire_immunity_owner) {
                return !owner.equals((Object)attacker);
            }
        }
        return true;
    }
}

