/*
 * Decompiled with CFR 0.152.
 */
package me.rufia.fightorflight.entity.areaeffect;

import com.cobblemon.mod.common.api.moves.Move;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import me.rufia.fightorflight.CobblemonFightOrFlight;
import me.rufia.fightorflight.entity.IPokemonAttack;
import me.rufia.fightorflight.entity.PokemonAttackEffect;
import me.rufia.fightorflight.entity.areaeffect.PokemonAreaEffectMagic;
import me.rufia.fightorflight.entity.areaeffect.PokemonTornado;
import me.rufia.fightorflight.entity.areaeffect.PokemonWhirlPool;
import me.rufia.fightorflight.utils.PokemonUtils;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_3619;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractPokemonAreaEffect
extends class_1297
implements IPokemonAttack {
    private static final class_2940<Float> DATA_RADIUS = class_2945.method_12791(AbstractPokemonAreaEffect.class, (class_2941)class_2943.field_13320);
    private static final class_2940<Float> DATA_HEIGHT = class_2945.method_12791(AbstractPokemonAreaEffect.class, (class_2941)class_2943.field_13320);
    private static final class_2940<String> DATA_TYPE = class_2945.method_12791(AbstractPokemonAreaEffect.class, (class_2941)class_2943.field_13326);
    private static final class_2940<Boolean> DATA_WAITING = class_2945.method_12791(AbstractPokemonAreaEffect.class, (class_2941)class_2943.field_13323);
    private static final class_2940<String> DATA_MOVE_NAME = class_2945.method_12791(AbstractPokemonAreaEffect.class, (class_2941)class_2943.field_13326);
    protected int duration = 100;
    protected int waitTime = 10;
    protected boolean isInstant;
    protected boolean activated;
    @Nullable
    protected class_1309 owner;
    @Nullable
    protected UUID ownerUUID;

    public AbstractPokemonAreaEffect(class_1299<? extends AbstractPokemonAreaEffect> entityType, class_1937 level) {
        super(entityType, level);
        this.field_5960 = true;
        this.isInstant = false;
        this.activated = false;
    }

    public static AbstractPokemonAreaEffect tryToCreate(PokemonEntity owner, class_1309 target, Move move) {
        if (move == null) {
            return null;
        }
        String moveName = move.getName();
        boolean canFloat = Arrays.stream(CobblemonFightOrFlight.moveConfig().delayed_aoe_can_float).toList().contains(moveName);
        boolean isInstant = Arrays.stream(CobblemonFightOrFlight.moveConfig().delayed_aoe_is_instant).toList().contains(moveName);
        boolean isTornado = Arrays.stream(CobblemonFightOrFlight.moveConfig().delayed_aoe_rise_up_tornado).toList().contains(moveName);
        boolean isWhirlpool = Arrays.stream(CobblemonFightOrFlight.moveConfig().delayed_aoe_bounding_whirlpool).toList().contains(moveName);
        float r = class_3532.method_15363((float)owner.method_17681(), (float)1.0f, (float)3.0f) * 1.5f;
        AbstractPokemonAreaEffect aoe = isTornado ? new PokemonTornado((class_1309)owner) : (isWhirlpool ? new PokemonWhirlPool((class_1309)owner) : new PokemonAreaEffectMagic((class_1309)owner));
        aoe.setMoveName(moveName);
        aoe.setOwner((class_1309)owner);
        aoe.init(target, 30, 10, canFloat, isInstant);
        aoe.refreshHeight();
        aoe.setRadius(r);
        return aoe;
    }

    public void init(class_1309 target, int duration, int waitTime, boolean canFloat, boolean isInstant) {
        this.duration = duration;
        this.waitTime = waitTime;
        this.isInstant = isInstant;
        if (canFloat) {
            this.method_33574(target.method_19538());
        } else {
            class_2338 blockPos = target.method_23312();
            int y = blockPos.method_10264();
            boolean yFound = false;
            while (!yFound && y > this.method_37908().method_31607()) {
                class_2680 blockState = target.method_37908().method_8320(blockPos);
                if (blockState.method_51366()) {
                    yFound = true;
                    continue;
                }
                --y;
                blockPos = blockPos.method_10074();
            }
            if (yFound) {
                this.method_5814(target.method_23317(), y + 1, target.method_23321());
            }
        }
    }

    public void refreshHeight() {
        float r = this.getRadius();
        if (this instanceof PokemonTornado) {
            this.setHeight(r);
        } else {
            this.setHeight(0.5f);
        }
    }

    public void method_5773() {
        super.method_5773();
        if (!this.method_37908().field_9236) {
            boolean isWaitingNow;
            boolean wasWaiting = this.isWaiting();
            this.visualEffect();
            if (this.field_6012 > this.duration || this.getOwner() == null) {
                this.method_31472();
                return;
            }
            boolean bl = isWaitingNow = this.field_6012 < this.waitTime;
            if (wasWaiting != isWaitingNow) {
                this.setWaiting(isWaitingNow);
            }
            if (isWaitingNow) {
                return;
            }
            if (!((this.field_6012 + 1) % this.getApplicationTime() != 0 || this.activated && this.isInstant)) {
                this.activate();
            }
        }
    }

    protected abstract void visualEffect();

    protected void activate() {
        if (!this.activated) {
            this.onActivated();
        }
        this.activated = true;
    }

    protected void onActivated() {
        this.playActivateSound();
    }

    protected void playActivateSound() {
        String typeName = this.getElementalType();
        if (typeName.equals("electric")) {
            this.method_5783(class_3417.field_14865, 4.0f, (1.0f + (this.method_37908().field_9229.method_43057() - this.method_37908().field_9229.method_43057()) * 0.2f) * 0.7f);
        } else if (typeName.equals("fire")) {
            this.method_5783(class_3417.field_14821, 4.0f, (1.0f + (this.method_37908().field_9229.method_43057() - this.method_37908().field_9229.method_43057()) * 0.2f) * 0.7f);
        } else if (typeName.equals("water")) {
            this.method_5783(class_3417.field_14737, 4.0f, (1.0f + (this.method_37908().field_9229.method_43057() - this.method_37908().field_9229.method_43057()) * 0.2f) * 0.7f);
        } else {
            this.playDefaultSound();
        }
    }

    protected void playDefaultSound() {
        this.method_5783((class_3414)class_3417.field_15152.comp_349(), 3.0f, (1.0f + (this.method_37908().field_9229.method_43057() - this.method_37908().field_9229.method_43057()) * 0.2f) * 0.7f);
    }

    protected void dealDamageInTheArea() {
        PokemonEntity pokemonEntity;
        class_1309 class_13092 = this.owner;
        if (class_13092 instanceof PokemonEntity && (pokemonEntity = (PokemonEntity)class_13092).method_5805()) {
            List list = this.method_37908().method_18467(class_1309.class, this.method_5829());
            for (class_1309 target : list) {
                Move move;
                if (PokemonUtils.pokemonTryForceEncounter(pokemonEntity, (class_1297)target) || (move = PokemonUtils.findMove(pokemonEntity, this.getMoveName())) == null || !PokemonAttackEffect.shouldHurtAllyMob(pokemonEntity, target)) continue;
                boolean success = target.method_5643(pokemonEntity.method_48923().method_48815((class_1297)pokemonEntity, (class_1297)pokemonEntity), PokemonAttackEffect.calculatePokemonDamage(pokemonEntity, (class_1297)target, move));
                PokemonUtils.setHurtByPlayer(pokemonEntity, (class_1297)target);
                PokemonAttackEffect.applyOnHitVisualEffect(pokemonEntity, (class_1297)target, this.getMoveName());
                PokemonAttackEffect.applyPostEffect(pokemonEntity, target, move, success);
                this.applyExtraEffect(target);
            }
        }
    }

    protected void applyExtraEffect(class_1309 target) {
    }

    public int getApplicationTime() {
        return 5;
    }

    public float getRadius() {
        return ((Float)this.field_6011.method_12789(DATA_RADIUS)).floatValue();
    }

    public void setRadius(float r) {
        this.field_6011.method_12778(DATA_RADIUS, (Object)Float.valueOf(r));
    }

    public float getHeight() {
        return ((Float)this.field_6011.method_12789(DATA_HEIGHT)).floatValue();
    }

    public void setHeight(float h) {
        this.field_6011.method_12778(DATA_HEIGHT, (Object)Float.valueOf(h));
    }

    public boolean isActivated() {
        return this.activated;
    }

    @NotNull
    public class_3619 method_5657() {
        return class_3619.field_15975;
    }

    @NotNull
    public class_4048 method_18377(class_4050 pose) {
        return class_4048.method_18384((float)(this.getRadius() * 2.0f), (float)this.getHeight());
    }

    public void method_18382() {
        double d = this.method_23317();
        double e = this.method_23318();
        double f = this.method_23321();
        super.method_18382();
        this.method_5814(d, e, f);
    }

    protected void method_5693(class_2945.class_9222 builder) {
        builder.method_56912(DATA_RADIUS, (Object)Float.valueOf(3.0f));
        builder.method_56912(DATA_HEIGHT, (Object)Float.valueOf(0.5f));
        builder.method_56912(DATA_TYPE, (Object)"normal");
        builder.method_56912(DATA_WAITING, (Object)true);
        builder.method_56912(DATA_MOVE_NAME, (Object)"");
    }

    public void method_5674(class_2940<?> dataAccessor) {
        if (DATA_RADIUS.equals(dataAccessor)) {
            this.method_18382();
        }
        super.method_5674(dataAccessor);
    }

    protected void method_5749(class_2487 compound) {
        this.field_6012 = compound.method_10550("Age");
        this.duration = compound.method_10550("Duration");
        this.waitTime = compound.method_10550("WaitTime");
        this.setHeight(compound.method_10583("Height"));
        this.setRadius(compound.method_10583("Radius"));
        if (compound.method_25928("Owner")) {
            this.ownerUUID = compound.method_25926("Owner");
        }
    }

    protected void method_5652(class_2487 compound) {
        compound.method_10569("Age", this.field_6012);
        compound.method_10569("Duration", this.duration);
        compound.method_10569("WaitTime", this.waitTime);
        compound.method_10548("Radius", this.getRadius());
        compound.method_10548("Height", this.getHeight());
        if (this.ownerUUID != null) {
            compound.method_25927("Owner", this.ownerUUID);
        }
    }

    public void setOwner(@Nullable class_1309 owner) {
        this.owner = owner;
        this.ownerUUID = owner == null ? null : owner.method_5667();
    }

    @Nullable
    public class_1309 getOwner() {
        class_1297 entity;
        if (this.owner == null && this.ownerUUID != null && this.method_37908() instanceof class_3218 && (entity = ((class_3218)this.method_37908()).method_14190(this.ownerUUID)) instanceof class_1309) {
            this.owner = (class_1309)entity;
        }
        return this.owner;
    }

    @Override
    public String getElementalType() {
        return (String)this.field_6011.method_12789(DATA_TYPE);
    }

    @Override
    public void setElementalType(String type) {
        this.field_6011.method_12778(DATA_TYPE, (Object)type);
    }

    protected void setWaiting(boolean waiting) {
        this.method_5841().method_12778(DATA_WAITING, (Object)waiting);
    }

    public boolean isWaiting() {
        return (Boolean)this.method_5841().method_12789(DATA_WAITING);
    }

    public void setMoveName(String moveName) {
        this.field_6011.method_12778(DATA_MOVE_NAME, (Object)moveName);
    }

    public String getMoveName() {
        return (String)this.field_6011.method_12789(DATA_MOVE_NAME);
    }

    public int getDuration() {
        return this.duration;
    }

    public int getWaitTime() {
        return this.waitTime;
    }
}

