/*
 * Decompiled with CFR 0.152.
 */
package me.rufia.fightorflight.utils;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.api.moves.BenchedMove;
import com.cobblemon.mod.common.api.moves.Move;
import com.cobblemon.mod.common.api.moves.MoveSet;
import com.cobblemon.mod.common.api.moves.MoveTemplate;
import com.cobblemon.mod.common.api.moves.categories.DamageCategories;
import com.cobblemon.mod.common.api.storage.party.PartyStore;
import com.cobblemon.mod.common.api.types.ElementalType;
import com.cobblemon.mod.common.battles.BattleBuilder;
import com.cobblemon.mod.common.battles.BattleFormat;
import com.cobblemon.mod.common.battles.BattleRegistry;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.net.messages.client.animation.PlayPosableAnimationPacket;
import com.cobblemon.mod.common.net.messages.client.effect.RunPosableMoLangPacket;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.pokemon.activestate.ShoulderedState;
import com.cobblemon.mod.common.pokemon.evolution.progress.UseMoveEvolutionProgress;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import me.rufia.fightorflight.CobblemonFightOrFlight;
import me.rufia.fightorflight.PokemonInterface;
import me.rufia.fightorflight.data.movedata.MoveData;
import me.rufia.fightorflight.item.component.PokeStaffComponent;
import me.rufia.fightorflight.utils.FOFUtils;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1569;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2400;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3532;

public class PokemonUtils {
    private static final Map<String, PokeStaffComponent.CMDMODE> CMDMODE_IDS = Arrays.stream(PokeStaffComponent.CMDMODE.values()).collect(Collectors.toMap($ -> $.name().toLowerCase(), $ -> $));

    public static boolean shouldMelee(PokemonEntity pokemonEntity) {
        return ((PokemonInterface)pokemonEntity).getAttackMode() == 1;
    }

    public static boolean shouldShoot(PokemonEntity pokemonEntity) {
        return ((PokemonInterface)pokemonEntity).getAttackMode() == 2;
    }

    public static boolean shouldFightTarget(PokemonEntity pokemonEntity) {
        if (pokemonEntity.getPokemon().getLevel() < CobblemonFightOrFlight.commonConfig().minimum_attack_level) {
            return false;
        }
        class_1309 owner = pokemonEntity.method_35057();
        if (owner != null) {
            PokemonEntity targetPokemon;
            class_1309 targetOwner;
            if (!CobblemonFightOrFlight.commonConfig().do_pokemon_defend_owner || pokemonEntity.method_5968() == null || pokemonEntity.method_5968() == owner || pokemonEntity.getPokemon().getState() instanceof ShoulderedState) {
                return false;
            }
            class_1309 class_13092 = pokemonEntity.method_5968();
            if (class_13092 instanceof PokemonEntity && (targetOwner = (targetPokemon = (PokemonEntity)class_13092).method_35057()) != null) {
                if (targetOwner == owner) {
                    return false;
                }
                if (!CobblemonFightOrFlight.commonConfig().do_player_pokemon_attack_other_player_pokemon) {
                    return false;
                }
            }
            if (pokemonEntity.method_5968() instanceof class_1657 && !CobblemonFightOrFlight.commonConfig().do_player_pokemon_attack_other_players) {
                return false;
            }
        } else if (pokemonEntity.method_5968() != null) {
            if (CobblemonFightOrFlight.getFightOrFlightCoefficient(pokemonEntity) <= 0.0) {
                return false;
            }
            class_1309 targetEntity = pokemonEntity.method_5968();
            if (pokemonEntity.method_5649(targetEntity.method_23317(), targetEntity.method_23318(), targetEntity.method_23321()) > 400.0) {
                return false;
            }
        }
        return !pokemonEntity.isBusy();
    }

    public static Set<MoveTemplate> getAllLearnableMoveTemplates(Pokemon pokemon) {
        HashSet<MoveTemplate> moves = new HashSet<MoveTemplate>();
        for (BenchedMove move : pokemon.getBenchedMoves()) {
            moves.add(move.getMoveTemplate());
        }
        moves.addAll(pokemon.getForm().getMoves().getLevelUpMovesUpTo(100));
        moves.addAll(pokemon.getForm().getMoves().getEvolutionMoves());
        moves.addAll(pokemon.getForm().getMoves().getTmMoves());
        moves.addAll(pokemon.getForm().getMoves().getTutorMoves());
        moves.addAll(pokemon.getForm().getMoves().getEggMoves());
        return moves;
    }

    public static boolean hasType(PokemonEntity pokemonEntity, ElementalType type) {
        return PokemonUtils.hasType(pokemonEntity.getPokemon(), type);
    }

    public static boolean hasType(Pokemon pokemon, ElementalType type) {
        ElementalType type2;
        ElementalType type1 = pokemon.getPrimaryType();
        if (type1 != type && (type2 = pokemon.getSecondaryType()) != null) {
            return type2 == type;
        }
        return true;
    }

    public static Move getMove(PokemonEntity pokemonEntity) {
        if (pokemonEntity == null) {
            CobblemonFightOrFlight.LOGGER.info("PokemonEntity is null");
            return null;
        }
        Move firstMove = pokemonEntity.getPokemon().getMoveSet().get(0);
        String moveName = "";
        if (!((PokemonInterface)pokemonEntity).getCurrentMove().isEmpty()) {
            moveName = ((PokemonInterface)pokemonEntity).getCurrentMove();
        } else if (firstMove != null) {
            moveName = firstMove.getName();
        }
        Move move = PokemonUtils.findMove(pokemonEntity, moveName);
        if (move == null && !pokemonEntity.method_37908().field_9236) {
            CobblemonFightOrFlight.LOGGER.warn("Can't get the move/Trying to return a null move. Move name:{}", (Object)moveName);
        }
        return move;
    }

    public static Move findMove(PokemonEntity pokemonEntity, String moveName) {
        Move move = null;
        boolean flag = false;
        if (!moveName.isEmpty()) {
            for (MoveTemplate m : PokemonUtils.getAllLearnableMoveTemplates(pokemonEntity.getPokemon())) {
                move = m.create();
                if (!m.getName().equals(moveName)) continue;
                flag = true;
                break;
            }
        }
        if (!flag) {
            move = pokemonEntity.getPokemon().getMoveSet().get(0);
        }
        return move;
    }

    public static boolean isMeleeAttackMove(Move move) {
        if (move == null) {
            return false;
        }
        String moveName = move.getName();
        boolean isSpecial = PokemonUtils.isSpecialMove(move);
        boolean isPhysical = PokemonUtils.isPhysicalMove(move);
        boolean b1 = isPhysical && !Arrays.stream(CobblemonFightOrFlight.moveConfig().single_bullet_moves).toList().contains(moveName) && !Arrays.stream(CobblemonFightOrFlight.moveConfig().physical_single_arrow_moves).toList().contains(moveName) && !Arrays.stream(CobblemonFightOrFlight.moveConfig().delayed_aoe_at_target_position).toList().contains(moveName);
        boolean b2 = isSpecial && Arrays.stream(CobblemonFightOrFlight.moveConfig().special_contact_moves).toList().contains(moveName);
        return b1 || b2;
    }

    public static boolean isRangeAttackMove(Move move) {
        if (move == null) {
            return false;
        }
        String moveName = move.getName();
        boolean isSpecial = PokemonUtils.isSpecialMove(move);
        boolean isPhysical = PokemonUtils.isPhysicalMove(move);
        boolean b1 = isPhysical && (Arrays.stream(CobblemonFightOrFlight.moveConfig().single_bullet_moves).toList().contains(moveName) || Arrays.stream(CobblemonFightOrFlight.moveConfig().physical_single_arrow_moves).toList().contains(moveName) || Arrays.stream(CobblemonFightOrFlight.moveConfig().delayed_aoe_at_target_position).toList().contains(moveName));
        boolean b2 = isSpecial && !Arrays.stream(CobblemonFightOrFlight.moveConfig().special_contact_moves).toList().contains(moveName);
        return b1 || b2;
    }

    public static Move getMeleeMove(PokemonEntity pokemonEntity) {
        Move move = PokemonUtils.getMove(pokemonEntity);
        if (move == null) {
            return null;
        }
        if (PokemonUtils.isMeleeAttackMove(move)) {
            return move;
        }
        return null;
    }

    public static Move getRangeAttackMove(PokemonEntity pokemonEntity) {
        Move move = PokemonUtils.getMove(pokemonEntity);
        if (move == null) {
            return null;
        }
        if (PokemonUtils.isRangeAttackMove(move)) {
            return move;
        }
        return null;
    }

    public static Move getStatusMove(PokemonEntity pokemonEntity) {
        Move move = PokemonUtils.getMove(pokemonEntity);
        if (move == null) {
            return null;
        }
        boolean b = DamageCategories.INSTANCE.getSTATUS().equals(move.getDamageCategory());
        boolean b1 = Arrays.stream(CobblemonFightOrFlight.moveConfig().self_targeting_status_move).toList().contains(move.getName());
        boolean b2 = MoveData.moveData.containsKey(move.getName());
        if (b && (b1 || b2)) {
            ((PokemonInterface)pokemonEntity).setCurrentMove(move);
            return move;
        }
        return null;
    }

    public static boolean findMoveEffectData(String effect) {
        List<MoveData> l = MoveData.moveData.get(effect);
        if (l != null) {
            for (MoveData data : l) {
                if (!Objects.equals(data.getName(), effect)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isSpecialMove(Move move) {
        return Objects.equals(move.getDamageCategory(), DamageCategories.INSTANCE.getSPECIAL());
    }

    public static boolean isPhysicalMove(Move move) {
        return Objects.equals(move.getDamageCategory(), DamageCategories.INSTANCE.getPHYSICAL());
    }

    public static boolean isStatusMove(Move move) {
        return Objects.equals(move.getDamageCategory(), DamageCategories.INSTANCE.getSTATUS());
    }

    public static void makeParticle(int particleAmount, class_1297 entity, class_2400 particleType) {
        class_1937 level = entity.method_37908();
        if (particleAmount > 0) {
            double d = 0.0;
            double e = 0.0;
            double f = 0.0;
            if (level instanceof class_3218) {
                class_3218 serverLevel = (class_3218)level;
                serverLevel.method_14199((class_2394)particleType, entity.method_23322(0.5), entity.method_23319(), entity.method_23325(0.5), particleAmount, d, e, f, 1.0);
            } else {
                for (int j = 0; j < particleAmount; ++j) {
                    level.method_8406((class_2394)particleType, entity.method_23322(0.5), entity.method_23319(), entity.method_23325(0.5), d, e, f);
                }
            }
        }
    }

    public static void setHurtByPlayer(PokemonEntity pokemonEntity, class_1297 target) {
        class_1309 owner = pokemonEntity.method_35057();
        if (owner instanceof class_1657) {
            class_1657 player = (class_1657)owner;
            if (target instanceof class_1309) {
                class_1309 livingEntity = (class_1309)target;
                livingEntity.method_29505(player);
            }
        }
    }

    public static boolean canTaunt(PokemonEntity pokemonEntity) {
        if (!CobblemonFightOrFlight.moveConfig().taunt_moves_needed) {
            return true;
        }
        boolean result = false;
        MoveSet moveSet = pokemonEntity.getPokemon().getMoveSet();
        for (Move move : moveSet) {
            if (!Arrays.stream(CobblemonFightOrFlight.moveConfig().taunting_moves).toList().contains(move.getName())) continue;
            result = true;
            break;
        }
        return result;
    }

    public static boolean isExplosiveMove(String moveName) {
        return Arrays.stream(CobblemonFightOrFlight.moveConfig().explosive_moves).toList().contains(moveName);
    }

    public static void createSonicBoomParticle(PokemonEntity pokemonEntity, class_1309 target) {
        if (target == null) {
            return;
        }
        float height = pokemonEntity.method_5751();
        class_243 vec1 = pokemonEntity.method_19538().method_1031(0.0, (double)height, 0.0);
        class_243 vec2 = target.method_33571().method_1020(vec1);
        class_243 vec3 = vec2.method_1029();
        for (int i = 1; i < class_3532.method_15357((double)vec2.method_1033()) + 1; ++i) {
            class_243 vec4 = vec1.method_1019(vec3.method_1021((double)i));
            class_1937 level = target.method_37908();
            if (!(level instanceof class_3218)) continue;
            class_3218 serverLevel = (class_3218)level;
            serverLevel.method_14199((class_2394)class_2398.field_38908, vec4.field_1352, vec4.field_1351, vec4.field_1350, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    public static void sendAnimationPacket(PokemonEntity pokemonEntity, String mode) {
        if (!pokemonEntity.method_37908().field_9236) {
            PlayPosableAnimationPacket pkt = new PlayPosableAnimationPacket(pokemonEntity.method_5628(), Set.of(mode), List.of());
            pokemonEntity.method_37908().method_8390(class_3222.class, class_238.method_30048((class_243)pokemonEntity.method_19538(), (double)64.0, (double)64.0, (double)64.0), livingEntity -> true).forEach(arg_0 -> ((PlayPosableAnimationPacket)pkt).sendToPlayer(arg_0));
        }
    }

    public static void updateMoveEvolutionProgress(Pokemon pokemon, MoveTemplate move) {
        if (UseMoveEvolutionProgress.Companion.supports(pokemon, move) && CobblemonFightOrFlight.commonConfig().can_progress_use_move_evoluiton) {
            UseMoveEvolutionProgress progress = (UseMoveEvolutionProgress)pokemon.getEvolutionProxy().current().progressFirstOrCreate(evolutionProgress -> {
                if (evolutionProgress instanceof UseMoveEvolutionProgress) {
                    UseMoveEvolutionProgress umep = (UseMoveEvolutionProgress)evolutionProgress;
                    return umep.currentProgress().getMove().equals(move);
                }
                return false;
            }, UseMoveEvolutionProgress::new);
            progress.updateProgress(new UseMoveEvolutionProgress.Progress(move, progress.currentProgress().getAmount() + 1));
        }
    }

    public static boolean shouldRetreat(PokemonEntity pokemonEntity) {
        return pokemonEntity.method_35057() != null && (double)pokemonEntity.method_6032() < (double)pokemonEntity.method_6063() * 0.5 && Arrays.stream(CobblemonFightOrFlight.moveConfig().emergency_exit_like_abilities).toList().contains(pokemonEntity.getPokemon().getAbility().getName());
    }

    public static void makeCobblemonParticle(class_1297 entity, String particleName) {
        if (entity != null) {
            RunPosableMoLangPacket packet = new RunPosableMoLangPacket(entity.method_5628(), Set.of(String.format("q.particle('cobblemon:%s', 'target')", particleName)));
            packet.sendToPlayersAround(entity.method_23317(), entity.method_23318(), entity.method_23321(), 50.0, entity.method_37908().method_27983(), serverPlayer -> false);
        }
    }

    public static class_1799 getHeldItem(PokemonEntity pokemonEntity) {
        if (pokemonEntity == null) {
            return null;
        }
        return PokemonUtils.getHeldItem(pokemonEntity.getPokemon());
    }

    public static class_1799 getHeldItem(Pokemon pokemon) {
        if (pokemon == null) {
            return null;
        }
        return pokemon.heldItem();
    }

    public static boolean isUsingNewHealthMechanic() {
        return CobblemonFightOrFlight.commonConfig().shouldOverrideUpdateMaxHealth;
    }

    public static String getNatureName(PokemonEntity pokemonEntity) {
        return PokemonUtils.getNatureName(pokemonEntity.getPokemon());
    }

    public static String getNatureName(Pokemon pokemon) {
        return pokemon.getNature().getDisplayName().toLowerCase().replace("cobblemon.nature.", "");
    }

    public static int getMaxHealth(PokemonEntity pokemonEntity) {
        return PokemonUtils.getMaxHealth(pokemonEntity.getPokemon());
    }

    public static int getHPStat(Pokemon pokemon) {
        return pokemon.getMaxHealth();
    }

    public static int getMaxHealth(Pokemon pokemon) {
        int hpStat = PokemonUtils.getHPStat(pokemon);
        int minStat = CobblemonFightOrFlight.commonConfig().min_HP_required_stat;
        int midStat = CobblemonFightOrFlight.commonConfig().mid_HP_required_stat;
        int maxStat = CobblemonFightOrFlight.commonConfig().max_HP_required_stat;
        int stat = class_3532.method_15340((int)hpStat, (int)minStat, (int)maxStat);
        int minHealth = CobblemonFightOrFlight.commonConfig().min_HP;
        int midHealth = CobblemonFightOrFlight.commonConfig().mid_HP;
        int maxHealth = CobblemonFightOrFlight.commonConfig().max_HP;
        int health = minHealth;
        health = Math.round(stat < midStat ? class_3532.method_16439((float)((float)(stat - minStat) / (float)(midStat - minStat)), (float)minHealth, (float)midHealth) : class_3532.method_16439((float)((float)(stat - midStat) / (float)(maxStat - midStat)), (float)midHealth, (float)maxHealth));
        return health;
    }

    public static void entityHpToPokemonHp(PokemonEntity pokemonEntity, float amount, boolean isHealing) {
        Pokemon pokemon = pokemonEntity.getPokemon();
        if (pokemon.getCurrentHealth() == 0 || pokemonEntity.isBattling() || pokemonEntity.method_35057() == null && !CobblemonFightOrFlight.commonConfig().enable_health_sync_for_wild_pokemon) {
            return;
        }
        float ratio = amount / (float)PokemonUtils.getMaxHealth(pokemonEntity);
        int val = pokemon.getCurrentHealth() + (int)Math.floor(ratio * (float)PokemonUtils.getHPStat(pokemon)) * (isHealing ? 1 : -1);
        pokemon.setCurrentHealth(val);
    }

    public static void taunt(PokemonEntity pokemonEntity) {
        class_1309 class_13092 = pokemonEntity.method_35057();
        if (class_13092 instanceof class_1657) {
            class_1657 player = (class_1657)class_13092;
            List entities = pokemonEntity.method_37908().method_8390(class_1308.class, pokemonEntity.method_5829().method_1009(10.0, 2.0, 10.0), mob -> mob.method_5968() == player);
            for (class_1308 mob2 : entities) {
                mob2.method_5980((class_1309)pokemonEntity);
            }
        }
    }

    public static boolean isSheerForce(PokemonEntity pokemonEntity) {
        return PokemonUtils.abilityIs(pokemonEntity, "sheerforce");
    }

    public static boolean abilityIs(PokemonEntity pokemonEntity, String abilityName) {
        return pokemonEntity.getPokemon().getAbility().getName().equals(abilityName);
    }

    public static boolean canActivateSheerForce(PokemonEntity pokemonEntity) {
        Move move;
        if (pokemonEntity != null && PokemonUtils.isSheerForce(pokemonEntity) && (move = PokemonUtils.getMove(pokemonEntity)) != null && MoveData.moveData.containsKey(move.getName())) {
            for (MoveData data : MoveData.moveData.get(move.getName())) {
                if (!data.canActivateSheerForce()) continue;
                return true;
            }
        }
        return false;
    }

    public static PokeStaffComponent.CMDMODE getCommandMode(PokemonEntity pokemon) {
        return CMDMODE_IDS.getOrDefault(((PokemonInterface)pokemon).getCommand().toLowerCase(), PokeStaffComponent.CMDMODE.NOCMD);
    }

    public static boolean WildPokemonCanPerformUnprovokedAttack(PokemonEntity pokemonEntity) {
        return pokemonEntity != null && CobblemonFightOrFlight.commonConfig().do_pokemon_attack_unprovoked && pokemonEntity.getPokemon().getLevel() >= CobblemonFightOrFlight.commonConfig().minimum_attack_unprovoked_level && !pokemonEntity.getPokemon().isPlayerOwned();
    }

    public static String getCommandData(PokemonEntity pokemonEntity) {
        return ((PokemonInterface)pokemonEntity).getCommandData();
    }

    public static boolean moveCommandAvailable(PokemonEntity pokemonEntity) {
        return pokemonEntity.method_35057() != null && PokeStaffComponent.CMDMODE.MOVE == PokemonUtils.getCommandMode(pokemonEntity);
    }

    public static boolean moveAttackCommandAvailable(PokemonEntity pokemonEntity) {
        return pokemonEntity.method_35057() != null && PokeStaffComponent.CMDMODE.MOVE_ATTACK == PokemonUtils.getCommandMode(pokemonEntity);
    }

    public static boolean stayCommandAvailable(PokemonEntity pokemonEntity) {
        return pokemonEntity.method_35057() != null && PokeStaffComponent.CMDMODE.STAY == PokemonUtils.getCommandMode(pokemonEntity);
    }

    public static boolean attackPositionAvailable(PokemonEntity pokemonEntity) {
        return pokemonEntity.method_35057() != null && PokeStaffComponent.CMDMODE.ATTACK_POSITION == PokemonUtils.getCommandMode(pokemonEntity);
    }

    public static boolean shouldDisableFollowOwner(PokemonEntity pokemon) {
        if (pokemon.method_35057() == null) {
            return false;
        }
        PokeStaffComponent.CMDMODE cmd = PokemonUtils.getCommandMode(pokemon);
        switch (cmd) {
            case ATTACK: 
            case ATTACK_POSITION: 
            case MOVE_ATTACK: 
            case STAY: 
            case MOVE: {
                return true;
            }
        }
        return false;
    }

    public static void clearCommand(PokemonEntity pokemonEntity) {
        ((PokemonInterface)pokemonEntity).setCommand(PokeStaffComponent.CMDMODE.NOCMD.name());
        ((PokemonInterface)pokemonEntity).setCommandData("");
    }

    public static void finishMoving(PokemonEntity pokemonEntity) {
        if (CobblemonFightOrFlight.commonConfig().stay_after_move_command) {
            if (PokemonUtils.moveCommandAvailable(pokemonEntity)) {
                ((PokemonInterface)pokemonEntity).setCommand(PokeStaffComponent.CMDMODE.STAY.name());
                pokemonEntity.getNavigation().method_6340();
            }
        } else {
            PokemonUtils.clearCommand(pokemonEntity);
        }
    }

    public static void pokemonEntityApproachPos(PokemonEntity pokemonEntity, class_2338 pos, double speedModifier) {
        if (pos != class_2338.field_10980 && pokemonEntity.getNavigation().method_6357()) {
            pokemonEntity.getNavigation().method_6337((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), speedModifier);
        }
    }

    public static float getAttackRadius() {
        return 16.0f;
    }

    public static boolean shouldStopRunningAfterHurt(PokemonEntity pokemonEntity) {
        if (CobblemonFightOrFlight.commonConfig().stop_running_after_hurt) {
            return pokemonEntity.method_6032() < pokemonEntity.method_6063();
        }
        return false;
    }

    public static boolean pokemonTryForceEncounter(PokemonEntity attackingPokemon, class_1297 hurtTarget) {
        if (attackingPokemon == null || hurtTarget == null) {
            return false;
        }
        if (hurtTarget instanceof PokemonEntity) {
            PokemonEntity defendingPokemon = (PokemonEntity)hurtTarget;
            if (attackingPokemon.getPokemon().isPlayerOwned()) {
                if (defendingPokemon.getPokemon().isPlayerOwned()) {
                    if (!(!CobblemonFightOrFlight.commonConfig().force_player_battle_on_pokemon_hurt || CobblemonFightOrFlight.commonConfig().force_player_battle_check_team && FOFUtils.teamCheck((class_1309)attackingPokemon, (class_1309)defendingPokemon))) {
                        return PokemonUtils.pokemonForceEncounterPvP(attackingPokemon, defendingPokemon);
                    }
                } else if (CobblemonFightOrFlight.commonConfig().force_wild_battle_on_pokemon_hurt) {
                    return PokemonUtils.pokemonForceEncounterPvE(attackingPokemon, defendingPokemon);
                }
            } else if (defendingPokemon.getPokemon().isPlayerOwned() && CobblemonFightOrFlight.commonConfig().force_wild_battle_on_pokemon_hurt) {
                return PokemonUtils.pokemonForceEncounterPvE(defendingPokemon, attackingPokemon);
            }
        } else if (hurtTarget instanceof class_3222) {
            class_3222 player = (class_3222)hurtTarget;
            if (attackingPokemon.getPokemon().isPlayerOwned()) {
                if (CobblemonFightOrFlight.commonConfig().force_player_battle_on_player_hurt) {
                    return PokemonUtils.pokemonForceEncounterPvP(player, attackingPokemon);
                }
            } else if (CobblemonFightOrFlight.commonConfig().force_wild_battle_on_player_hurt) {
                return PokemonUtils.pokemonForceEncounterPvE(player, attackingPokemon);
            }
        }
        return false;
    }

    public static boolean pokemonForceEncounterPvP(PokemonEntity playerPokemon, PokemonEntity opponentPokemon) {
        class_1309 class_13092 = playerPokemon.method_35057();
        if (class_13092 instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)class_13092;
            return PokemonUtils.pokemonForceEncounterPvP(serverPlayer, opponentPokemon);
        }
        return false;
    }

    public static boolean pokemonForceEncounterPvP(class_3222 serverPlayer, PokemonEntity opponentPokemon) {
        class_1309 class_13092;
        if (serverPlayer != null && (class_13092 = opponentPokemon.method_35057()) instanceof class_3222) {
            class_3222 serverOpponent = (class_3222)class_13092;
            if (serverPlayer == serverOpponent || !PokemonUtils.canBattlePlayer(serverPlayer) || !PokemonUtils.canBattlePlayer(serverOpponent)) {
                return false;
            }
            BattleBuilder.INSTANCE.pvp1v1(serverPlayer, serverOpponent, null, null, BattleFormat.Companion.getGEN_9_SINGLES(), false, false);
        }
        return false;
    }

    public static boolean pokemonForceEncounterPvE(class_3222 serverPlayer, PokemonEntity wildPokemon) {
        if (serverPlayer != null) {
            if (!PokemonUtils.canBattlePlayer(serverPlayer)) {
                return false;
            }
            BattleBuilder.INSTANCE.pve(serverPlayer, wildPokemon, null, BattleFormat.Companion.getGEN_9_SINGLES(), false, false, Cobblemon.config.getDefaultFleeDistance(), (PartyStore)Cobblemon.INSTANCE.getStorage().getParty(serverPlayer));
        }
        return false;
    }

    public static boolean pokemonForceEncounterPvE(PokemonEntity playerPokemon, PokemonEntity wildPokemon) {
        class_1309 class_13092 = playerPokemon.method_35057();
        if (class_13092 instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)class_13092;
            if (!PokemonUtils.canBattlePlayer(serverPlayer)) {
                return false;
            }
            BattleBuilder.INSTANCE.pve(serverPlayer, wildPokemon, playerPokemon.getPokemon().getUuid(), BattleFormat.Companion.getGEN_9_SINGLES(), false, false, Cobblemon.config.getDefaultFleeDistance(), (PartyStore)Cobblemon.INSTANCE.getStorage().getParty(serverPlayer));
        }
        return false;
    }

    public static boolean canBattlePlayer(class_3222 serverPlayer) {
        boolean playerHasAlivePokemon = false;
        for (Pokemon pokemon : Cobblemon.INSTANCE.getStorage().getParty(serverPlayer)) {
            if (pokemon.isFainted()) continue;
            playerHasAlivePokemon = true;
            break;
        }
        return BattleRegistry.INSTANCE.getBattleByParticipatingPlayer(serverPlayer) == null && playerHasAlivePokemon && serverPlayer.method_5805();
    }

    public static boolean canAttackTargetProactively(class_1309 livingEntity) {
        if (livingEntity == null) {
            return false;
        }
        boolean isEnemy = livingEntity instanceof class_1569;
        return isEnemy;
    }

    public static boolean shouldCheckPokeStaff() {
        return CobblemonFightOrFlight.commonConfig().should_check_poke_staff;
    }
}

