package me.rufia.fightorflight.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import me.rufia.fightorflight.CobblemonFightOrFlight;
import me.rufia.fightorflight.entity.PokemonAttackEffect;
import me.rufia.fightorflight.entity.projectile.PokemonArrow;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

import java.awt.*;

public class PokemonArrowRenderer extends EntityRenderer<PokemonArrow> {
    private static final ResourceLocation TEXTURE_LOCATION = new ResourceLocation(CobblemonFightOrFlight.MODID, "textures/entity/arrow_bullet.png");
    public  PokemonArrowRenderer(EntityRendererProvider.Context context) {
        super(context);
    }
    public void render(PokemonArrow entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        Color color = Color.white;
        if (entity.getElementalType() != null) {
            color = PokemonAttackEffect.getColorFromType(entity.getElementalType());
        }
        poseStack.m_85836_();
        poseStack.m_252781_(Axis.f_252436_.m_252977_(Mth.m_14179_(partialTicks, entity.f_19859_, entity.m_146908_()) - 90.0F));
        poseStack.m_252781_(Axis.f_252403_.m_252977_(Mth.m_14179_(partialTicks, entity.f_19860_, entity.m_146909_())));
        boolean i = false;
        float f = 0.0F;
        float g = 0.5F;
        float h = 0.0F;
        float j = 0.15625F;
        float k = 0.0F;
        float l = 0.15625F;
        float m = 0.15625F;
        float n = 0.3125F;
        float o = 0.05625F;
        float p = 0f - partialTicks;
        if (p > 0.0F) {
            float q = -Mth.m_14031_(p * 3.0F) * p;
            poseStack.m_252781_(Axis.f_252403_.m_252977_(q));
        }

        poseStack.m_252781_(Axis.f_252529_.m_252977_(45.0F));
        poseStack.m_85841_(0.05625F, 0.05625F, 0.05625F);
        poseStack.m_252880_(-4.0F, 0.0F, 0.0F);
        VertexConsumer vertexConsumer = buffer.m_6299_(RenderType.m_110452_(this.getTextureLocation(entity)));
        PoseStack.Pose pose = poseStack.m_85850_();
        Matrix4f matrix4f = pose.m_252922_();
        Matrix3f matrix3f = pose.m_252943_();
        this.vertex(matrix4f, matrix3f, vertexConsumer, -7, -2, -2, 0.0F, 0.15625F, -1, 0, 0, packedLight,color);
        this.vertex(matrix4f, matrix3f, vertexConsumer, -7, -2, 2, 0.15625F, 0.15625F, -1, 0, 0, packedLight,color);
        this.vertex(matrix4f, matrix3f, vertexConsumer, -7, 2, 2, 0.15625F, 0.3125F, -1, 0, 0, packedLight,color);
        this.vertex(matrix4f, matrix3f, vertexConsumer, -7, 2, -2, 0.0F, 0.3125F, -1, 0, 0, packedLight,color);
        this.vertex(matrix4f, matrix3f, vertexConsumer, -7, 2, -2, 0.0F, 0.15625F, 1, 0, 0, packedLight,color);
        this.vertex(matrix4f, matrix3f, vertexConsumer, -7, 2, 2, 0.15625F, 0.15625F, 1, 0, 0, packedLight,color);
        this.vertex(matrix4f, matrix3f, vertexConsumer, -7, -2, 2, 0.15625F, 0.3125F, 1, 0, 0, packedLight,color);
        this.vertex(matrix4f, matrix3f, vertexConsumer, -7, -2, -2, 0.0F, 0.3125F, 1, 0, 0, packedLight,color);

        for(int r = 0; r < 4; ++r) {
            poseStack.m_252781_(Axis.f_252529_.m_252977_(90.0F));
            this.vertex(matrix4f, matrix3f, vertexConsumer, -8, -2, 0, 0.0F, 0.0F, 0, 1, 0, packedLight,color);
            this.vertex(matrix4f, matrix3f, vertexConsumer, 8, -2, 0, 0.5F, 0.0F, 0, 1, 0, packedLight,color);
            this.vertex(matrix4f, matrix3f, vertexConsumer, 8, 2, 0, 0.5F, 0.15625F, 0, 1, 0, packedLight,color);
            this.vertex(matrix4f, matrix3f, vertexConsumer, -8, 2, 0, 0.0F, 0.15625F, 0, 1, 0, packedLight,color);
        }

        poseStack.m_85849_();
        super.m_7392_(entity, entityYaw, partialTicks, poseStack, buffer, packedLight);
    }
    public void vertex(Matrix4f matrix, Matrix3f normal, VertexConsumer consumer, int x, int y, int z, float u, float v, int normalX, int normalZ, int normalY, int packedLight,Color col) {
        consumer.m_252986_(matrix, (float)x, (float)y, (float)z).m_6122_(col.getRed(), col.getGreen(), col.getBlue(), 255).m_7421_(u, v).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_252939_(normal, (float)normalX, (float)normalY, (float)normalZ).m_5752_();
    }
    public void vertex(Matrix4f matrix, Matrix3f normal, VertexConsumer consumer, int x, int y, int z, float u, float v, int normalX, int normalZ, int normalY, int packedLight) {
        consumer.m_252986_(matrix, (float)x, (float)y, (float)z).m_6122_(255, 255, 255, 255).m_7421_(u, v).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_252939_(normal, (float)normalX, (float)normalY, (float)normalZ).m_5752_();
    }
    public ResourceLocation getTextureLocation(PokemonArrow entity) {
        return TEXTURE_LOCATION;
    }
}
