package me.rufia.fightorflight.client.renderer;

import com.cobblemon.mod.common.api.moves.Move;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import me.rufia.fightorflight.CobblemonFightOrFlight;
import me.rufia.fightorflight.PokemonInterface;
import me.rufia.fightorflight.entity.PokemonAttackEffect;
import me.rufia.fightorflight.utils.PokemonUtils;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

import java.awt.*;

//This class hasn't been used!
public class PokemonPostRenderer {
    private static final ResourceLocation BEAM_LOCATION = new ResourceLocation(CobblemonFightOrFlight.MODID, "textures/entity/beam.png");
    private static final RenderType BEAM_RENDER_TYPE;

    private static Vec3 getPosition(LivingEntity livingEntity, double yOffset, float partialTick) {
        double d = Mth.m_14139_((double) partialTick, livingEntity.f_19790_, livingEntity.m_20185_());
        double e = Mth.m_14139_((double) partialTick, livingEntity.f_19791_, livingEntity.m_20186_()) + yOffset;
        double f = Mth.m_14139_((double) partialTick, livingEntity.f_19792_, livingEntity.m_20189_());
        return new Vec3(d, e, f);
    }

    public static void postRender(PokemonEntity entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        LivingEntity livingEntity = entity.m_5448_();
        int attackTime = ((PokemonInterface) (Object) entity).getAttackTime();
        boolean enabled = ((PokemonInterface) (Object) entity).usingBeam() && !entity.isBattling();
        if (livingEntity != null) {
            if (livingEntity.m_6084_() && attackTime > 0 && enabled) {
                Move move = PokemonUtils.getMove(entity);
                if (move == null) {
                    CobblemonFightOrFlight.LOGGER.info("Trying to use a null move");
                    return;
                }
                //CobblemonFightOrFlight.LOGGER.info(move.getName());
                //float f = 0.2F;//entity.getAttackAnimationScale(partialTicks);
                float g = 40 + partialTicks + attackTime;//entity.getClientSideAttackTime() + partialTicks;
                Color color = Color.white;
                color = PokemonAttackEffect.getColorFromType(move.getType().getName());
                float h = g * 0.5F % 1.0F;
                float i = entity.m_20192_();
                poseStack.m_85836_();
                poseStack.m_252880_(0.0F, i, 0.0F);
                Vec3 vec3 = getPosition(livingEntity, (double) livingEntity.m_20206_() * 0.5, partialTicks);
                Vec3 vec32 = getPosition(entity, (double) i, partialTicks);
                Vec3 vec33 = vec3.m_82546_(vec32);
                float j = (float) (vec33.m_82553_() + 1.0);
                vec33 = vec33.m_82541_();
                float k = (float) Math.acos(vec33.f_82480_);
                float l = (float) Math.atan2(vec33.f_82481_, vec33.f_82479_);
                poseStack.m_252781_(Axis.f_252436_.m_252977_((1.5707964F - l) * 57.295776F));
                poseStack.m_252781_(Axis.f_252529_.m_252977_(k * 57.295776F));
                boolean m = true;
                float n = g * 0.05F * -1.5F;
                int p = color.getRed();
                int q = color.getGreen();
                int r = color.getBlue();
                float s = 0.2F;
                float t = 0.282F;
                float u = Mth.m_14089_(n + 2.3561945F) * 0.282F;
                float v = Mth.m_14031_(n + 2.3561945F) * 0.282F;
                float w = Mth.m_14089_(n + 0.7853982F) * 0.282F;
                float x = Mth.m_14031_(n + 0.7853982F) * 0.282F;
                float y = Mth.m_14089_(n + 3.926991F) * 0.282F;
                float z = Mth.m_14031_(n + 3.926991F) * 0.282F;
                float aa = Mth.m_14089_(n + 5.4977875F) * 0.282F;
                float ab = Mth.m_14031_(n + 5.4977875F) * 0.282F;
                float ac = Mth.m_14089_(n + 3.1415927F) * 0.2F;
                float ad = Mth.m_14031_(n + 3.1415927F) * 0.2F;
                float ae = Mth.m_14089_(n + 0.0F) * 0.2F;
                float af = Mth.m_14031_(n + 0.0F) * 0.2F;
                float ag = Mth.m_14089_(n + 1.5707964F) * 0.2F;
                float ah = Mth.m_14031_(n + 1.5707964F) * 0.2F;
                float ai = Mth.m_14089_(n + 4.712389F) * 0.2F;
                float aj = Mth.m_14031_(n + 4.712389F) * 0.2F;
                float al = 0.0F;
                float am = 0.4999F;
                float an = -1.0F + h;
                float ao = j * 2.5F + an;
                VertexConsumer vertexConsumer = buffer.m_6299_(BEAM_RENDER_TYPE);
                PoseStack.Pose pose = poseStack.m_85850_();
                Matrix4f matrix4f = pose.m_252922_();
                Matrix3f matrix3f = pose.m_252943_();
                vertex(vertexConsumer, matrix4f, matrix3f, ac, j, ad, p, q, r, 0.4999F, ao);
                vertex(vertexConsumer, matrix4f, matrix3f, ac, 0.0F, ad, p, q, r, 0.4999F, an);
                vertex(vertexConsumer, matrix4f, matrix3f, ae, 0.0F, af, p, q, r, 0.0F, an);
                vertex(vertexConsumer, matrix4f, matrix3f, ae, j, af, p, q, r, 0.0F, ao);
                vertex(vertexConsumer, matrix4f, matrix3f, ag, j, ah, p, q, r, 0.4999F, ao);
                vertex(vertexConsumer, matrix4f, matrix3f, ag, 0.0F, ah, p, q, r, 0.4999F, an);
                vertex(vertexConsumer, matrix4f, matrix3f, ai, 0.0F, aj, p, q, r, 0.0F, an);
                vertex(vertexConsumer, matrix4f, matrix3f, ai, j, aj, p, q, r, 0.0F, ao);
                float ap = 0.0F;
                if (entity.f_19797_ % 2 == 0) {
                    ap = 0.5F;
                }

                vertex(vertexConsumer, matrix4f, matrix3f, u, j, v, p, q, r, 0.5F, ap + 0.5F);
                vertex(vertexConsumer, matrix4f, matrix3f, w, j, x, p, q, r, 1.0F, ap + 0.5F);
                vertex(vertexConsumer, matrix4f, matrix3f, aa, j, ab, p, q, r, 1.0F, ap);
                vertex(vertexConsumer, matrix4f, matrix3f, y, j, z, p, q, r, 0.5F, ap);
                poseStack.m_85849_();
            }
        }
    }

    private static void vertex(VertexConsumer consumer, Matrix4f pose, Matrix3f normal, float x, float y, float z, int red, int green, int blue, float u, float v) {
        consumer.m_252986_(pose, x, y, z).m_6122_(red, green, blue, 255).m_7421_(u, v).m_86008_(OverlayTexture.f_118083_).m_85969_(15728880).m_252939_(normal, 0.0F, 1.0F, 0.0F).m_5752_();
    }

    static {
        BEAM_RENDER_TYPE = RenderType.m_110458_(BEAM_LOCATION);
    }
}
