package me.rufia.fightorflight.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import me.rufia.fightorflight.CobblemonFightOrFlight;
import me.rufia.fightorflight.entity.PokemonAttackEffect;
import me.rufia.fightorflight.client.model.PokemonBulletModel;
import me.rufia.fightorflight.entity.projectile.PokemonTracingBullet;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

import java.awt.*;


public class PokemonTracingBulletRenderer extends EntityRenderer<PokemonTracingBullet> {
    private static final ResourceLocation TEXTURE_LOCATION = new ResourceLocation(CobblemonFightOrFlight.MODID, "textures/entity/tracing_bullet_spark.png");
    private static final RenderType RENDER_TYPE;
    private final PokemonBulletModel<PokemonTracingBullet> model;

    public PokemonTracingBulletRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.model = new PokemonBulletModel(context.m_174023_(ModelLayers.f_171181_));
    }
    protected int getBlockLightLevel(PokemonTracingBullet entity, BlockPos pos) {
        return 15;
    }

    public void render(PokemonTracingBullet entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        Color color = Color.white;
        if (entity.getElementalType() != null) {
            color = PokemonAttackEffect.getColorFromType(entity.getElementalType());
        }

        poseStack.m_85836_();
        float f = Mth.m_14189_(partialTicks, entity.f_19859_, entity.m_146908_());
        float g = Mth.m_14179_(partialTicks, entity.f_19860_, entity.m_146909_());
        float h = (float) entity.f_19797_ + partialTicks;
        poseStack.m_252880_(0.0F, 0.15F, 0.0F);
        poseStack.m_252781_(Axis.f_252436_.m_252977_(Mth.m_14031_(h * 0.1F) * 180.0F));
        poseStack.m_252781_(Axis.f_252529_.m_252977_(Mth.m_14089_(h * 0.1F) * 180.0F));
        poseStack.m_252781_(Axis.f_252403_.m_252977_(Mth.m_14031_(h * 0.15F) * 360.0F));
        poseStack.m_85841_(-0.5F, -0.5F, 0.5F);
        this.model.m_6973_(entity, 0.0F, 0.0F, 0.0F, f, g);
        VertexConsumer vertexConsumer = buffer.m_6299_(this.model.m_103119_(TEXTURE_LOCATION));
        this.model.m_7695_(poseStack, vertexConsumer, packedLight, OverlayTexture.f_118083_, 1.0F, 1.0F, 1.0F, 1.0F);
        poseStack.m_85841_(1.5F, 1.5F, 1.5F);
        VertexConsumer vertexConsumer2 = buffer.m_6299_(RENDER_TYPE);
        this.model.m_7695_(poseStack, vertexConsumer2, packedLight, OverlayTexture.f_118083_, (float) color.getRed() / 255, (float) color.getGreen() / 255, (float) color.getBlue() / 255, 0.75F);
        poseStack.m_85849_();
        super.m_7392_(entity, entityYaw, partialTicks, poseStack, buffer, packedLight);
    }

    public ResourceLocation getTextureLocation(PokemonTracingBullet entity) {
        return TEXTURE_LOCATION;
    }

    static {
        RENDER_TYPE = RenderType.m_110473_(TEXTURE_LOCATION);
    }
}
