package me.rufia.fightorflight.entity;

import dev.architectury.registry.level.entity.EntityAttributeRegistry;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import me.rufia.fightorflight.CobblemonFightOrFlight;
import me.rufia.fightorflight.entity.projectile.PokemonArrow;
import me.rufia.fightorflight.entity.projectile.PokemonBullet;
import me.rufia.fightorflight.entity.projectile.PokemonTracingBullet;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.projectile.Projectile;

import java.util.function.Supplier;

public interface EntityFightOrFlight {
    DeferredRegister<EntityType<?>> ENTITY_TYPES = DeferredRegister.create(CobblemonFightOrFlight.MODID, Registries.f_256939_);
    RegistrySupplier<EntityType<PokemonTracingBullet>> TRACING_BULLET = registerProjectile("tracing_bullet",
            EntityType.Builder.<PokemonTracingBullet>m_20704_(PokemonTracingBullet::new
                    , MobCategory.MISC).m_20699_(0.3125f, 0.3125f));
    RegistrySupplier<EntityType<PokemonArrow>> ARROW_PROJECTILE = registerProjectile("arrow_projectile",
            EntityType.Builder.<PokemonArrow>m_20704_(PokemonArrow::new
                    , MobCategory.MISC).m_20699_(0.5F, 0.5F).m_20702_(4).m_20717_(20));
    RegistrySupplier<EntityType<PokemonBullet>> BULLET=registerProjectile("bullet_projectile",
            EntityType.Builder.<PokemonBullet>m_20704_(PokemonBullet::new,MobCategory.MISC).m_20699_(0.3125f,0.3125f));
    static void bootstrap() {
        ENTITY_TYPES.register();
    }

    static <T extends LivingEntity> RegistrySupplier<EntityType<T>> register(String name, EntityType.Builder<T> builder, Supplier<AttributeSupplier.Builder> attributes) {
        ResourceLocation id = new ResourceLocation(CobblemonFightOrFlight.MODID, name);
        return ENTITY_TYPES.register(id, () -> {
            EntityType<T> result = builder.m_20712_(id.toString());
            EntityAttributeRegistry.register(() -> result, attributes);

            return result;
        });
    }

    static <T extends Projectile> RegistrySupplier<EntityType<T>> registerProjectile(String name, EntityType.Builder<T> builder) {
        ResourceLocation id = new ResourceLocation(CobblemonFightOrFlight.MODID, name);
        return ENTITY_TYPES.register(id, () -> {
            EntityType<T> result = builder.m_20712_(id.toString());
            return result;
        });
    }
}
