package me.rufia.fightorflight.entity.projectile;

import com.cobblemon.mod.common.api.moves.Move;
import com.cobblemon.mod.common.api.moves.categories.DamageCategories;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.Pokemon;
import me.rufia.fightorflight.CobblemonFightOrFlight;
import me.rufia.fightorflight.entity.PokemonAttackEffect;
import me.rufia.fightorflight.utils.PokemonUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;

import java.util.Iterator;
import java.util.List;
import java.util.Objects;

public abstract class AbstractPokemonProjectile extends ThrowableProjectile {


    public AbstractPokemonProjectile(EntityType<? extends AbstractPokemonProjectile> entityType, Level level) {
        super(entityType, level);
    }

    protected void initPosition(LivingEntity shooter) {
        this.m_5602_(shooter);
        BlockPos blockPos = shooter.m_20183_();
        float angle = shooter.m_146908_();
        //CobblemonFightOrFlight.LOGGER.info(String.valueOf(angle));
        double radius = 0.5 * shooter.m_20205_();
        double d = (double) blockPos.m_123341_() + 0.5 - radius * Math.sin(angle);
        double e = (double) blockPos.m_123342_() + Math.max(0.3f, shooter.m_20206_() * 0.67);
        double f = (double) blockPos.m_123343_() + 0.5 + radius * Math.cos(angle);
        this.m_7678_(d, e, f, this.m_146908_(), this.m_146909_());
    }


    private static final EntityDataAccessor<String> type = SynchedEntityData.m_135353_(AbstractPokemonProjectile.class, EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<Float> damage = SynchedEntityData.m_135353_(AbstractPokemonProjectile.class, EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Integer> category = SynchedEntityData.m_135353_(AbstractPokemonProjectile.class, EntityDataSerializers.f_135028_);

    protected void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128359_("Type", this.f_19804_.m_135370_(type));
        compound.m_128350_("Damage", this.f_19804_.m_135370_(damage));
    }

    public void m_8119_() {
        super.m_8119_();
        makeParticle(4);
    }

    protected void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.f_19804_.m_135381_(type, compound.m_128461_("Type"));
        this.f_19804_.m_135381_(damage, compound.m_128457_("Damage"));
    }

    protected void makeParticle(int particleAmount) {
        if (getElementalType() == null) {
            return;
        }
        PokemonAttackEffect.makeTypeEffectParticle(particleAmount, this, getElementalType());
    }

    public float getDamage() {
        return this.f_19804_.m_135370_(damage);
    }

    public void setDamage(float Damage) {
        this.f_19804_.m_135381_(damage, Damage);
    }

    public String getElementalType() {
        return this.f_19804_.m_135370_(type);
    }

    public void setElementalType(String Type) {
        this.f_19804_.m_135381_(type, Type);
    }

    public void applyTypeEffect(PokemonEntity pokemonEntity, LivingEntity hurtTarget) {
        if (!Objects.equals(getElementalType(), pokemonEntity.getPokemon().getPrimaryType().getName())) {
            PokemonAttackEffect.applyTypeEffect(pokemonEntity, hurtTarget, getElementalType());
        } else {
            PokemonAttackEffect.applyTypeEffect(pokemonEntity, hurtTarget);
        }
    }

    @Override
    protected void m_8097_() {
        this.f_19804_.m_135372_(type, "normal");
        this.f_19804_.m_135372_(damage, 1f);
    }

    protected void m_5790_(EntityHitResult result) {
        super.m_5790_(result);
        Entity owner = m_19749_();
        Entity target = result.m_82443_();
        if (owner instanceof PokemonEntity pokemonEntity) {
            PokemonUtils.setHurtByPlayer(pokemonEntity, target);
            PokemonAttackEffect.applyOnHitEffect(pokemonEntity, target, PokemonUtils.getMove(pokemonEntity));
        }
    }

    @Override
    protected boolean m_5603_(Entity target) {
        return target != m_19749_() && super.m_5603_(target);
    }

    protected void m_8060_(BlockHitResult result) {
        super.m_8060_(result);
    }

    public void accurateShoot(double x, double y, double z, float velocity, float inaccuracy) {
        double horizontalDistance = Math.sqrt(x * x + z * z);
        float g = m_7139_();
        double v2 = velocity * velocity;
        double delta = Math.sqrt(2 * v2 * g * y + v2 * v2 - g * g * horizontalDistance * horizontalDistance);
        double t = Math.sqrt(2 * (g * y + v2 - delta)) / g;
        double result = y + 0.5 * g * t * t;
        this.m_6686_(x, result, z, velocity, inaccuracy);
    }

    @Override
    protected float m_7139_() {
        return 0.05f;
    }
}
