package me.rufia.fightorflight.entity.projectile;

import com.cobblemon.mod.common.api.moves.Move;
import com.cobblemon.mod.common.api.moves.categories.DamageCategories;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.Pokemon;
import me.rufia.fightorflight.CobblemonFightOrFlight;
import me.rufia.fightorflight.entity.PokemonAttackEffect;
import me.rufia.fightorflight.utils.PokemonUtils;
import me.rufia.fightorflight.utils.explosion.FOFExplosion;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;

import java.util.Iterator;
import java.util.List;

public abstract class ExplosivePokemonProjectile extends AbstractPokemonProjectile {
    public ExplosivePokemonProjectile(EntityType<? extends AbstractPokemonProjectile> entityType, Level level) {
        super(entityType, level);
    }

    protected void explode(PokemonEntity owner) {
        m_9236_().m_7605_(this, (byte) 17);
        if (!this.m_9236_().f_46443_) {
            ((ServerLevel) this.m_9236_()).m_8767_(ParticleTypes.f_123813_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 2, 0.2, 0.2, 0.2, 0.0);
        }
        this.m_146852_(GameEvent.f_157812_, this.m_19749_());
        this.dealExplosionDamage(owner);
        this.m_146870_();
    }

    protected void dealExplosionDamage(PokemonEntity owner) {
        if (owner == null) {
            return;
        }
        FOFExplosion explosion = FOFExplosion.createExplosion(this, owner, m_20185_(), m_20186_(), m_20189_(), true);
        if (explosion != null) {
            explosion.m_46061_();
            explosion.finalizeExplosion();
        }
        /*
        Move move = PokemonUtils.getMove(owner);
        boolean isSpecial = false;
        if (move != null) {
            isSpecial = move.getDamageCategory().equals(DamageCategories.INSTANCE.getSPECIAL());
        }
        PokemonAttackEffect.dealAoEDamage(owner, this, isSpecial, true);

         */
    }

    @Override
    protected void m_8060_(BlockHitResult result) {
        BlockPos blockPos = new BlockPos(result.m_82425_());
        this.m_9236_().m_8055_(blockPos).m_60682_(this.m_9236_(), blockPos, this);
        if (!this.m_9236_().m_5776_() && m_19749_() instanceof PokemonEntity pokemonEntity) {
            this.explode(pokemonEntity);
        }
        super.m_8060_(result);
    }

    @Override
    protected void m_5790_(EntityHitResult result) {
        Entity owner = m_19749_();
        if (owner instanceof PokemonEntity pokemonEntity) {
            explode(pokemonEntity);
        }
    }
}
