package me.rufia.fightorflight.entity.projectile;

import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import me.rufia.fightorflight.entity.EntityFightOrFlight;
import me.rufia.fightorflight.entity.projectile.AbstractPokemonProjectile;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.*;

public class PokemonArrow extends AbstractPokemonProjectile {
    protected int knockback;

    public PokemonArrow(EntityType<? extends AbstractPokemonProjectile> entityType, Level level) {
        super(entityType, level);
        this.f_19794_ = true;
    }

    public PokemonArrow(Level level, LivingEntity shooter, Entity finalTarget) {
        super(EntityFightOrFlight.ARROW_PROJECTILE.get(), level);
        initPosition(shooter);
    }

    @Override
    protected void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
    }

    @Override
    protected void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
    }

    public void m_6686_(double x, double y, double z, float velocity, float inaccuracy) {
        super.m_6686_(x, y, z, velocity, inaccuracy);
    }

    public void m_6453_(double x, double y, double z, float yRot, float xRot, int lerpSteps, boolean teleport) {
        this.m_6034_(x, y, z);
        this.m_19915_(yRot, xRot);
    }

    public void m_6001_(double x, double y, double z) {
        super.m_6001_(x, y, z);
    }

    public void m_6478_(MoverType type, Vec3 pos) {
        super.m_6478_(type, pos);
    }

    public void m_8119_() {
        super.m_8119_();
        Vec3 vec3 = this.m_20184_();
        if (this.f_19860_ == 0.0F && this.f_19859_ == 0.0F) {
            double d = vec3.m_165924_();
            this.m_146922_((float) (Mth.m_14136_(vec3.f_82479_, vec3.f_82481_) * 57.2957763671875));
            this.m_146926_((float) (Mth.m_14136_(vec3.f_82480_, d) * 57.2957763671875));
            this.f_19859_ = this.m_146908_();
            this.f_19860_ = this.m_146909_();
        }
        double e = vec3.f_82479_;
        double f = vec3.f_82480_;
        double g = vec3.f_82481_;

        double h = this.m_20185_() + e;
        double j = this.m_20186_() + f;
        double k = this.m_20189_() + g;
        double l = vec3.m_165924_();
        if (this.f_19794_) {
            this.m_146922_((float) (Mth.m_14136_(-e, -g) * 57.2957763671875));
        } else {
            this.m_146922_((float) (Mth.m_14136_(e, g) * 57.2957763671875));
        }

        this.m_146926_((float) (Mth.m_14136_(f, l) * 57.2957763671875));
        this.m_146926_(m_37273_(this.f_19860_, this.m_146909_()));
        this.m_146922_(m_37273_(this.f_19859_, this.m_146908_()));
        float m = 0.99F;
        if (this.m_20069_()) {
            for (int o = 0; o < 4; ++o) {
                float p = 0.25F;
                this.m_9236_().m_7106_(ParticleTypes.f_123795_, h - e * 0.25, j - f * 0.25, k - g * 0.25, e, f, g);
            }

            m = this.getWaterInertia();
        }
        HitResult hitResult = ProjectileUtil.m_278158_(this, this::m_5603_);
        if (hitResult.m_6662_() != HitResult.Type.MISS) {
            this.m_6532_(hitResult);
        }
        this.m_20256_(vec3.m_82490_((double) m));
        if (!this.m_20068_() && !this.f_19794_) {
            Vec3 vec34 = this.m_20184_();
            this.m_20334_(vec34.f_82479_, vec34.f_82480_ - m_7139_(), vec34.f_82481_);
        }

        this.m_6034_(h, j, k);
        this.m_20101_();
    }

    protected void m_5790_(EntityHitResult result) {
        super.m_5790_(result);
        Entity target = result.m_82443_();
        Entity entity2 = this.m_19749_();
        DamageSource damageSource;
        float f = (float) this.m_20184_().m_82553_();

        if (entity2 instanceof LivingEntity livingEntity) {
            damageSource = this.m_269291_().m_269333_(livingEntity);
            livingEntity.m_21335_(target);
        } else {
            damageSource = this.m_269291_().m_269264_();
        }

        boolean bl = target.m_6095_() == EntityType.f_20566_;

        if (target.m_6469_(damageSource, getDamage())) {
            if (bl) {
                return;
            }
            if (target instanceof LivingEntity livingEntity) {
                if (this.knockback > 0) {
                    double d = Math.max(0.0, 1.0 - livingEntity.m_21133_(Attributes.f_22278_));
                    Vec3 vec3 = this.m_20184_().m_82542_(1.0, 0.0, 1.0).m_82541_().m_82490_((double) this.knockback * 0.6 * d);
                    if (vec3.m_82556_() > 0.0) {
                        livingEntity.m_5997_(vec3.f_82479_, 0.1, vec3.f_82481_);
                    }
                }
                if (entity2 instanceof PokemonEntity pokemonEntity) {
                    applyTypeEffect(pokemonEntity, livingEntity);
                }
            }
            this.m_146870_();
        } else {
            this.m_20256_(this.m_20184_().m_82490_(-0.1));
            this.m_146922_(this.m_146908_() + 180.0F);
            this.f_19859_ += 180.0F;
        }

    }

    protected void m_8060_(BlockHitResult result) {
        super.m_8060_(result);
        Vec3 vec3 = result.m_82450_().m_82492_(this.m_20185_(), this.m_20186_(), this.m_20189_());
        this.m_20256_(vec3);
        Vec3 vec32 = vec3.m_82541_().m_82490_(0.05000000074505806);
        this.m_20343_(this.m_20185_() - vec32.f_82479_, this.m_20186_() - vec32.f_82480_, this.m_20189_() - vec32.f_82481_);
        this.m_146870_();
    }

    protected boolean m_5603_(Entity target) {
        return super.m_5603_(target);
    }

    protected float getWaterInertia() {
        return 0.6F;
    }


}