package me.rufia.fightorflight.entity.projectile;

import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import me.rufia.fightorflight.CobblemonFightOrFlight;
import me.rufia.fightorflight.entity.EntityFightOrFlight;
import me.rufia.fightorflight.entity.projectile.AbstractPokemonProjectile;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class PokemonBullet extends ExplosivePokemonProjectile{
    public PokemonBullet(EntityType<? extends AbstractPokemonProjectile> entityType, Level level) {
        super(entityType, level);
        this.f_19794_ = true;
    }

    public PokemonBullet(Level level, LivingEntity shooter, Entity finalTarget) {
        super(EntityFightOrFlight.BULLET.get(), level);
        initPosition(shooter);
    }

    public void m_6453_(double x, double y, double z, float yRot, float xRot, int lerpSteps, boolean teleport) {
        this.m_6034_(x, y, z);
        this.m_19915_(yRot, xRot);
    }

    public void m_8119_() {
        super.m_8119_();
        Vec3 vec3 = this.m_20184_();
        if (this.f_19860_ == 0.0F && this.f_19859_ == 0.0F) {
            double d = vec3.m_165924_();
            this.m_146922_((float) (Mth.m_14136_(vec3.f_82479_, vec3.f_82481_) * 57.2957763671875));
            this.m_146926_((float) (Mth.m_14136_(vec3.f_82480_, d) * 57.2957763671875));
            this.f_19859_ = this.m_146908_();
            this.f_19860_ = this.m_146909_();
        }
        double e = vec3.f_82479_;
        double f = vec3.f_82480_;
        double g = vec3.f_82481_;

        double h = this.m_20185_() + e;
        double j = this.m_20186_() + f;
        double k = this.m_20189_() + g;
        double l = vec3.m_165924_();

        if (this.f_19794_) {
            this.m_146922_((float) (Mth.m_14136_(-e, -g) * 57.2957763671875));
        } else {
            this.m_146922_((float) (Mth.m_14136_(e, g) * 57.2957763671875));
        }

        this.m_146926_((float) (Mth.m_14136_(f, l) * 57.2957763671875));
        this.m_146926_(m_37273_(this.f_19860_, this.m_146909_()));
        this.m_146922_(m_37273_(this.f_19859_, this.m_146908_()));
        float n = m_7139_();
        if (this.m_20069_()) {
            for (int o = 0; o < 4; ++o) {
                float p = 0.25F;
                this.m_9236_().m_7106_(ParticleTypes.f_123795_, h - e * 0.25, j - f * 0.25, k - g * 0.25, e, f, g);
            }
        }

        if (!this.m_20068_() && !this.f_19794_) {
            Vec3 vec34 = this.m_20184_();
            this.m_20334_(vec34.f_82479_, vec34.f_82480_ - 0.05, vec34.f_82481_);
        }
        HitResult hitResult = ProjectileUtil.m_278158_(this, this::m_5603_);
        if (hitResult.m_6662_() != HitResult.Type.MISS) {
            this.m_6532_(hitResult);
        }
        this.m_6034_(h, j, k);
        this.m_20101_();
    }

    protected void m_5790_(EntityHitResult result) {
        super.m_5790_(result);
    }

    protected void m_6532_(HitResult result) {
        super.m_6532_(result);
    }

    protected void m_8060_(BlockHitResult result) {
        super.m_8060_(result);
    }
}
