package me.rufia.fightorflight.entity.projectile;

import com.google.common.collect.Lists;
import me.rufia.fightorflight.entity.EntityFightOrFlight;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

import java.util.List;
import java.util.UUID;


public class PokemonTracingBullet extends ExplosivePokemonProjectile {
    private static final double SPEED = 0.3;
    private static final int min_interval = 5;
    private static final int random_interval = 2;
    @Nullable
    private Entity finalTarget;
    @Nullable
    private Direction currentMoveDirection;
    private int flightSteps;
    private double targetDeltaX;
    private double targetDeltaY;
    private double targetDeltaZ;
    @Nullable
    private UUID targetId;

    public PokemonTracingBullet(EntityType<? extends PokemonTracingBullet> entityType, Level level) {
        super(entityType, level);
        this.f_19794_ = true;
    }

    public PokemonTracingBullet(Level level, LivingEntity shooter, Entity finalTarget, Direction.Axis axis) {
        super(EntityFightOrFlight.TRACING_BULLET.get(), level);
        initPosition(shooter);
        this.finalTarget = finalTarget;
        this.currentMoveDirection = Direction.UP;
        this.selectNextMoveDirection(axis);
        this.m_20242_(true);
    }

    @Override
    protected void m_8097_() {

        super.m_8097_();
    }

    @Override
    protected void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        if (this.finalTarget != null) {
            compound.m_128362_("Target", this.finalTarget.m_20148_());
        }
        if (getMoveDirection() != null) {
            compound.m_128405_("Dir", this.currentMoveDirection.m_122411_());
        }
        compound.m_128405_("Steps", this.flightSteps);
        compound.m_128347_("TXD", this.targetDeltaX);
        compound.m_128347_("TYD", this.targetDeltaY);
        compound.m_128347_("TZD", this.targetDeltaZ);
    }

    @Override
    protected void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.flightSteps = compound.m_128451_("Steps");
        this.targetDeltaX = compound.m_128459_("TXD");
        this.targetDeltaY = compound.m_128459_("TYD");
        this.targetDeltaZ = compound.m_128459_("TZD");
        if (compound.m_128425_("Dir", 99)) {
            this.currentMoveDirection = Direction.m_122376_(compound.m_128451_("Dir"));
        }

        if (compound.m_128403_("Target")) {
            this.targetId = compound.m_128342_("Target");
        }
    }

    @Nullable
    private Direction getMoveDirection() {
        return this.currentMoveDirection;
    }

    private void setMoveDirection(@Nullable Direction direction) {
        this.currentMoveDirection = direction;
    }

    private void selectNextMoveDirection(@Nullable Direction.Axis axis) {
        double d = 0.5;
        BlockPos blockPos;
        if (this.finalTarget == null) {
            blockPos = this.m_20183_().m_7495_();
        } else {
            d = (double) this.finalTarget.m_20206_() * 0.5;
            blockPos = BlockPos.m_274561_(this.finalTarget.m_20185_(), this.finalTarget.m_20186_() + d, this.finalTarget.m_20189_());
        }

        double e = (double) blockPos.m_123341_() + 0.5;
        double f = (double) blockPos.m_123342_() + d;
        double g = (double) blockPos.m_123343_() + 0.5;
        Direction direction = null;
        if (!blockPos.m_203195_(this.m_20182_(), 2.0)) {
            BlockPos blockPos2 = this.m_20183_();
            List<Direction> list = Lists.newArrayList();
            if (axis != Direction.Axis.X) {
                if (blockPos2.m_123341_() < blockPos.m_123341_() && this.m_9236_().m_46859_(blockPos2.m_122029_())) {
                    list.add(Direction.EAST);
                } else if (blockPos2.m_123341_() > blockPos.m_123341_() && this.m_9236_().m_46859_(blockPos2.m_122024_())) {
                    list.add(Direction.WEST);
                }
            }

            if (axis != Direction.Axis.Y) {
                if (blockPos2.m_123342_() < blockPos.m_123342_() && this.m_9236_().m_46859_(blockPos2.m_7494_())) {
                    list.add(Direction.UP);
                } else if (blockPos2.m_123342_() > blockPos.m_123342_() && this.m_9236_().m_46859_(blockPos2.m_7495_())) {
                    list.add(Direction.DOWN);
                }
            }

            if (axis != Direction.Axis.Z) {
                if (blockPos2.m_123343_() < blockPos.m_123343_() && this.m_9236_().m_46859_(blockPos2.m_122019_())) {
                    list.add(Direction.SOUTH);
                } else if (blockPos2.m_123343_() > blockPos.m_123343_() && this.m_9236_().m_46859_(blockPos2.m_122012_())) {
                    list.add(Direction.NORTH);
                }
            }

            direction = Direction.m_235672_(this.f_19796_);
            if (!list.isEmpty()) {
                direction = (Direction) list.get(this.f_19796_.m_188503_(list.size()));
            }
            for (int i = 5; !this.m_9236_().m_46859_(blockPos2.m_121945_(direction)) && i > 0; --i) {
                direction = Direction.m_235672_(this.f_19796_);
            }
            if (finalTarget == null && m_19749_() != null) {
                direction = Direction.DOWN;
            }

            e = this.m_20185_() + (double) direction.m_122429_();
            f = this.m_20186_() + (double) direction.m_122430_();
            g = this.m_20189_() + (double) direction.m_122431_();
        }

        this.setMoveDirection(direction);
        double h = e - this.m_20185_();
        double j = f - this.m_20186_();
        double k = g - this.m_20189_();
        double l = Math.sqrt(h * h + j * j + k * k);
        if (l == 0.0) {
            this.targetDeltaX = 0.0;
            this.targetDeltaY = 0.0;
            this.targetDeltaZ = 0.0;
        } else {
            this.targetDeltaX = h / l * SPEED;
            this.targetDeltaY = j / l * SPEED;
            this.targetDeltaZ = k / l * SPEED;
        }

        this.f_19812_ = true;
        this.flightSteps = min_interval + this.f_19796_.m_188503_(random_interval) * 3;
    }

    public void m_6043_() {
        if (this.m_9236_().m_46791_() == Difficulty.PEACEFUL) {
            this.m_146870_();
        }
    }


    public void m_8119_() {
        super.m_8119_();
        Vec3 vec3;
        if (!this.m_9236_().f_46443_) {
            if (this.finalTarget == null && this.targetId != null) {
                this.finalTarget = ((ServerLevel) this.m_9236_()).m_8791_(this.targetId);
                if (this.finalTarget == null) {
                    this.targetId = null;
                }
            }

            if (this.finalTarget == null || !this.finalTarget.m_6084_() || this.finalTarget instanceof Player && this.finalTarget.m_5833_()) {
                if (!this.m_20068_()) {
                    this.m_20256_(this.m_20184_().m_82520_(0.0, -0.04, 0.0));
                }
            } else {
                this.targetDeltaX = Mth.m_14008_(this.targetDeltaX * 1.025, -1.0, 1.0);
                this.targetDeltaY = Mth.m_14008_(this.targetDeltaY * 1.025, -1.0, 1.0);
                this.targetDeltaZ = Mth.m_14008_(this.targetDeltaZ * 1.025, -1.0, 1.0);
                vec3 = this.m_20184_();
                this.m_20256_(vec3.m_82520_((this.targetDeltaX - vec3.f_82479_) * 0.2, (this.targetDeltaY - vec3.f_82480_) * 0.2, (this.targetDeltaZ - vec3.f_82481_) * 0.2));
            }

            HitResult hitResult = ProjectileUtil.m_278158_(this, this::m_5603_);
            if (hitResult.m_6662_() != HitResult.Type.MISS) {
                this.m_6532_(hitResult);
            }
        }

        this.m_20101_();
        vec3 = this.m_20184_();
        this.m_6034_(this.m_20185_() + vec3.f_82479_, this.m_20186_() + vec3.f_82480_, this.m_20189_() + vec3.f_82481_);
        ProjectileUtil.m_37284_(this, 0.5F);
        if (this.m_9236_().f_46443_) {
            makeParticle(4);
        } else if (this.finalTarget != null && !this.finalTarget.m_213877_()) {
            if (this.flightSteps > 0) {
                --this.flightSteps;
                if (this.flightSteps == 0) {
                    this.selectNextMoveDirection(getMoveDirection() == null ? null : getMoveDirection().m_122434_());
                }
            }

            if (getMoveDirection() != null) {
                BlockPos blockPos = this.m_20183_();
                Direction.Axis axis = getMoveDirection().m_122434_();
                if (this.m_9236_().m_46575_(blockPos.m_121945_(getMoveDirection()), this)) {
                    this.selectNextMoveDirection(axis);
                } else {
                    BlockPos blockPos2 = this.finalTarget.m_20183_();
                    if (axis == Direction.Axis.X && blockPos.m_123341_() == blockPos2.m_123341_() || axis == Direction.Axis.Z && blockPos.m_123343_() == blockPos2.m_123343_() || axis == Direction.Axis.Y && blockPos.m_123342_() == blockPos2.m_123342_()) {
                        this.selectNextMoveDirection(axis);
                    }
                }
            }
        }

    }

    protected boolean m_5603_(Entity target) {
        return super.m_5603_(target) && !target.f_19794_;
    }

    public boolean m_6060_() {
        return false;
    }

    public boolean m_6783_(double distance) {
        return distance < 16384.0;
    }

    public float m_213856_() {
        return 1.0F;
    }

    protected void m_5790_(EntityHitResult result) {
        Entity target = result.m_82443_();
        Entity owner = m_19749_();
        if (!target.equals(owner)) {
            if (target instanceof Projectile projectile && owner != null) {
                if (owner.equals(projectile.m_19749_())) {
                    return;
                }
            }
            super.m_5790_(result);
        }
    }

    protected void m_8060_(BlockHitResult result) {
        super.m_8060_(result);
    }

    private void destroy() {
        this.m_146870_();
        this.m_9236_().m_214171_(GameEvent.f_223706_, this.m_20182_(), GameEvent.Context.m_223717_(this));
    }

    protected void m_6532_(HitResult result) {
        super.m_6532_(result);
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (!this.m_9236_().f_46443_) {
            ((ServerLevel) this.m_9236_()).m_8767_(ParticleTypes.f_123797_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 15, 0.2, 0.2, 0.2, 0.0);
            this.destroy();
        }
        return true;
    }

    public void m_141965_(ClientboundAddEntityPacket packet) {
        super.m_141965_(packet);
        double d = packet.m_131503_();
        double e = packet.m_131504_();
        double f = packet.m_131505_();
        this.m_20334_(d, e, f);
    }
}
