package me.rufia.fightorflight.goals;

import com.cobblemon.mod.common.entity.pokeball.EmptyPokeBallEntity;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.TargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameRules;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;

public class CaughtByTargetGoal extends TargetGoal {
    private static final TargetingConditions HURT_BY_TARGETING = TargetingConditions.m_148352_().m_148355_().m_26893_();
    private static final int ALERT_RANGE_Y = 10;
    private LivingEntity lastCaughtByMob;
    private int lastCaughtByMobTimestamp;

    public CaughtByTargetGoal(Mob mob) {
        super(mob, true);
        this.m_7021_(EnumSet.of(Goal.Flag.TARGET));
    }

    public boolean m_8036_() {
        PokemonEntity pokemonEntity = (PokemonEntity)this.f_26135_;
        List<Object> busyLocks = pokemonEntity.getBusyLocks();
        for (int i = 0; i < busyLocks.size(); i++){
            if (busyLocks.get(i) instanceof EmptyPokeBallEntity){
//                LogUtils.getLogger().info("Pokemon in process of being caught");
                EmptyPokeBallEntity pokeBallEntity = (EmptyPokeBallEntity)busyLocks.get(i);

                if (pokeBallEntity.m_19749_() instanceof LivingEntity){
                    lastCaughtByMob = (LivingEntity)pokeBallEntity.m_19749_();
                    lastCaughtByMobTimestamp = this.f_26135_.f_19797_;
                }
            }
        }

        if (lastCaughtByMob != null) {
            if (lastCaughtByMob.m_6095_() == EntityType.f_20532_ && this.f_26135_.m_9236_().m_46469_().m_46207_(GameRules.f_46127_)) {
                return false;
            } else {
                return this.m_26150_(lastCaughtByMob, HURT_BY_TARGETING);
            }
        } else {
            return false;
        }
    }

    public void m_8056_() {
        this.f_26135_.m_6710_(lastCaughtByMob);
        this.f_26137_ = this.f_26135_.m_5448_();
        this.f_26135_.m_6703_(this.f_26135_.m_5448_());
        if (this.f_26135_.m_5448_() instanceof Player){
            this.f_26135_.m_6598_((Player)this.f_26135_.m_5448_());
        }
//        this.timestamp = this.mob.getLastHurtByMobTimestamp();
        this.f_26138_ = 300;
//        if (this.alertSameType) {
//            this.alertOthers();
//        }

        super.m_8056_();
    }
}
