package me.rufia.fightorflight.goals;

import com.cobblemon.mod.common.api.moves.Move;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.mojang.logging.LogUtils;
import me.rufia.fightorflight.CobblemonFightOrFlight;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

import java.util.List;

public class PokemonAvoidGoal extends Goal {
    protected final PathfinderMob mob;
    private final double walkSpeedModifier;
    private final double sprintSpeedModifier;
    @Nullable
    protected LivingEntity toAvoid;
    protected final float maxDist;
    @Nullable
    protected Path path;
    protected final PathNavigation pathNav;
    private final TargetingConditions avoidEntityTargeting;

    public PokemonAvoidGoal(PathfinderMob mob, float maxDist, float walkSpeedModifier, float sprintSpeedModifier) {
        this.mob = mob;
        this.maxDist = maxDist;
        this.walkSpeedModifier = walkSpeedModifier;
        this.sprintSpeedModifier = sprintSpeedModifier;
        this.pathNav = this.mob.m_21573_();
        this.avoidEntityTargeting = TargetingConditions.m_148352_().m_26883_((double) maxDist);

    }

    public boolean m_8036_() {
        PokemonEntity pokemonEntity = (PokemonEntity) this.mob;
        if (pokemonEntity.getPokemon().isPlayerOwned()) {
            return false;
        }
        if (pokemonEntity.isBusy()) {
            return false;
        }
        String species = pokemonEntity.getPokemon().getSpecies().getName().toLowerCase();

        if (CobblemonFightOrFlight.SpeciesAlwaysFlee(species)) {
            //These pokemon won't run away from creative mode player,I thought I had to switch it on manually so I spent an hour debugging...
            this.toAvoid = this.mob.m_9236_().m_45982_(this.mob.m_9236_().m_6443_(Player.class, this.mob.m_20191_().m_82377_((double) this.maxDist, 3.0, (double) this.maxDist), (livingEntity) -> {
                return true;
            }), this.avoidEntityTargeting, this.mob, this.mob.m_20185_(), this.mob.m_20186_(), this.mob.m_20189_());
        } else {
            if (this.mob.m_5448_() != null) {
                if (CobblemonFightOrFlight.getFightOrFlightCoefficient(pokemonEntity) > 0) {
                    return false;
                }

                if (this.mob.m_5448_().m_20280_(this.mob) < maxDist) {
                    toAvoid = this.mob.m_5448_();
                }
            }
        }


        if (this.toAvoid == null) {
            return false;
        } else {
            Vec3 vec3 = DefaultRandomPos.m_148407_(this.mob, 16, 7, this.toAvoid.m_20182_());
            if (vec3 == null) {
                return false;
            } else if (this.toAvoid.m_20275_(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_) < this.toAvoid.m_20280_(this.mob)) {

                return false;
            } else {
                this.path = this.pathNav.m_26524_(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, 0);
                return this.path != null;
            }
        }
    }


    public boolean m_8045_() {
        return !this.pathNav.m_26571_();
    }

    public void m_8056_() {
        PokemonEntity pokemonEntity = (PokemonEntity) this.mob;
        boolean has_teleport = false;
        List<Move> moves = pokemonEntity.getPokemon().getMoveSet().getMoves();
        for (Move move : moves) {
            if (move.getName().equals("teleport")) {
                has_teleport = true;
                LogUtils.getLogger().info("This pokemon got teleport to avoid you");
                break;
            }
        }

        if (CobblemonFightOrFlight.commonConfig().allow_teleport_to_flee && has_teleport) {
            for (int i = 0; i < 5; ++i) {
                this.mob.m_9236_().m_7106_(ParticleTypes.f_123760_, this.mob.m_20208_(0.5), this.mob.m_20187_(), this.mob.m_20262_(0.5), 0.0, 0.0, 0.0);
            }
            this.mob.m_6021_(this.path.m_77395_().f_77271_, this.path.m_77395_().f_77272_ + 0.2, this.path.m_77395_().f_77273_);
            this.path = null;
        } else {
            this.pathNav.m_26536_(this.path, this.walkSpeedModifier);
        }
    }

    public void m_8041_() {
        this.toAvoid = null;
    }

    public void m_8037_() {
        PokemonEntity pokemonEntity = (PokemonEntity) this.mob;
//        LogUtils.getLogger().info(pokemonEntity.getPokemon().getSpecies().getName() + " is running away " + this.mob.distanceToSqr(this.toAvoid) + " distanceSqr from here");

        if (this.mob.m_20280_(this.toAvoid) < (maxDist * 0.5)) {
            this.mob.m_21573_().m_26517_(this.sprintSpeedModifier);
        } else {
            this.mob.m_21573_().m_26517_(this.walkSpeedModifier);
        }

    }
}