package me.rufia.fightorflight.goals;

import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import me.rufia.fightorflight.PokemonInterface;
import me.rufia.fightorflight.utils.PokemonUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.ai.goal.Goal;

public class PokemonGoToPosGoal extends Goal {
    private final PokemonEntity pokemonEntity;
    private final double speedModifier;
    private boolean stuck;

    public PokemonGoToPosGoal(PokemonEntity entity, double speedModifier) {
        pokemonEntity = entity;
        this.speedModifier = speedModifier;

    }

    protected boolean moveCommand() {
        return PokemonUtils.moveCommandAvailable(pokemonEntity)
                || PokemonUtils.moveAttackCommandAvailable(pokemonEntity);
    }

    protected boolean stayCommand() {
        return PokemonUtils.stayCommandAvailable(pokemonEntity);
    }

    @Override
    public boolean m_8036_() {
        return moveCommand() && !isCloseEnough() || stayCommand();
    }

    @Override
    public boolean m_8045_() {
        return moveCommand() && !isCloseEnough() || stayCommand();
    }

    public void m_8056_() {
        stuck = false;
    }

    public void m_8037_() {
        if (moveCommand()) {
            approach();
        } else if (stayCommand()) {
            if (!isCloseEnough()) {
                approach();
            }
        }
    }

    public void m_8041_() {
        PokemonUtils.finishMoving(pokemonEntity);
    }

    protected void approach() {
        PokemonUtils.pokemonEntityApproachPos(pokemonEntity, getBlockPos(), speedModifier);
    }

    protected BlockPos getBlockPos() {
        return ((PokemonInterface) (Object) pokemonEntity).getTargetBlockPos();
    }

    protected boolean isCloseEnough() {
        return getBlockPos().m_203195_(pokemonEntity.m_20182_(), 4);
    }
}
