package me.rufia.fightorflight.goals;

import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import me.rufia.fightorflight.CobblemonFightOrFlight;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;


public class PokemonNearestAttackableTargetGoal<T extends LivingEntity> extends NearestAttackableTargetGoal<T> {
    public int ticksUntilNewAngerParticle = 0;
    public float safeDistanceSqr = 36;

    public PokemonNearestAttackableTargetGoal(Mob mob, Class<T> targetType, float safeDistanceSqr, boolean mustSee, boolean mustReach) {
        super(mob, targetType, mustSee, mustReach);
        this.safeDistanceSqr = safeDistanceSqr;
    }

    public boolean m_8036_() {
        if (!CobblemonFightOrFlight.commonConfig().do_pokemon_attack_unprovoked) {
            return false;
        }

        PokemonEntity pokemonEntity = (PokemonEntity) this.f_26135_;

        if (pokemonEntity.getPokemon().getLevel() < CobblemonFightOrFlight.commonConfig().minimum_attack_unprovoked_level) {
            return false;
        }

        if (pokemonEntity.getPokemon().isPlayerOwned()) {
            return false;
        }
        if (CobblemonFightOrFlight.getFightOrFlightCoefficient(pokemonEntity) <= CobblemonFightOrFlight.AUTO_AGGRO_THRESHOLD) {
            return false;
        } else {
            if (ticksUntilNewAngerParticle < 1) {
                CobblemonFightOrFlight.PokemonEmoteAngry(this.f_26135_);
                ticksUntilNewAngerParticle = 25;
            } else {
                ticksUntilNewAngerParticle = ticksUntilNewAngerParticle - 1;
            }
        }

        return super.m_8036_();
    }

    protected void m_26073_() {
        super.m_26073_();
        if (this.f_26050_ != null && this.f_26050_.m_20280_(this.f_26135_) > safeDistanceSqr) {
            this.f_26050_ = null;
        }
    }
}
