package me.rufia.fightorflight.goals;

import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import me.rufia.fightorflight.CobblemonFightOrFlight;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.TargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;

import java.util.EnumSet;

public class PokemonOwnerHurtByTargetGoal extends TargetGoal {
    private final PokemonEntity pokemonEntity;
    private LivingEntity ownerLastHurtBy;
    private int timestamp;

    public PokemonOwnerHurtByTargetGoal(PokemonEntity pokemonEntity) {
        super(pokemonEntity, false);
        this.pokemonEntity = pokemonEntity;
        this.m_7021_(EnumSet.of(Goal.Flag.TARGET));
    }

    public boolean m_8036_() {
        if (!CobblemonFightOrFlight.commonConfig().do_pokemon_defend_owner) { return false; }

        LivingEntity owner = this.pokemonEntity.m_269323_();

        if (owner != null && !this.pokemonEntity.isBusy()) {
            this.ownerLastHurtBy = owner.m_21188_();
            int i = owner.m_21213_();
            return i != this.timestamp &&
                    this.m_26150_(this.ownerLastHurtBy, TargetingConditions.f_26872_) && this.pokemonEntity.m_7757_(this.ownerLastHurtBy, owner);
        } else {
            return false;
        }
    }

    public void m_8056_() {
        this.f_26135_.m_6710_(this.ownerLastHurtBy);
        LivingEntity owner = this.pokemonEntity.m_269323_();
        if (owner != null) {
            this.timestamp = owner.m_21213_();
        }

        super.m_8056_();
    }
}
