package me.rufia.fightorflight.goals;

import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import me.rufia.fightorflight.CobblemonFightOrFlight;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.TargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;

import java.util.EnumSet;

public class PokemonOwnerHurtTargetGoal extends TargetGoal {
    private final PokemonEntity pokemonEntity;
    private LivingEntity ownerLastHurt;
    private int timestamp;

    public PokemonOwnerHurtTargetGoal(PokemonEntity pokemonEntity) {
        super(pokemonEntity, false);
        this.pokemonEntity = pokemonEntity;
        this.m_7021_(EnumSet.of(Goal.Flag.TARGET));
    }

    public boolean m_8036_() {
        if (!CobblemonFightOrFlight.commonConfig().do_pokemon_defend_owner) { return false; }

        LivingEntity owner = this.pokemonEntity.m_269323_();
//        if (owner != null) {
//            LogUtils.getLogger().info(pokemonEntity.getPokemon().getSpecies().getName() + " owner: " + this.pokemonEntity.getPokemon().getOwnerPlayer());
//        }

        if (owner != null && !this.pokemonEntity.isBusy()) {
            this.ownerLastHurt = owner.m_21214_();
            int i = owner.m_21215_();
            return i != this.timestamp
                    && this.m_26150_(this.ownerLastHurt, TargetingConditions.f_26872_) && this.pokemonEntity.m_7757_(this.ownerLastHurt, owner);
        } else {
            return false;
        }
    }

    public void m_8056_() {
        this.f_26135_.m_6710_(this.ownerLastHurt);
        LivingEntity owner = this.pokemonEntity.m_269323_();
        if (owner != null) {
            this.timestamp = owner.m_21215_();
        }

        super.m_8056_();
    }
}