package me.rufia.fightorflight.goals;

import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import me.rufia.fightorflight.CobblemonFightOrFlight;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import org.jetbrains.annotations.Nullable;

import java.util.function.Predicate;

public class PokemonProactiveTargetGoal<T extends LivingEntity> extends NearestAttackableTargetGoal<T> {

    public float safeDistanceSqr = 36;
    //public PokemonProactiveTargetGoal(Mob mob, Class<T> targetType, float safeDistanceSqr, boolean mustSee, boolean mustReach) {
    //    super(mob, targetType, mustSee, mustReach);
    //    this.safeDistanceSqr = safeDistanceSqr;
    //}

    public PokemonProactiveTargetGoal(Mob mob, Class<T> targetType, int randomInterval, boolean mustSee, boolean mustReach, @Nullable Predicate<LivingEntity> targetPredicate) {
        super(mob, targetType, randomInterval, mustSee, mustReach, targetPredicate);
        this.safeDistanceSqr = safeDistanceSqr;
    }

    public boolean m_8036_() {
        if (!CobblemonFightOrFlight.commonConfig().do_pokemon_defend_proactive) { return false; }
        PokemonEntity pokemonEntity = (PokemonEntity)this.f_26135_;
        if (!pokemonEntity.getPokemon().isPlayerOwned()) { return false; }

        return super.m_8036_();
    }

    protected void m_26073_() {
        super.m_26073_();
        if (this.f_26050_ != null && this.f_26050_.m_20280_(this.f_26135_) > safeDistanceSqr) {
            this.f_26050_ = null;
        }
    }
}
