package me.rufia.fightorflight.goals;

import com.cobblemon.mod.common.api.moves.Move;
import com.cobblemon.mod.common.battles.BattleRegistry;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import me.rufia.fightorflight.CobblemonFightOrFlight;
import me.rufia.fightorflight.PokemonInterface;
import me.rufia.fightorflight.entity.PokemonAttackEffect;
import me.rufia.fightorflight.entity.projectile.AbstractPokemonProjectile;
import me.rufia.fightorflight.entity.projectile.PokemonArrow;
import me.rufia.fightorflight.entity.projectile.PokemonBullet;
import me.rufia.fightorflight.entity.projectile.PokemonTracingBullet;
import me.rufia.fightorflight.utils.PokemonUtils;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.Random;

public class PokemonRangedAttackGoal extends PokemonAttackGoal{
    public int ticksUntilNewAngerParticle = 0;

    public int ticksUntilNewAngerCry = 0;
    private final PokemonEntity pokemonEntity;
    private final LivingEntity livingEntity;
    @Nullable
    private LivingEntity target;
    //private int attackTime;
    private final double speedModifier;
    private int seeTime;

    private boolean strafingClockwise;
    private boolean strafingBackwards;
    private int strafingTime = -1;

    private final float attackRadius;
    private final float attackRadiusSqr;

    public PokemonRangedAttackGoal(LivingEntity pokemonEntity, double speedModifier, float attackRadius) {
        setAttackTime(-1);
        this.livingEntity = pokemonEntity;
        if (!(pokemonEntity instanceof PokemonEntity)) {
            throw new IllegalArgumentException("PokemonRangedAttackGoal requires a PokemonEntity");
        } else {
            this.pokemonEntity = (PokemonEntity) pokemonEntity;
            this.speedModifier = speedModifier;

            this.attackRadius = attackRadius;
            this.attackRadiusSqr = attackRadius * attackRadius;

            this.m_7021_(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE));
        }
    }

    public boolean m_8036_() {
        if (!PokemonUtils.shouldShoot(pokemonEntity) || PokemonUtils.moveCommandAvailable(pokemonEntity)) {
            return false;
        }

        LivingEntity livingEntity = this.pokemonEntity.m_5448_();
        if (livingEntity != null && livingEntity.m_6084_()) {
            this.target = livingEntity;
            return PokemonUtils.shouldFightTarget(pokemonEntity);
        } else {
            return false;
        }
    }

    public boolean m_8045_() {
        return this.m_8036_() || this.target.m_6084_() && !this.pokemonEntity.m_21573_().m_26571_();
    }

    public void m_8041_() {
        this.target = null;
        this.seeTime = 0;
        setAttackTime(-1);
    }

    public boolean m_183429_() {
        return true;
    }

    public boolean isTargetInBattle() {
        if (this.pokemonEntity.m_5448_() instanceof ServerPlayer targetAsPlayer) {
            return BattleRegistry.INSTANCE.getBattleByParticipatingPlayer(targetAsPlayer) != null;
        }
        return false;
    }

    public void m_8037_() {
        if (!CobblemonFightOrFlight.commonConfig().do_pokemon_attack_in_battle) {
            if (isTargetInBattle()) {
                this.pokemonEntity.m_21573_().m_26517_(0);
            }
        }

        if (pokemonEntity.m_269323_() == null) {
            if (ticksUntilNewAngerParticle < 1) {
                CobblemonFightOrFlight.PokemonEmoteAngry((Mob) this.livingEntity);
                ticksUntilNewAngerParticle = 10;
            } else {
                ticksUntilNewAngerParticle = ticksUntilNewAngerParticle - 1;
            }

            if (ticksUntilNewAngerCry < 1) {
                pokemonEntity.cry();
                ticksUntilNewAngerCry = 100 + (int) (Math.random() * 200);
            } else {
                ticksUntilNewAngerCry = ticksUntilNewAngerCry - 1;
            }
        }
        if (target != null) {
            double d = this.pokemonEntity.m_20275_(this.target.m_20185_(), this.target.m_20186_(), this.target.m_20189_());
            boolean bl = this.pokemonEntity.m_21574_().m_148306_(this.target);
            if (bl) {
                ++this.seeTime;
            } else {
                seeTime = 0;
                resetAttackTime(d);
            }
            if (!(d > (double) this.attackRadiusSqr) && this.seeTime >= 5 && bl) {
                this.pokemonEntity.m_21573_().m_26573_();
                ++strafingTime;
            } else {
                this.pokemonEntity.m_21573_().m_5624_(this.target, this.speedModifier);
                strafingTime = -1;
            }
            if (this.strafingTime >= 10) {
                if ((double) this.pokemonEntity.m_217043_().m_188501_() < 0.3) {
                    this.strafingClockwise = !this.strafingClockwise;
                }
                if ((double) this.pokemonEntity.m_217043_().m_188501_() < 0.3) {
                    this.strafingBackwards = !this.strafingBackwards;
                }
                this.strafingTime = 0;
            }
            if (this.strafingTime > -1) {
                if (d > (double) (this.attackRadiusSqr * 0.8F)) {
                    this.strafingBackwards = false;
                } else if (d < (double) (this.attackRadiusSqr * 0.2F)) {
                    this.strafingBackwards = true;
                }
                this.pokemonEntity.m_21566_().m_24988_(this.strafingBackwards ? -0.5F : 0.5F, this.strafingClockwise ? 0.5F : -0.5F);
                Entity vehicle = this.pokemonEntity.m_275832_();
                if (vehicle instanceof Mob mob) {
                    mob.m_21391_(livingEntity, 30.0F, 30.0F);
                }
            }
            this.pokemonEntity.m_21563_().m_148051_(this.target);
            ((PokemonInterface) (Object) pokemonEntity).setAttackTime(((PokemonInterface) (Object) pokemonEntity).getAttackTime() - 1);
            if (getAttackTime() == 7 && (((PokemonInterface) pokemonEntity).usingSound())) {
                PokemonUtils.createSonicBoomParticle(pokemonEntity, target);
            }
            if (getAttackTime() % 5 == 0 && (((PokemonInterface) pokemonEntity).usingMagic())) {
                PokemonAttackEffect.makeMagicAttackParticle(pokemonEntity, target);
            }
            if (getAttackTime() == 0) {
                if (!bl) {
                    return;
                }
                resetAttackTime(d);
                this.performRangedAttack(this.target);
            } else if (getAttackTime() < 0) {
                resetAttackTime(d);
            }
        }
    }

    @Override
    protected PokemonEntity getPokemonEntity(){
        return pokemonEntity;
    }

    protected void performRangedAttack(LivingEntity target) {
        PokemonAttackEffect.pokemonPerformRangedAttack(pokemonEntity, target);
    }
}
