package me.rufia.fightorflight.goals;

import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import me.rufia.fightorflight.CobblemonFightOrFlight;
import me.rufia.fightorflight.utils.PokemonUtils;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.phys.AABB;

public class PokemonTauntedTargetGoal<T extends LivingEntity> extends NearestAttackableTargetGoal<T> {
    protected PokemonEntity pokemonEntity;
    protected PokemonEntity targetPokemon;
    protected float safeDistanceSqr = CobblemonFightOrFlight.moveConfig().status_move_radius;

    public PokemonTauntedTargetGoal(Mob mob, Class<T> targetType, boolean mustSee) {
        super(mob, targetType, 10, mustSee, false, (entity) -> {
            if (entity instanceof TamableAnimal tamable) {
                return tamable.m_269323_() != null || CobblemonFightOrFlight.moveConfig().wild_pokemon_taunt;
            }
            return false;
        });
        pokemonEntity = (PokemonEntity) mob;
    }

    public boolean isTaunted() {
        if (pokemonEntity.m_269323_() != null) {
            return false;
        }
        for (PokemonEntity pokemonEntity1 : pokemonEntity.m_9236_().m_6443_(PokemonEntity.class, AABB.m_165882_(pokemonEntity.m_20182_(), safeDistanceSqr, safeDistanceSqr, safeDistanceSqr), (entity) -> entity.m_269323_() != null || CobblemonFightOrFlight.moveConfig().wild_pokemon_taunt)) {
            if (PokemonUtils.canTaunt(pokemonEntity1)) {
                targetPokemon = pokemonEntity1;
                return true;
            }
        }
        targetPokemon = null;
        return false;
    }

    public boolean m_8036_() {
        if (isTaunted()) {
            f_26050_ = targetPokemon;
            return true;
        }
        return false;
    }
}
