package me.rufia.fightorflight.item;

import com.cobblemon.mod.common.CobblemonItems;
import com.cobblemon.mod.common.api.moves.Move;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import me.rufia.fightorflight.CobblemonFightOrFlight;
import me.rufia.fightorflight.PokemonInterface;
import me.rufia.fightorflight.utils.RayTrace;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PokeStaff extends Item {
    enum MODE {
        SEND, SETMOVE, SETCMDMODE
    }

    public enum CMDMODE {
        MOVE_ATTACK, MOVE, STAY, ATTACK, ATTACK_POSITION, NOCMD, CLEAR
    }

    public PokeStaff(Item.Properties properties) {
        super(properties);
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
        CompoundTag tag = stack.m_41784_();

        if (tag.m_128441_("command")) {
            String modeTag = tag.m_128469_("command").m_128461_("mode");
            if (!modeTag.isEmpty()) {
                int d = getMoveSlot(stack);
                String cmdMode = getCommandMode(stack);
                Component component;
                switch (MODE.valueOf(modeTag)) {
                    case SEND -> component = Component.m_237115_("item.fightorflight.pokestaff.mode.send");
                    case SETMOVE ->
                            component = Component.m_237115_("item.fightorflight.pokestaff.mode.selectmoveslot");
                    case SETCMDMODE ->
                            component = Component.m_237115_("item.fightorflight.pokestaff.mode.selectcommand");
                    default -> component = Component.m_237113_("");
                }

                tooltipComponents.add(Component.m_237115_("item.fightorflight.pokestaff.desc1").m_7220_(component));
                tooltipComponents.add(Component.m_237110_("item.fightorflight.pokestaff.desc2", d + 1));
                tooltipComponents.add(Component.m_237110_("item.fightorflight.pokestaff.desc3", getTranslatedCmdModeName(cmdMode).getString()));
            }
        }
    }

    @Override
    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand usedHand) {
        ItemStack stack = player.m_21120_(usedHand);

        CompoundTag tag = stack.m_41784_();
        initTag(stack);

        if (player.m_36341_()) {
            //CobblemonFightOrFlight.LOGGER.info("SNEAKING");
            CompoundTag tag2 = tag.m_128469_("command");
            switch (MODE.valueOf(tag2.m_128461_("mode"))) {
                case SETMOVE -> {
                    tag2.m_128359_("mode", MODE.SETCMDMODE.name());
                    if (player.m_9236_().f_46443_) {
                        player.m_213846_(Component.m_237115_("item.fightorflight.pokestaff.mode.selectcommand"));
                    }
                    //CobblemonFightOrFlight.LOGGER.info("sending");
                }
                case SEND -> {
                    tag2.m_128359_("mode", MODE.SETMOVE.name());
                    if (player.m_9236_().f_46443_) {
                        player.m_213846_(Component.m_237115_("item.fightorflight.pokestaff.mode.selectmoveslot"));
                    }
                    //CobblemonFightOrFlight.LOGGER.info("SETTING Moves");
                }
                case SETCMDMODE -> {
                    tag2.m_128359_("mode", MODE.SEND.name());
                    if (player.m_9236_().f_46443_) {
                        player.m_213846_(Component.m_237115_("item.fightorflight.pokestaff.mode.send"));
                    }
                }
            }
            return InteractionResultHolder.m_19090_(player.m_21120_(usedHand));
        }

        String mode = getMode(stack);
        if (MODE.valueOf(tag.m_128469_("command").m_128461_("mode")) == MODE.SETMOVE) {
            //CobblemonFightOrFlight.LOGGER.info("SELECTING MOVES");
            int nextMoveSlot = getMoveSlot(stack) + 1;
            setMoveSlot(stack, nextMoveSlot, player);
            setCommandMode(stack, CMDMODE.NOCMD.name());
            if (player.m_9236_().f_46443_) {
                player.m_213846_(Component.m_237110_("item.fightorflight.pokestaff.desc2", nextMoveSlot % 4 + 1));
            }
        }
        if (MODE.valueOf(tag.m_128469_("command").m_128461_("mode")) == MODE.SETCMDMODE) {
            commandModeSelectNext(stack, getCommandMode(stack));
            setMoveSlot(stack, -1, player);
            if (player.m_9236_().f_46443_) {
                player.m_213846_(getTranslatedCmdModeName(getCommandMode(stack)));
            }
        }

        if (mode.equals(MODE.SEND.name())) {
            //CobblemonFightOrFlight.LOGGER.info("SENDING COMMAND");
            CMDMODE cmdmode = CMDMODE.valueOf(getCommandMode(stack));
            String cmdData = "";

            switch (cmdmode) {
                case MOVE, ATTACK_POSITION, MOVE_ATTACK, STAY -> {
                    BlockHitResult result = RayTrace.rayTraceBlock(player, 16);
                    BlockPos blockPos = result.m_82425_();
                    //CobblemonFightOrFlight.LOGGER.info("VEC3_%s_%s_%s".formatted(blockPos.getX(), blockPos.getY(), blockPos.getZ()));
                    cmdData = "VEC3i_%s_%s_%s".formatted(blockPos.m_123341_(), blockPos.m_123342_(), blockPos.m_123343_());
                }
                case ATTACK -> {
                    LivingEntity livingEntity = RayTrace.rayTraceEntity(player, 16);
                    if (livingEntity != null) {
                        cmdData = "ENTITY_%s".formatted(livingEntity.m_20149_());

                        //CobblemonFightOrFlight.LOGGER.info("ENTITY_%s".formatted(livingEntity.getStringUUID()));
                    }
                }
                default -> cmdData = "";
            }
            if (!Objects.equals(getCommandMode(stack), CMDMODE.NOCMD.name())) {
                for (PokemonEntity pokemonEntity : player.m_9236_().m_6443_(PokemonEntity.class, AABB.m_165882_(player.m_20182_(), 8, 8, 8), (pokemonEntity -> Objects.equals(pokemonEntity.m_269323_(), player)))) {
                    ((PokemonInterface) (Object) pokemonEntity).setCommand(getCommandMode(stack));
                    ((PokemonInterface) (Object) pokemonEntity).setCommandData(cmdData);
                    if (player.m_9236_().f_46443_) {
                        player.m_213846_(Component.m_237110_("item.fightorflight.pokestaff.recv.command", pokemonEntity.m_7755_().getString(), cmdmode.name()));
                    }
                }
            }

        }
        return InteractionResultHolder.m_19090_(player.m_21120_(usedHand));
    }

    @Override
    public void m_6883_(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        initTag(stack);
        super.m_6883_(stack, level, entity, slotId, isSelected);
    }

    public boolean canSend(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        if (!(tag.m_128441_("command") && stack.m_150930_(ItemFightOrFlight.POKESTAFF.get()))) {
            return false;
        }
        return Objects.equals(tag.m_128469_("command").m_128461_("mode"), MODE.SEND.name());
    }

    public void sendMoveSlot(Player player, LivingEntity livingEntity, ItemStack itemStack) {
        if (!livingEntity.m_9236_().f_46443_ && livingEntity instanceof PokemonEntity pokemonEntity) {
            if (pokemonEntity.m_269323_() == player) {
                ItemStack heldItem = pokemonEntity.getPokemon().heldItem();
                if (heldItem.m_150930_(CobblemonItems.CHOICE_SCARF) || heldItem.m_150930_(CobblemonItems.CHOICE_BAND) || heldItem.m_150930_(CobblemonItems.CHOICE_SPECS)) {
                    return;
                }
                CompoundTag tag = itemStack.m_41784_();
                if (tag.m_128441_("command") && itemStack.m_150930_(ItemFightOrFlight.POKESTAFF.get())) {
                    int moveSlot = getMoveSlot(itemStack);
                    String cmdMode = getCommandMode(itemStack);
                    if (moveSlot != -1) {
                        Move move = pokemonEntity.getPokemon().getMoveSet().get(moveSlot);
                        if (move == null) {
                            move = pokemonEntity.getPokemon().getMoveSet().get(0);
                        }
                        ((PokemonInterface) (Object) pokemonEntity).setCurrentMove(move);
                        player.m_213846_(Component.m_237115_("item.fightorflight.pokestaff.send.result.move").m_7220_(move.getDisplayName()));
                        //CobblemonFightOrFlight.LOGGER.info(moveSlot + pokemonEntity.getPokemon().getMoveSet().get(moveSlot).getName());
                    }

                    ((PokemonInterface) (Object) pokemonEntity).setCommand(cmdMode);
                }
            }
        }
    }

    private void initTag(ItemStack itemStack) {
        CompoundTag tag = itemStack.m_41784_();
        if (!tag.m_128441_("command")) {
            CompoundTag tag2 = itemStack.m_41698_("command");
            tag2.m_128359_("mode", MODE.SETMOVE.name());
            tag2.m_128405_("move_slot", 0);
            tag2.m_128359_("command_mode", CMDMODE.NOCMD.name());
            tag.m_128365_("commnad", tag2);
        }
    }

    protected String getMode(ItemStack itemStack) {
        CompoundTag tag = itemStack.m_41784_();
        if (itemStack.m_150930_(ItemFightOrFlight.POKESTAFF.get())) {
            if (tag.m_128441_("command")) {
                return tag.m_128469_("command").m_128461_("mode");
            }
        }
        return "";
    }

    public int getMoveSlot(ItemStack itemStack) {
        CompoundTag tag = itemStack.m_41784_();
        if (itemStack.m_150930_(ItemFightOrFlight.POKESTAFF.get())) {
            if (tag.m_128441_("command")) {
                return tag.m_128469_("command").m_128451_("move_slot");
            }
        }
        return -1;
    }

    public String getCommandMode(ItemStack itemStack) {
        CompoundTag tag = itemStack.m_41784_();
        if (itemStack.m_150930_(ItemFightOrFlight.POKESTAFF.get())) {
            if (tag.m_128441_("command")) {
                return tag.m_128469_("command").m_128461_("command_mode");
            }
        }
        return CMDMODE.NOCMD.name();
    }

    @Override
    public boolean m_41463_(ItemStack stack) {
        return true;
    }

    protected void setMoveSlot(ItemStack stack, int moveSlot, Player player) {
        stack.m_41784_().m_128469_("command").m_128405_("move_slot", moveSlot % 4);
    }

    protected void setCommandMode(ItemStack stack, String mode) {
        stack.m_41784_().m_128469_("command").m_128359_("command_mode", mode);
    }

    protected void commandModeSelectNext(ItemStack stack, String mode) {
        String cmd;
        switch (CMDMODE.valueOf(mode)) {
            case MOVE_ATTACK -> cmd = CMDMODE.MOVE.name();
            case MOVE -> cmd = CMDMODE.STAY.name();
            case STAY -> cmd = CMDMODE.ATTACK.name();
            case ATTACK -> cmd = CMDMODE.ATTACK_POSITION.name();
            case ATTACK_POSITION -> cmd = CMDMODE.NOCMD.name();
            case NOCMD -> cmd = CMDMODE.CLEAR.name();
            case CLEAR -> cmd = CMDMODE.MOVE_ATTACK.name();
            default -> cmd = CMDMODE.NOCMD.name();
        }
        setCommandMode(stack, cmd);
    }

    protected Component getTranslatedCmdModeName(String cmdModeName) {
        Component component;
        switch (CMDMODE.valueOf(cmdModeName)) {
            case MOVE_ATTACK -> component = Component.m_237115_("item.fightorflight.pokestaff.command.move_attack");
            case MOVE -> component = Component.m_237115_("item.fightorflight.pokestaff.command.move");
            case STAY -> component = Component.m_237115_("item.fightorflight.pokestaff.command.stay");
            case ATTACK -> component = Component.m_237115_("item.fightorflight.pokestaff.command.attack_target");
            case ATTACK_POSITION ->
                    component = Component.m_237115_("item.fightorflight.pokestaff.command.attack_position");
            case CLEAR -> component = Component.m_237115_("item.fightorflight.pokestaff.command.clear_cmd");
            default -> component = Component.m_237115_("item.fightorflight.pokestaff.command.no_cmd");
        }
        return component;
    }

    @Override
    public boolean m_8120_(ItemStack stack) {
        return false;
    }
}
