package me.rufia.fightorflight.mixin;

import com.cobblemon.mod.common.CobblemonNetwork;
import com.cobblemon.mod.common.client.CobblemonClient;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.net.messages.server.BattleChallengePacket;
import com.cobblemon.mod.common.net.messages.server.RequestPlayerInteractionsPacket;
import com.cobblemon.mod.common.pokemon.Pokemon;
import java.util.List;
import me.rufia.fightorflight.CobblemonFightOrFlight;
import me.rufia.fightorflight.client.keybinds.KeybindFightOrFlight;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(Minecraft.class)
public abstract class MinecraftClientInject {
    @Shadow
    public static Minecraft getInstance() {
        return null;
    }

    @Shadow
    @Nullable
    public LocalPlayer player;

    @Inject(method = "tick", at = @At("TAIL"))
    private void postTick(CallbackInfo ci) {
        if (KeybindFightOrFlight.START_BATTLE.m_90857_()) {
            startBattle();
        }
    }

    private void startBattle() {
        var player = getInstance().f_91074_;
        boolean isSpectator=player.m_5833_();
        boolean playerIsAvailable=CobblemonClient.INSTANCE.getBattle() != null;
        boolean otherConditions=!(CobblemonClient.INSTANCE.getStorage().getSelectedSlot() != -1 && getInstance().f_91080_ == null);
        if (isSpectator||playerIsAvailable||otherConditions) {
            return;
        }

        var pokemon = CobblemonClient.INSTANCE.getStorage().getMyParty().get(CobblemonClient.INSTANCE.getStorage().getSelectedSlot());
        if (pokemon != null && pokemon.getHp() > 0) {
            var entities = player.f_108545_.m_6443_(PokemonEntity.class, AABB.m_165882_(player.m_20318_(player.f_19797_), 20, 20, 20),
                    (pokemonEntity) -> pokemonEntity.m_5448_() == player
            );
            for (PokemonEntity pokemonEntity : entities) {
                if (pokemonEntity.m_269323_() == null && pokemonEntity.canBattle(player)) {
                    CobblemonNetwork.INSTANCE.sendPacketToServer(new BattleChallengePacket(pokemonEntity.m_19879_(), pokemon.getUuid()));
                    break;
                } else if (pokemonEntity.m_269323_() != player) {
                    if (pokemonEntity.m_269323_() instanceof Player player1) {
                        CobblemonNetwork.INSTANCE.sendPacketToServer(new RequestPlayerInteractionsPacket(pokemonEntity.m_20148_(), pokemonEntity.m_19879_(), pokemon.getUuid()));
                        break;
                    }
                } else {
                    CobblemonFightOrFlight.LOGGER.info("Oh gosh,you must be joking");
                }
            }
        }
    }
}
