package me.rufia.fightorflight.mixin;


import com.cobblemon.mod.common.api.moves.Move;
import com.cobblemon.mod.common.api.pokemon.experience.SidemodExperienceSource;
import com.cobblemon.mod.common.api.pokemon.stats.Stat;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.Pokemon;
import me.rufia.fightorflight.CobblemonFightOrFlight;
import me.rufia.fightorflight.PokemonInterface;
import me.rufia.fightorflight.entity.PokemonAttackEffect;
import me.rufia.fightorflight.item.ItemFightOrFlight;
import me.rufia.fightorflight.item.PokeStaff;
import me.rufia.fightorflight.utils.FOFEVCalculator;
import me.rufia.fightorflight.utils.FOFExpCalculator;
import me.rufia.fightorflight.utils.FOFUtils;
import me.rufia.fightorflight.utils.PokemonUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.animal.ShoulderRidingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@Mixin(PokemonEntity.class)
public abstract class PokemonEntityMixin extends Mob implements PokemonInterface {
    @Shadow
    public abstract void cry();

    @Shadow
    public abstract Pokemon getPokemon();

    @Unique
    @Nullable
    private LivingEntity fightorflight$clientSideCachedAttackTarget;
    @Unique
    private static final EntityDataAccessor<Integer> DATA_ID_ATTACK_TARGET;
    @Unique
    private static final EntityDataAccessor<Integer> ATTACK_TIME;
    @Unique
    private static final EntityDataAccessor<String> MOVE;
    @Unique
    private static final EntityDataAccessor<Integer> CRY_CD;
    @Unique
    private static final EntityDataAccessor<String> COMMAND;
    @Unique
    private static final EntityDataAccessor<String> COMMAND_DATA;
    @Unique
    private static final EntityDataAccessor<BlockPos> TARGET_BLOCK_POS;

    static {
        DATA_ID_ATTACK_TARGET = SynchedEntityData.m_135353_(PokemonEntityMixin.class, EntityDataSerializers.f_135028_);
        ATTACK_TIME = SynchedEntityData.m_135353_(PokemonEntityMixin.class, EntityDataSerializers.f_135028_);
        MOVE = SynchedEntityData.m_135353_(PokemonEntityMixin.class, EntityDataSerializers.f_135030_);
        CRY_CD = SynchedEntityData.m_135353_(PokemonEntityMixin.class, EntityDataSerializers.f_135028_);
        COMMAND = SynchedEntityData.m_135353_(PokemonEntityMixin.class, EntityDataSerializers.f_135030_);
        COMMAND_DATA = SynchedEntityData.m_135353_(PokemonEntityMixin.class, EntityDataSerializers.f_135030_);
        TARGET_BLOCK_POS = SynchedEntityData.m_135353_(PokemonEntityMixin.class, EntityDataSerializers.f_135038_);
    }

    protected void createTargetBlockPos() {
        String data = this.getCommandData();
        Vec3i vec3i = FOFUtils.stringToVec3i(data);
        if (vec3i != null) {
            BlockPos blockPos = new BlockPos(vec3i.m_123341_(), vec3i.m_123342_(), vec3i.m_123343_());
            setTargetBlockPos(blockPos);
            return;
        }
        setTargetBlockPos(BlockPos.f_121853_);
    }

    protected PokemonEntityMixin(EntityType<? extends ShoulderRidingEntity> entityType, Level level) {
        super(entityType, level);
    }

    @Override
    public LivingEntity m_5448_() {
        if (this.m_9236_().f_46443_) {
            if (fightorflight$clientSideCachedAttackTarget != null) {
                return fightorflight$clientSideCachedAttackTarget;
            } else {
                Entity entity = this.m_9236_().m_6815_((Integer) this.f_19804_.m_135370_(DATA_ID_ATTACK_TARGET));
                if (entity instanceof LivingEntity) {
                    fightorflight$clientSideCachedAttackTarget = (LivingEntity) entity;
                    return fightorflight$clientSideCachedAttackTarget;
                }
            }
        }
        return super.m_5448_();
    }

    @Inject(method = "onSyncedDataUpdated", at = @At("TAIL"))
    public void onSyncedDataUpdated(EntityDataAccessor<?> key, CallbackInfo ci) {
        if (DATA_ID_ATTACK_TARGET.equals(key)) {
            this.fightorflight$clientSideCachedAttackTarget = null;
        }
    }

    @Inject(method = "defineSynchedData", at = @At("TAIL"))
    protected void defineSynchedData(CallbackInfo info) {
        this.f_19804_.m_135372_(DATA_ID_ATTACK_TARGET, 0);
        this.f_19804_.m_135372_(ATTACK_TIME, 0);
        this.f_19804_.m_135372_(MOVE, "");
        this.f_19804_.m_135372_(CRY_CD, 0);
        this.f_19804_.m_135372_(COMMAND, "");
        this.f_19804_.m_135372_(COMMAND_DATA, "");
        this.f_19804_.m_135372_(TARGET_BLOCK_POS, BlockPos.f_121853_);
    }

    @Inject(method = "saveWithoutId", at = @At("HEAD"))
    private void writeAdditionalNbt(CompoundTag compoundTag, CallbackInfoReturnable<Boolean> ci) {
        compoundTag.m_128405_(CRY_CD.toString(), 0);
        compoundTag.m_128359_(COMMAND.toString(), getCommand());
        compoundTag.m_128359_(COMMAND_DATA.toString(), getCommandData());
    }

    @Inject(method = "load", at = @At("TAIL"))
    private void readAdditionalNbt(CompoundTag compoundTag, CallbackInfo ci) {
        f_19804_.m_135381_(CRY_CD, compoundTag.m_128451_(CRY_CD.toString()));
    }

    public void m_6710_(LivingEntity target) {
        super.m_6710_(target);
        if (target != null) {
            this.f_19804_.m_135381_(DATA_ID_ATTACK_TARGET, target.m_19879_());
        }
    }

    @Override
    public int getAttackTime() {
        return f_19804_.m_135370_(ATTACK_TIME);
    }

    @Override
    public void setAttackTime(int val) {
        f_19804_.m_135381_(ATTACK_TIME, val);
    }

    @Override
    public boolean usingBeam() {
        if (getCurrentMove().isEmpty()) {
            return false;
        }
        return Arrays.stream(CobblemonFightOrFlight.moveConfig().single_beam_moves).toList().contains(getCurrentMove());
    }

    @Override
    public boolean usingSound() {
        if (getCurrentMove().isEmpty()) {
            return false;
        }
        return Arrays.stream(CobblemonFightOrFlight.moveConfig().sound_based_moves).toList().contains(getCurrentMove());
    }

    @Override
    public boolean usingMagic() {
        if (getCurrentMove().isEmpty()) {
            return false;
        }
        return Arrays.stream(CobblemonFightOrFlight.moveConfig().magic_attack_moves).toList().contains(getCurrentMove());
    }

    @Override
    public void setCurrentMove(Move move) {
        f_19804_.m_135381_(MOVE, move.getName());
    }

    @Override
    public String getCurrentMove() {
        return f_19804_.m_135370_(MOVE);
    }

    @Override
    public int getNextCryTime() {
        return this.f_19804_.m_135370_(CRY_CD);
    }

    @Override
    public void setNextCryTime(int time) {
        this.f_19804_.m_135381_(CRY_CD, time);
    }

    @Override
    public void setCommand(String cmd) {
        f_19804_.m_135381_(COMMAND, cmd);
    }

    @Override
    public String getCommand() {
        return f_19804_.m_135370_(COMMAND);
    }

    @Override
    public void setCommandData(String cmdData) {
        f_19804_.m_135381_(COMMAND_DATA, cmdData);
        createTargetBlockPos();
    }

    @Override
    public String getCommandData() {
        return f_19804_.m_135370_(COMMAND_DATA);
    }

    @Override
    public BlockPos getTargetBlockPos() {
        return this.f_19804_.m_135370_(TARGET_BLOCK_POS);
    }

    @Override
    public void setTargetBlockPos(BlockPos blockPos) {
        this.f_19804_.m_135381_(TARGET_BLOCK_POS, blockPos);
    }

    @ModifyVariable(method = "hurt", at = @At("HEAD"), argsOnly = true)
    private float hurtDamageTweak(float amount) {
        if (PokemonUtils.shouldRetreat((PokemonEntity) (Object) this)) {
            PokemonAttackEffect.pokemonRecallWithAnimation((PokemonEntity) (Object) this);
            return 0;
        }
        Pokemon pokemon = getPokemon();
        float def = Math.max(pokemon.getDefence(), pokemon.getSpecialDefence());
        return amount * (1 - Math.min(CobblemonFightOrFlight.commonConfig().max_damage_reduction_multiplier, Mth.m_14179_(def / CobblemonFightOrFlight.commonConfig().defense_stat_limit, 0, CobblemonFightOrFlight.commonConfig().max_damage_reduction_multiplier)));
        //CobblemonFightOrFlight.LOGGER.info(String.format("base dmg:%f,reduced dmg:%f",amount,amount1));
    }

    @Inject(method = "hurt", at = @At("RETURN"))
    private void hurtDamageToPokemon(DamageSource source, float amount, CallbackInfoReturnable<Boolean> cir) {
        if (PokemonUtils.isUsingNewHealthMechanic()) {
            PokemonUtils.entityHpToPokemonHp((PokemonEntity) (Object) this, amount, false);
        }
    }

    @Override
    public void m_5634_(float healAmount) {
        if (PokemonUtils.isUsingNewHealthMechanic()) {
            PokemonUtils.entityHpToPokemonHp((PokemonEntity) (Object) this, healAmount, true);
        }
        super.m_5634_(healAmount);
    }

    @Inject(method = "tick", at = @At("TAIL"))
    private void tick(CallbackInfo ci) {
        if (Objects.equals(getCommand(), PokeStaff.CMDMODE.CLEAR.name())) {
            setCommand(PokeStaff.CMDMODE.NOCMD.name());
        }
        var targetEntity = m_5448_();
        if (targetEntity != null && targetEntity.m_6084_()) {
            if (getNextCryTime() == 0) {
                this.cry();
                if (CobblemonFightOrFlight.commonConfig().multiple_cries) {
                    setNextCryTime(CobblemonFightOrFlight.commonConfig().time_to_cry_again);
                } else {
                    setNextCryTime(-1);
                }
            }
        } else {
            setNextCryTime(0);
        }
        if (getNextCryTime() >= 0) {
            setNextCryTime(getNextCryTime() - 1);
        }
    }

    //Don't use @Override for this function, or you will find that you can't change your pokemon's held item
    @Inject(method = "mobInteract", at = @At("HEAD"), cancellable = true)
    private void mobInteractInject(Player player, InteractionHand hand, CallbackInfoReturnable<InteractionResult> cir) {
        ItemStack itemStack = player.m_21120_(hand);
        if (itemStack.m_150930_(ItemFightOrFlight.POKESTAFF.get())) {
            PokeStaff staff = (PokeStaff) itemStack.m_41720_();
            if (staff.canSend(itemStack)) {
                staff.sendMoveSlot(player, this, itemStack);
                cir.setReturnValue(InteractionResult.SUCCESS);
            }
        }
    }

    @Inject(method = "dropAllDeathLoot", at = @At("TAIL"))
    private void dropAllDeathLootInject(DamageSource source, CallbackInfo ci) {
        if (m_21188_() instanceof PokemonEntity pokemonEntity) {
            if (pokemonEntity.m_269323_() != null) {
                PokemonEntity self = (PokemonEntity) (Object) this;
                pokemonEntity.getPokemon().addExperience(new SidemodExperienceSource(CobblemonFightOrFlight.MODID), FOFExpCalculator.calculate(pokemonEntity.getPokemon(), self.getPokemon()));
                if (CobblemonFightOrFlight.commonConfig().can_gain_ev) {
                    var map = FOFEVCalculator.calculate(pokemonEntity.getPokemon(), self.getPokemon());
                    for (Map.Entry<Stat, Integer> entry : map.entrySet()) {
                        pokemonEntity.getPokemon().getEvs().add(entry.getKey(), entry.getValue());
                    }
                }
            }
        }
    }
}
