package me.rufia.fightorflight.utils;

import F;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public class RayTrace {
    public static LivingEntity rayTraceEntity(LivingEntity viewer, double distance) {
        var level = viewer.m_9236_();
        Vec3 eyePosition = viewer.m_146892_();
        Vec3 viewVector = viewer.m_20252_(1.0f).m_82541_();
        Vec3 extendedViewVector = viewVector.m_82490_(distance);
        AABB area = new AABB(eyePosition, eyePosition.m_82549_(extendedViewVector));
        LivingEntity livingEntity = null;
        float minDistance = -1;
        for (LivingEntity entity : level.m_6443_(LivingEntity.class, area, e -> canChooseAsTarget(e, viewer))) {
            Vec3 vec32 = new Vec3(entity.m_20185_() - viewer.m_20185_(), entity.m_20188_() - viewer.m_20188_(), entity.m_20189_() - viewer.m_20189_());
            double d = vec32.m_82553_();
            vec32 = vec32.m_82541_();
            double e = viewVector.m_82526_(vec32);
            if (e > 1.0 - 0.025 / d && viewer.m_142582_(entity)) {
                var dis = entity.m_20270_(viewer);
                if (minDistance < 0 || minDistance > dis) {
                    livingEntity = entity;
                    minDistance = dis;
                }
            }
        }
        /*
        if (livingEntity != null) {
            livingEntity.addEffect(new MobEffectInstance(MobEffects.GLOWING, 100, 0));
        }//DEBUG ONLY
        */

        return livingEntity;
    }

    public static BlockHitResult rayTraceBlock(LivingEntity viewer, double distance) {
        var level = viewer.m_9236_();
        Vec3 eyePosition = viewer.m_146892_();
        Vec3 viewVector = viewer.m_20252_(1.0f).m_82541_();
        Vec3 extendedViewVector = viewVector.m_82490_(distance);
        ClipContext context = new ClipContext(eyePosition, eyePosition.m_82549_(extendedViewVector), ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, viewer);
        BlockHitResult blockHitResult = level.m_45547_(context);
        return blockHitResult;
    }

    private static boolean canChooseAsTarget(LivingEntity entity, Entity viewer) {
        return !entity.m_213877_() && !entity.m_5833_() && entity != viewer.m_20202_() && entity != viewer;
    }
}
