package me.rufia.fightorflight.utils.explosion;

import com.cobblemon.mod.common.api.moves.Move;
import com.cobblemon.mod.common.api.types.ElementalType;
import com.cobblemon.mod.common.api.types.ElementalTypes;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectListIterator;
import me.rufia.fightorflight.CobblemonFightOrFlight;
import me.rufia.fightorflight.entity.PokemonAttackEffect;
import me.rufia.fightorflight.utils.PokemonUtils;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.*;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

import java.util.Map;
import java.util.Optional;
import java.util.Set;

//TODO unfinished
public class FOFExplosion extends Explosion {
    protected static final ExplosionDamageCalculator EXPLOSION_DAMAGE_CALCULATOR = new ExplosionDamageCalculator();
    protected static final int MAX_DROPS_PER_COMBINED_STACK = 16;
    protected final boolean fire;
    protected final Explosion.BlockInteraction blockInteraction;
    protected final RandomSource random;
    protected final Level level;
    protected final double x;
    protected final double y;
    protected final double z;
    protected final PokemonEntity pokemon;
    protected final boolean shouldHurtAlly;
    @Nullable
    public Entity source;
    public float radius;
    protected final DamageSource damageSource;
    protected final ExplosionDamageCalculator damageCalculator;
    protected final ObjectArrayList<BlockPos> toBlow;
    protected final Map<Player, Vec3> hitPlayers;

    public FOFExplosion(Level level, @Nullable Entity source, PokemonEntity pokemon, @Nullable DamageSource damageSource, @Nullable ExplosionDamageCalculator damageCalculator, double toBlowX, double toBlowY, double toBlowZ, float radius, boolean fire, Explosion.BlockInteraction blockInteraction, boolean shouldHurtAlly) {
        super(level, source, damageSource, damageCalculator, toBlowX, toBlowY, toBlowZ, radius, fire, blockInteraction);
        this.random = RandomSource.m_216327_();
        this.toBlow = new ObjectArrayList<>();
        this.hitPlayers = Maps.newHashMap();
        this.level = level;
        this.source = source;
        this.radius = radius;
        this.x = toBlowX;
        this.y = toBlowY;
        this.z = toBlowZ;
        this.fire = fire;
        this.blockInteraction = blockInteraction;
        this.damageSource = damageSource == null ? level.m_269111_().m_269264_() : damageSource;
        this.damageCalculator = damageCalculator == null ? this.m_46062_(source) : damageCalculator;
        this.pokemon = pokemon;
        this.shouldHurtAlly = shouldHurtAlly;
    }

    protected ExplosionDamageCalculator m_46062_(@Nullable Entity entity) {
        return (entity == null ? EXPLOSION_DAMAGE_CALCULATOR : new EntityBasedExplosionDamageCalculator(entity));
    }

    public static Optional<Float> getBlockExplosionResistance(BlockState state, FluidState fluid) {
        return state.m_60795_() && fluid.m_76178_() ? Optional.empty() : Optional.of(Math.max(state.m_60734_().m_7325_(), fluid.m_76190_()));
    }

    public boolean shouldBlockExplode(Explosion explosion, BlockGetter reader, BlockPos pos, BlockState state, float power) {
        return true;
    }

    public void m_46061_() {
        this.level.m_220400_(this.source, GameEvent.f_157812_, new Vec3(this.x, this.y, this.z));
        Set<BlockPos> set = Sets.newHashSet();

        for (int j = 0; j < 16; ++j) {
            for (int k = 0; k < 16; ++k) {
                for (int l = 0; l < 16; ++l) {
                    if (j == 0 || j == 15 || k == 0 || k == 15 || l == 0 || l == 15) {
                        double d = (double) ((float) j / 15.0F * 2.0F - 1.0F);
                        double e = (double) ((float) k / 15.0F * 2.0F - 1.0F);
                        double f = (double) ((float) l / 15.0F * 2.0F - 1.0F);
                        double g = Math.sqrt(d * d + e * e + f * f);
                        d /= g;
                        e /= g;
                        f /= g;
                        float h = this.radius * (0.8F + this.level.f_46441_.m_188501_() * 0.2F);
                        double m = this.x;
                        double n = this.y;
                        double o = this.z;

                        for (float p = 0.3F; h > 0.0F; h -= 0.22500001F) {
                            BlockPos blockPos = BlockPos.m_274561_(m, n, o);
                            BlockState blockState = this.level.m_8055_(blockPos);
                            FluidState fluidState = this.level.m_6425_(blockPos);
                            if (!this.level.m_46739_(blockPos)) {
                                break;
                            }

                            Optional<Float> optional = getBlockExplosionResistance(blockState, fluidState);
                            if (optional.isPresent()) {
                                h -= ((Float) optional.get() + 0.3F) * 0.3F;
                                //CobblemonFightOrFlight.LOGGER.info(Float.toString(h));
                            }

                            if (h > 0.0F) {
                                set.add(blockPos);
                            }

                            m += d * 0.30000001192092896;
                            n += e * 0.30000001192092896;
                            o += f * 0.30000001192092896;
                        }
                    }
                }
            }
        }

        this.toBlow.addAll(set);
        PokemonAttackEffect.dealAoEDamage(pokemon, source, shouldHurtAlly);
    }

    public void finalizeExplosion() {
        if (this.level.f_46443_) {
            this.level.m_7785_(this.x, this.y, this.z, SoundEvents.f_11913_, SoundSource.BLOCKS, 4.0F, (1.0F + (this.level.f_46441_.m_188501_() - this.level.f_46441_.m_188501_()) * 0.2F) * 0.7F, false);
        }

        boolean bl = this.m_254884_();

        if (!(this.radius < 2.0F) && bl) {
            this.level.m_7106_(ParticleTypes.f_123812_, this.x, this.y, this.z, 1.0, 0.0, 0.0);
        } else {
            this.level.m_7106_(ParticleTypes.f_123813_, this.x, this.y, this.z, 1.0, 0.0, 0.0);
        }//replace it with type-specific particle

        if (bl) {
            ObjectArrayList<Pair<ItemStack, BlockPos>> objectArrayList = new ObjectArrayList<>();
            boolean bl2 = pokemon.m_269323_() instanceof Player;
            Util.m_214673_(this.toBlow, this.level.f_46441_);
            ObjectListIterator<BlockPos> it1 = this.toBlow.iterator();
            while (it1.hasNext()) {
                BlockPos blockPos = it1.next();
                BlockState blockState = this.level.m_8055_(blockPos);
                net.minecraft.world.level.block.Block block = blockState.m_60734_();
                if (!blockState.m_60795_()) {
                    BlockPos blockPos2 = blockPos.m_7949_();
                    this.level.m_46473_().m_6180_("explosion_blocks");
                    if (block.m_6903_(this)) {
                        if (this.level instanceof ServerLevel serverLevel) {
                            BlockEntity blockEntity = blockState.m_155947_() ? this.level.m_7702_(blockPos) : null;
                            LootParams.Builder builder = (new LootParams.Builder(serverLevel)).m_287286_(LootContextParams.f_81460_, Vec3.m_82512_(blockPos)).m_287286_(LootContextParams.f_81463_, ItemStack.f_41583_).m_287289_(LootContextParams.f_81462_, blockEntity).m_287289_(LootContextParams.f_81455_, this.source);
                            if (this.blockInteraction == BlockInteraction.DESTROY_WITH_DECAY) {
                                builder.m_287286_(LootContextParams.f_81464_, this.radius);
                            }
                            blockState.m_222967_(serverLevel, blockPos, ItemStack.f_41583_, bl2);
                            blockState.m_287290_(builder).forEach((itemStack) -> m_46067_(objectArrayList, itemStack, blockPos2));
                        }
                    }

                    this.level.m_7731_(blockPos, Blocks.f_50016_.m_49966_(), 3);
                    block.m_7592_(this.level, blockPos, this);
                    this.level.m_46473_().m_7238_();
                }
            }

            for (Pair<ItemStack, BlockPos> pair : objectArrayList) {
                //CobblemonFightOrFlight.LOGGER.info("Scanning");
                net.minecraft.world.level.block.Block.m_49840_(this.level, pair.getSecond(), pair.getFirst());
            }
        }

        if (this.fire) {
            for (BlockPos blockPos3 : this.toBlow) {
                if (this.random.m_188503_(3) == 0 && this.level.m_8055_(blockPos3).m_60795_() && this.level.m_8055_(blockPos3.m_7495_()).m_60804_(this.level, blockPos3.m_7495_())) {
                    this.level.m_46597_(blockPos3, BaseFireBlock.m_49245_(this.level, blockPos3));
                }
            }
        }
    }

    public boolean m_254884_() {
        return this.blockInteraction != Explosion.BlockInteraction.KEEP;
    }

    protected static void m_46067_(ObjectArrayList<Pair<ItemStack, BlockPos>> dropPositionArray, ItemStack stack, BlockPos pos) {
        int i = dropPositionArray.size();

        for (int j = 0; j < i; ++j) {
            Pair<ItemStack, BlockPos> pair = dropPositionArray.get(j);
            ItemStack itemStack = pair.getFirst();
            if (ItemEntity.m_32026_(itemStack, stack)) {
                ItemStack itemStack2 = ItemEntity.m_32029_(itemStack, stack, 16);
                dropPositionArray.set(j, Pair.of(itemStack2, pair.getSecond()));
                if (stack.m_41619_()) {
                    return;
                }
            }
        }

        dropPositionArray.add(Pair.of(stack, pos));
    }

    public static FOFExplosion createExplosion(Entity source, PokemonEntity pokemonEntity, double x, double y, double z, boolean shouldHurtAlly) {
        if (pokemonEntity == null) {
            CobblemonFightOrFlight.LOGGER.warn("trying to create a new FOFExplosion without PokemonEntity");
            return null;
        }
        boolean isSpecial = true;
        float radius = calculateRadius(pokemonEntity, isSpecial);
        ElementalType type1 = pokemonEntity.getPokemon().getPrimaryType();
        ElementalType type2 = pokemonEntity.getPokemon().getSecondaryType();
        boolean shouldCreateFire = CobblemonFightOrFlight.moveConfig().should_create_fire && (type1.equals(ElementalTypes.INSTANCE.getFIRE()) || (type2 != null && type2.equals(ElementalTypes.INSTANCE.getFIRE())));
        BlockInteraction blockInteraction1;
        if (CobblemonFightOrFlight.moveConfig().pokemon_griefing) {
            blockInteraction1 = BlockInteraction.DESTROY_WITH_DECAY;
        } else {
            blockInteraction1 = BlockInteraction.KEEP;
        }
        return new FOFExplosion(source.m_9236_(), source, pokemonEntity, source.m_269291_().m_269333_(pokemonEntity), null, x, y, z, radius, shouldCreateFire, blockInteraction1, shouldHurtAlly);
    }

    protected static float calculateRadius(PokemonEntity pokemonEntity, boolean isSpecial) {
        Move move = isSpecial ? PokemonUtils.getRangeAttackMove(pokemonEntity) : PokemonUtils.getMeleeMove(pokemonEntity);
        if (move == null) {
            return 0.0f;
        }
        return PokemonAttackEffect.getAoERadius(pokemonEntity, move);
    }

}
