package me.rufia.fightorflight.client.hud.moveslots;

import I;
import com.cobblemon.mod.common.api.moves.Move;
import com.cobblemon.mod.common.api.types.ElementalType;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.pokemon.activestate.PokemonState;
import com.cobblemon.mod.common.pokemon.activestate.SentOutState;
import com.mojang.blaze3d.systems.RenderSystem;
import me.rufia.fightorflight.CobblemonFightOrFlight;
import me.rufia.fightorflight.PokemonInterface;
import me.rufia.fightorflight.utils.PokemonUtils;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_746;

public class MoveSlotsRender {
    private static final class_2960 TYPE_ICON_LOCATION = class_2960.method_60655(CobblemonFightOrFlight.COBBLEMON_MOD_ID, "textures/gui/types.png");
    private static final int TYPE_ICON_SIZE = 36;
    private static final int DRAW_SIZE = (int) (TYPE_ICON_SIZE * CobblemonFightOrFlight.visualEffectConfig().move_indicator_size);
    private static final float TEXT_SIZE = 0.5f;

    public static void render(class_332 graphics, float tickDelta, Pokemon pokemon) {
        class_310 minecraft = class_310.method_1551();
        var player = minecraft.field_1724;
        if (!CobblemonFightOrFlight.visualEffectConfig().enable_move_indicator) {
            return;
        }
        if (player == null || pokemon == null) {
            CobblemonFightOrFlight.LOGGER.info("Failed to render the icon.");
            return;
        }
        if (player.method_7325()) {
            return;
        }

        var screenWidth = minecraft.method_22683().method_4486();
        var screenHeight = minecraft.method_22683().method_4502();
        var state = pokemon.getState();
        if (state instanceof SentOutState) {
            var entity = pokemon.getEntity();
            if (entity != null) {
                Move move = PokemonUtils.getMove(entity);
                if (move != null) {
                    int originX = (int) (screenWidth * CobblemonFightOrFlight.visualEffectConfig().move_indicator_x_relative);
                    int originY = (int) (screenHeight * CobblemonFightOrFlight.visualEffectConfig().move_indicator_y_relative);
                    class_327 font = minecraft.field_1772;
                    renderMoveSlot(graphics, font, originX, originY, entity, move);
                }
            }
        }
    }

    public static void renderMoveSlot(class_332 graphics, class_327 font, int x, int y, PokemonEntity entity, Move move) {
        ElementalType type = move.getType();
        int cooldown = ((PokemonInterface) entity).getAttackTime();
        int maxCooldown = ((PokemonInterface) entity).getMaxAttackTime();
        float cooldownPer = (float) cooldown / maxCooldown;
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        if (cooldown > 2) {
            graphics.method_51422(0.5f, 0.5f, 0.5f, 1f);
        }
        graphics.method_25293(TYPE_ICON_LOCATION, x, y, DRAW_SIZE, DRAW_SIZE, TYPE_ICON_SIZE * type.getTextureXMultiplier(), 0, TYPE_ICON_SIZE, TYPE_ICON_SIZE, TYPE_ICON_SIZE * 18, TYPE_ICON_SIZE);
        graphics.method_51422(1f, 1f, 1f, 1f);
        if (cooldown > 1 && maxCooldown != 0) {
            graphics.method_51422(0.65f, 0.8f, 1f, 0.95f);
            int cdHeight = (int) ((float) DRAW_SIZE * (1 - cooldownPer));
            graphics.method_25293(TYPE_ICON_LOCATION, x, y + DRAW_SIZE - cdHeight, DRAW_SIZE, cdHeight, TYPE_ICON_SIZE * type.getTextureXMultiplier(), TYPE_ICON_SIZE - (float) (cdHeight * TYPE_ICON_SIZE) / DRAW_SIZE, TYPE_ICON_SIZE, (int) ((float) (cdHeight * TYPE_ICON_SIZE) / DRAW_SIZE), TYPE_ICON_SIZE * 18, TYPE_ICON_SIZE);
            graphics.method_51422(1f, 1f, 1f, 1f);
        }
        RenderSystem.disableBlend();
        class_4587 poseStack = graphics.method_51448();
        poseStack.method_22903();
        poseStack.method_22905(TEXT_SIZE, TEXT_SIZE, 1);
        graphics.method_27534(font, move.getDisplayName(), (int) (x / TEXT_SIZE), (int) (y / TEXT_SIZE), 0xFFFFFF);
        poseStack.method_22909();
    }
}