package me.rufia.fightorflight.client.renderer;

import me.rufia.fightorflight.CobblemonFightOrFlight;
import me.rufia.fightorflight.client.model.PokemonSpikeModel;
import me.rufia.fightorflight.entity.PokemonAttackEffect;
import me.rufia.fightorflight.entity.projectile.AbstractPokemonSpike;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5253;
import net.minecraft.class_5617;
import net.minecraft.class_7833;
import net.minecraft.class_897;
import java.awt.*;

public class PokemonSpikeRenderer extends class_897<AbstractPokemonSpike> {
    private static final class_2960 TEXTURE_LOCATION = class_2960.method_60655(CobblemonFightOrFlight.MODID, "textures/entity/spike.png");
    private final PokemonSpikeModel<AbstractPokemonSpike> model;

    public PokemonSpikeRenderer(class_5617.class_5618 context) {
        super(context);
        model = new PokemonSpikeModel<>(context.method_32167(PokemonSpikeModel.LAYER_LOCATION));
    }

    @Override
    public void render(AbstractPokemonSpike entity, float entityYaw, float partialTicks, class_4587 poseStack, class_4597 buffer, int packedLight) {
        Color color = getColor(entity);
        int inGroundTick = entity.getInGroundTick();
        poseStack.method_22903();
        float f = class_3532.method_17821(partialTicks, entity.field_5982, entity.method_36454());
        float g = class_3532.method_16439(partialTicks, entity.field_6004, entity.method_36455());
        float h = inGroundTick == -1 ? (float) entity.field_6012 + partialTicks : inGroundTick;
        poseStack.method_22905(0.75f, 0.75f, 0.75f);
        poseStack.method_22907(class_7833.field_40716.rotationDegrees(class_3532.method_15374(h * 0.1F) * 180.0F));
        poseStack.method_22907(class_7833.field_40714.rotationDegrees(class_3532.method_15362(h * 0.1F) * 180.0F));
        poseStack.method_22907(class_7833.field_40718.rotationDegrees(class_3532.method_15374(h * 0.15F) * 360.0F));
        poseStack.method_46416(0f, -1.5f, 0f);
        this.model.setupAnim(entity, 0.0F, 0.0F, 0.0F, f, g);
        class_4588 vertexConsumer = buffer.getBuffer(this.model.method_23500(TEXTURE_LOCATION));
        int colorCode = class_5253.class_5254.method_59554(0.75F, (float) color.getRed() / 255, (float) color.getGreen() / 255, (float) color.getBlue() / 255);
        this.model.method_2828(poseStack, vertexConsumer, packedLight, class_4608.field_21444, colorCode);
        poseStack.method_22909();
        super.method_3936(entity, entityYaw, partialTicks, poseStack, buffer, packedLight);
    }

    public Color getColor(AbstractPokemonSpike entity) {
        if (entity.getElementalType() != null) {
            return PokemonAttackEffect.getColorFromType(entity.getElementalType());
        }
        return Color.white;
    }

    @Override
    public class_2960 getTextureLocation(AbstractPokemonSpike entity) {
        return TEXTURE_LOCATION;
    }
}
