package me.rufia.fightorflight.client.renderer;

import me.rufia.fightorflight.CobblemonFightOrFlight;
import me.rufia.fightorflight.client.model.PokemonTransformingProjectileModel;
import me.rufia.fightorflight.entity.projectile.AbstractPokemonSpike;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5253;
import net.minecraft.class_5617;
import net.minecraft.class_7833;
import net.minecraft.class_897;
import java.awt.*;

public class PokemonStickyWebRenderer extends class_897<AbstractPokemonSpike> {
    private static final class_2960 TEXTURE_LOCATION = class_2960.method_60655(CobblemonFightOrFlight.MODID, "textures/entity/sticky_web.png");
    private final PokemonTransformingProjectileModel<AbstractPokemonSpike> model;

    public PokemonStickyWebRenderer(class_5617.class_5618 context) {
        super(context);
        model = new PokemonTransformingProjectileModel<>(context.method_32167(PokemonTransformingProjectileModel.LAYER_LOCATION));

    }

    @Override
    public void render(AbstractPokemonSpike entity, float entityYaw, float partialTicks, class_4587 poseStack, class_4597 buffer, int packedLight) {
        int inGroundTick = entity.getInGroundTick();
        poseStack.method_22903();
        float h = inGroundTick == -1 ? (float) entity.field_6012 + partialTicks : inGroundTick;
        float y = inGroundTick == -1 ? -1.5f : -1.45f;
        poseStack.method_22905(0.75f, 0.75f, 0.75f);
        poseStack.method_22907(class_7833.field_40716.rotationDegrees(class_3532.method_15362(h * 0.1F) * 180.0F));
        poseStack.method_46416(0f, y, 0f);
        class_4588 vertexConsumer = buffer.getBuffer(this.model.method_23500(TEXTURE_LOCATION));
        Color color = Color.white;
        int colorCode = class_5253.class_5254.method_59554(0.5F, (float) color.getRed() / 255, (float) color.getGreen() / 255, (float) color.getBlue() / 255);
        if (inGroundTick == -1) {
            this.model.renderMain(poseStack, vertexConsumer, packedLight, class_4608.field_21444, colorCode);
        } else {
            this.model.renderSide(poseStack, vertexConsumer, packedLight, class_4608.field_21444, colorCode);
        }
        poseStack.method_22909();
        super.method_3936(entity, entityYaw, partialTicks, poseStack, buffer, packedLight);
    }

    @Override
    public class_2960 getTextureLocation(AbstractPokemonSpike entity) {
        return TEXTURE_LOCATION;
    }
}
