package me.rufia.fightorflight.entity;

import dev.architectury.registry.level.entity.EntityAttributeRegistry;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import me.rufia.fightorflight.CobblemonFightOrFlight;
import me.rufia.fightorflight.client.model.PokemonAreaEffectMagicModel;
import me.rufia.fightorflight.entity.areaeffect.PokemonAreaEffectMagic;
import me.rufia.fightorflight.entity.areaeffect.PokemonTornado;
import me.rufia.fightorflight.entity.areaeffect.PokemonWhirlPool;
import me.rufia.fightorflight.entity.projectile.*;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1311;
import net.minecraft.class_1676;
import net.minecraft.class_2960;
import net.minecraft.class_5132;
import net.minecraft.class_7924;
import java.util.function.Supplier;

public interface EntityFightOrFlight {
    DeferredRegister<class_1299<?>> ENTITY_TYPES = DeferredRegister.create(CobblemonFightOrFlight.MODID, class_7924.field_41266);
    RegistrySupplier<class_1299<PokemonTracingBullet>> TRACING_BULLET = registerProjectile("tracing_bullet",
            class_1299.class_1300.<PokemonTracingBullet>method_5903(PokemonTracingBullet::new
                    , class_1311.field_17715).method_17687(0.3125f, 0.3125f));
    RegistrySupplier<class_1299<PokemonArrow>> ARROW_PROJECTILE = registerProjectile("arrow_projectile",
            class_1299.class_1300.<PokemonArrow>method_5903(PokemonArrow::new
                    , class_1311.field_17715).method_17687(0.5F, 0.5F).method_27299(4).method_27300(20));
    RegistrySupplier<class_1299<PokemonBullet>> BULLET = registerProjectile("bullet_projectile",
            class_1299.class_1300.<PokemonBullet>method_5903(PokemonBullet::new, class_1311.field_17715).method_17687(0.3125f, 0.3125f));
    RegistrySupplier<class_1299<PokemonSpike>> SPIKE = registerProjectile("spike_projectile",
            class_1299.class_1300.<PokemonSpike>method_5903(PokemonSpike::new, class_1311.field_17715).method_17687(0.5f, 0.5f));
    RegistrySupplier<class_1299<PokemonFloatingSpike>> FLOATING_SPIKE = registerProjectile("floating_spike_projectile",
            class_1299.class_1300.<PokemonFloatingSpike>method_5903(PokemonFloatingSpike::new, class_1311.field_17715).method_17687(0.5f, 0.5f));
    RegistrySupplier<class_1299<PokemonStickyWeb>> STICKY_WEB = registerProjectile("sticky_web",
            class_1299.class_1300.<PokemonStickyWeb>method_5903(PokemonStickyWeb::new, class_1311.field_17715).method_17687(0.5f, 0.5f));
    RegistrySupplier<class_1299<PokemonTornado>> TORNADO = registerMiscEntity("tornado",
            class_1299.class_1300.<PokemonTornado>method_5903(PokemonTornado::new, class_1311.field_17715).method_17687(0.1f, 0.1f));
    RegistrySupplier<class_1299<PokemonWhirlPool>> WHIRLPOOL = registerMiscEntity("whirlpool",
            class_1299.class_1300.<PokemonWhirlPool>method_5903(PokemonWhirlPool::new, class_1311.field_17715).method_17687(0.1f, 0.1f));
    RegistrySupplier<class_1299<PokemonAreaEffectMagic>> MAGIC_EFFECT = registerMiscEntity("magic_effect",
            class_1299.class_1300.<PokemonAreaEffectMagic>method_5903(PokemonAreaEffectMagic::new, class_1311.field_17715).method_17687(0.1f, 0.1f));

    static void bootstrap() {
        ENTITY_TYPES.register();
    }

    static <T extends class_1309> RegistrySupplier<class_1299<T>> register(String name, class_1299.class_1300<T> builder, Supplier<class_5132.class_5133> attributes) {
        class_2960 id = class_2960.method_60655(CobblemonFightOrFlight.MODID, name);
        return ENTITY_TYPES.register(id, () -> {
            class_1299<T> result = builder.method_5905(id.toString());
            EntityAttributeRegistry.register(() -> result, attributes);

            return result;
        });
    }

    static <T extends class_1676> RegistrySupplier<class_1299<T>> registerProjectile(String name, class_1299.class_1300<T> builder) {
        class_2960 id = class_2960.method_60655(CobblemonFightOrFlight.MODID, name);
        return ENTITY_TYPES.register(id, () -> builder.method_5905(id.toString()));
    }

    static <T extends class_1297> RegistrySupplier<class_1299<T>> registerMiscEntity(String name, class_1299.class_1300<T> builder) {
        class_2960 id = class_2960.method_60655(CobblemonFightOrFlight.MODID, name);
        return ENTITY_TYPES.register(id, () -> builder.method_5905(id.toString()));
    }
}
