package me.rufia.fightorflight.entity.ai.tasks;

import com.bedrockk.molang.Expression;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.util.MoLangExtensionsKt;
import me.rufia.fightorflight.CobblemonFightOrFlight;
import me.rufia.fightorflight.utils.PokemonUtils;
import net.minecraft.class_1309;
import net.minecraft.class_243;
import net.minecraft.class_4140;
import net.minecraft.class_4142;
import net.minecraft.class_7894;
import net.minecraft.class_7898;


public class FOFMoveToAttackTargetTask {
    public static class_7894<class_1309> create(Expression speedMultiplierExp, Expression closeEnoughDistanceExp) {
        return class_7898.method_47224(context ->
                context.group(
                        context.method_47244(class_4140.field_22355),
                        context.method_47235(class_4140.field_18445)
                ).apply(context, (attackTargetAccessor, walkTargetAccessor) -> ((serverLevel, livingEntity, l) -> {
                    if (livingEntity instanceof PokemonEntity pokemonEntity && PokemonUtils.shouldMelee(pokemonEntity)) {
                        float speedMultiplier = MoLangExtensionsKt.resolveFloat(MoLangExtensionsKt.getMainThreadRuntime(), speedMultiplierExp, MoLangExtensionsKt.getContextOrEmpty(MoLangExtensionsKt.getMainThreadRuntime()));
                        int closeEnoughDistance = MoLangExtensionsKt.resolveInt(MoLangExtensionsKt.getMainThreadRuntime(), closeEnoughDistanceExp, MoLangExtensionsKt.getContextOrEmpty(MoLangExtensionsKt.getMainThreadRuntime()));

                        var attackTarget = context.method_47243(attackTargetAccessor);
                        var position = attackTarget.method_19538();
                        var walkTarget = context.method_47233(walkTargetAccessor).orElse(null);
                        if (walkTarget == null || walkTarget.method_19094().method_18991().method_1025(position) > closeEnoughDistance) {
                            livingEntity.method_18868().method_18878(class_4140.field_18445, new class_4142(attackTarget, speedMultiplier, closeEnoughDistance));
                            return true;
                        }
                    }
                    return false;
                }
                )));
    }
}
