package me.rufia.fightorflight.entity.ai.tasks;

import com.cobblemon.mod.common.api.moves.Move;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import me.rufia.fightorflight.CobblemonFightOrFlight;
import me.rufia.fightorflight.PokemonInterface;
import me.rufia.fightorflight.entity.PokemonAttackEffect;
import me.rufia.fightorflight.utils.FOFUtils;
import me.rufia.fightorflight.utils.PokemonUtils;
import net.minecraft.class_1268;
import net.minecraft.class_1309;
import net.minecraft.class_2338;
import net.minecraft.class_2398;
import net.minecraft.class_4102;
import net.minecraft.class_4140;
import net.minecraft.class_7894;
import net.minecraft.class_7898;
import java.util.Arrays;

public class FOFPokemonMeleeTask {
    public static class_7894<class_1309> create(int cooldownBetweenAttacks) {
        return class_7898.method_47224(context ->
                context.group(
                        context.method_47235(class_4140.field_18446),
                        context.method_47244(class_4140.field_22355),
                        context.method_47245(class_4140.field_22475),
                        context.method_47244(class_4140.field_18442)
                ).apply(context, (lookTargetAccessor, attackTargetAccessor, attackCooldownAccessor, visibleMobsAccessor) -> ((serverLevel, livingEntity, l) -> {
                    class_1309 target = context.method_47243(attackTargetAccessor);
                    if (livingEntity instanceof PokemonEntity pokemonEntity) {
                        int attackTime = FOFPokemonAttackTask.getAttackTime(pokemonEntity);
                        if (PokemonUtils.shouldMelee(pokemonEntity)) {
                            tryQuickApproach(pokemonEntity, target);
                            if (canPerformAttack(pokemonEntity, target)) {
                                if (attackTime <= 0) {
                                    lookTargetAccessor.method_47249(new class_4102(target, true));
                                    FOFPokemonAttackTask.resetAttackTime(pokemonEntity, 0);
                                    pokemonEntity.method_6104(class_1268.field_5808);
                                    pokemonDoHurtTarget(pokemonEntity, target);
                                    pokemonEntity.method_5980(target);
                                    ((PokemonInterface) pokemonEntity).setAttackTime(cooldownBetweenAttacks);
                                    attackCooldownAccessor.method_47250(true, cooldownBetweenAttacks);
                                    return true;
                                }
                            }
                        }
                    }
                    return false;
                }
                )));
    }

    protected static boolean canPerformAttack(PokemonEntity pokemonEntity, class_1309 entity) {
        return pokemonEntity.method_42150(entity) && pokemonEntity.method_5985().method_6369(entity);
    }

    protected static boolean pokemonDoHurtTarget(PokemonEntity pokemonEntity, class_1309 hurtTarget) {
        if (!CobblemonFightOrFlight.commonConfig().do_pokemon_attack_in_battle) {
            if (FOFPokemonAttackTask.isTargetInBattle(pokemonEntity)) {
                return false;
            }
        }
        //CobblemonFightOrFlight.LOGGER.info("Trying to use melee attack");
        if (!PokemonUtils.pokemonTryForceEncounter(pokemonEntity, hurtTarget)) {
            Move move = PokemonUtils.getMove(pokemonEntity);
            if (move != null) {
                if (Arrays.stream(CobblemonFightOrFlight.moveConfig().self_centered_aoe_moves).toList().contains(move.getName())) {
                    PokemonAttackEffect.dealAoEDamage(pokemonEntity, pokemonEntity, true, PokemonUtils.isMeleeAttackMove(move));
                    if (PokemonUtils.isPhysicalMove(move)) {
                        PokemonUtils.sendAnimationPacket(pokemonEntity, "physical");
                    } else {
                        PokemonUtils.sendAnimationPacket(pokemonEntity, "special");
                    }
                    return true;
                }
            }
            PokemonUtils.sendAnimationPacket(pokemonEntity, "physical");
            return PokemonAttackEffect.pokemonAttack(pokemonEntity, hurtTarget);
        }

        return false;
    }

    protected static void tryQuickApproach(PokemonEntity pokemonEntity, class_1309 target) {
        if (target != null && FOFPokemonAttackTask.getAttackTime(pokemonEntity) == 0) {
            Move move = PokemonUtils.getMove(pokemonEntity);
            if (move != null) {
                String moveName = move.getName();
                if (Arrays.stream(CobblemonFightOrFlight.moveConfig().quick_attack_like_move).toList().contains(moveName)) {
                    float distance = pokemonEntity.method_5739(target);
                    if (distance >= 1.5f && distance <= 10f) {
                        class_2338 targetBlockPos = target.method_24515();
                        if (FOFUtils.multiSamplingCollisionCheckBlock(pokemonEntity, target, 5, 3)) {
                            PokemonUtils.makeParticle(4, pokemonEntity, class_2398.field_46911);
                            pokemonEntity.method_5859(targetBlockPos.method_10263(), targetBlockPos.method_10264(), targetBlockPos.method_10260());
                            PokemonUtils.makeParticle(4, target, class_2398.field_46911);
                        }
                    }
                }
            }
        }
    }
}
