package me.rufia.fightorflight.entity.ai.tasks;

import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.google.common.collect.ImmutableMap;
import me.rufia.fightorflight.PokemonInterface;
import me.rufia.fightorflight.entity.PokemonAttackEffect;
import me.rufia.fightorflight.utils.PokemonUtils;
import net.minecraft.class_1309;
import net.minecraft.class_3218;
import net.minecraft.class_4097;
import net.minecraft.class_4140;
import net.minecraft.class_4141;
import net.minecraft.class_4215;

public class FOFPokemonRangeTask extends class_4097<class_1309> {
    public FOFPokemonRangeTask() {
        super(ImmutableMap.of(
                class_4140.field_18446, class_4141.field_18458,
                class_4140.field_22355, class_4141.field_18456,
                class_4140.field_22475, class_4141.field_18457
        ));
    }

    @Override
    protected boolean method_18919(class_3218 level, class_1309 pokemon) {
        if (pokemon instanceof PokemonEntity pokemonEntity) {
            class_1309 target = FOFPokemonAttackTask.getTarget(pokemonEntity);
            if (target != null && target.method_5805()) {
                return PokemonUtils.shouldShoot(pokemonEntity) && class_4215.method_24565(pokemonEntity, target) && isWithinAttackRange(pokemonEntity, target);
            }
        }
        return false;
    }

    @Override
    protected boolean method_18927(class_3218 level, class_1309 pokemon, long gameTime) {
        if (pokemon instanceof PokemonEntity pokemonEntity) {
            return pokemonEntity.method_18868().method_18896(class_4140.field_22355) && this.method_18919(level, pokemonEntity);
        }
        return false;
    }

    @Override
    protected void method_18926(class_3218 level, class_1309 pokemon, long gameTime) {
    }

    @Override
    protected void method_18924(class_3218 level, class_1309 pokemon, long gameTime) {
        if (pokemon instanceof PokemonEntity pokemonEntity) {
            class_1309 target = FOFPokemonAttackTask.getTarget(pokemonEntity);
            if (target != null) {
                pokemonEntity.method_5980(target);
                boolean canSee = pokemonEntity.method_5985().method_6369(target);
                int attackTime = FOFPokemonAttackTask.getAttackTime(pokemonEntity);
                if (attackTime == 7 && (((PokemonInterface) pokemonEntity).usingSound())) {
                    PokemonUtils.createSonicBoomParticle(pokemonEntity, target);
                }
                if (attackTime % 5 == 0 && (((PokemonInterface) pokemonEntity).usingMagic())) {
                    PokemonAttackEffect.makeMagicAttackParticle(pokemonEntity, target);
                }
                if (attackTime == 0) {
                    if (!canSee) {
                        return;
                    }
                    performRangedAttack(pokemonEntity, target);
                } else if (attackTime < 0) {
                    FOFPokemonAttackTask.refreshAttackTime(pokemonEntity, 10);
                }
            }
        }
    }

    protected boolean isWithinAttackRange(class_1309 pokemon, class_1309 target) {
        if (pokemon instanceof PokemonEntity pokemonEntity) {
            double d = pokemonEntity.method_5739(target);
            return d < 8;
        }
        return false;
    }

    protected void performRangedAttack(PokemonEntity pokemonEntity, class_1309 target) {
        double d = pokemonEntity.method_5649(target.method_23317(), target.method_23318(), target.method_23321());
        PokemonAttackEffect.pokemonPerformRangedAttack(pokemonEntity, target);
        FOFPokemonAttackTask.resetAttackTime(pokemonEntity, d);
        pokemonEntity.method_18868().method_24525(class_4140.field_22475, true, FOFPokemonAttackTask.getAttackTime(pokemonEntity));
    }
}
