package me.rufia.fightorflight.entity.areaeffect;

import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import me.rufia.fightorflight.entity.EntityFightOrFlight;
import me.rufia.fightorflight.utils.PokemonUtils;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_2398;
import net.minecraft.class_3417;

public class PokemonTornado extends AbstractPokemonAreaEffect {
    public PokemonTornado(class_1299<? extends AbstractPokemonAreaEffect> entityType, class_1937 level) {
        super(entityType, level);
    }

    public PokemonTornado(class_1309 owner) {
        super(EntityFightOrFlight.TORNADO.get(), owner.method_37908());
        setOwner(owner);
    }

    @Override
    protected void visualEffect() {
        if (owner instanceof PokemonEntity) {
            if (isWaiting()) {
                PokemonUtils.makeParticle(10, this, class_2398.field_22247);
                PokemonUtils.makeParticle(2, this, class_2398.field_11227);
            }
        }
    }

    @Override
    protected void activate() {
        super.activate();
        if (owner instanceof PokemonEntity pokemonEntity && pokemonEntity.method_5805()) {
            dealDamageInTheArea();
        } else {
            method_31472();
        }
    }

    @Override
    protected void playDefaultSound() {
        method_5783(class_3417.field_49049.comp_349(), 3f, (1.0F + (method_37908().field_9229.method_43057() - method_37908().field_9229.method_43057()) * 0.2F) * 0.7F);
    }
}
