package me.rufia.fightorflight.entity.projectile;

import me.rufia.fightorflight.utils.FOFUtils;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1657;
import net.minecraft.class_1675;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3532;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_7924;
import net.minecraft.class_9109;
import net.minecraft.world.phys.*;
import java.util.List;

public abstract class AbstractPokemonSpike extends AbstractPokemonProjectile {
    protected boolean inGround;
    protected int inGroundTime;
    protected short life;
    protected String type;
    protected class_2680 lastState;
    protected boolean activated;
    private static final class_2940<Integer> IN_GROUND_TICK;

    static {
        IN_GROUND_TICK = class_2945.method_12791(AbstractPokemonSpike.class, class_2943.field_13327);
    }

    public AbstractPokemonSpike(class_1299<? extends AbstractPokemonProjectile> entityType, class_1937 level) {
        super(entityType, level);
    }

    protected boolean shouldFall() {
        return inGround && this.method_37908().method_18026((new class_238(this.method_19538(), this.method_19538())).method_1014(0.1));
    }

    protected void startFalling() {
        inGround = false;
        class_243 vec3 = this.method_18798();
        this.method_18799(vec3.method_18805(this.field_5974.method_43057() * 0.2F, this.field_5974.method_43057() * 0.2F, this.field_5974.method_43057() * 0.2F));
    }

    protected class_3966 findHitEntity(class_243 startVec, class_243 endVec) {
        return class_1675.method_18077(this.method_37908(), this, startVec, endVec, this.method_5829().method_18804(this.method_18798()).method_1014(1.0), this::method_26958);
    }

    @Override
    protected void method_24920(class_3965 result) {
        this.lastState = this.method_37908().method_8320(result.method_17777());
        super.method_24920(result);
        class_243 vec3 = result.method_17784().method_1023(this.method_23317(), this.method_23318(), this.method_23321());
        this.method_18799(vec3);

        class_243 vec31 = vec3.method_1029().method_1021(0.05);
        this.method_23327(this.method_23317() - vec31.field_1352, this.method_23318() - vec31.field_1351, this.method_23321() - vec31.field_1350);
        inGround = true;
    }

    protected void checkEntityCollision() {
        if (!method_37908().field_9236 && activated) {
            List<class_1309> list = method_37908().method_18467(class_1309.class, method_5829().method_1014(0.1));
            for (class_1309 livingEntity : list) {
                if (method_24921() != livingEntity && livingEntity.field_6038 != livingEntity.method_23317() && livingEntity.field_5989 != livingEntity.method_23321()) {
                    double d = Math.abs(livingEntity.method_23317() - livingEntity.field_6038);
                    double e = Math.abs(livingEntity.method_23321() - livingEntity.field_5989);
                    if (d >= 0.003 || e >= 0.003) {
                        hurtEntity(livingEntity);
                    }
                }
            }
        }
    }

    protected abstract void hurtEntity(class_1309 target);

    @Override
    public void method_5784(class_1313 type, class_243 pos) {
        super.method_5784(type, pos);
        if (type != class_1313.field_6308 && this.shouldFall()) {
            this.startFalling();
        }
    }

    protected void tickDespawn() {
        var owner = method_24921();
        if (owner != null && owner.method_5805()) {
            ++life;
        } else {
            life += 10;
        }
        if (this.life >= getMaxLife()) {
            this.method_31472();
        }
    }

    @Override
    public void method_5773() {
        super.method_5773();
        if (inGround) {
            if (getInGroundTick() == -1) {
                int randomInterval = method_37908().field_9229.method_43048(20);
                setInGroundTick(field_6012 + randomInterval);
            }
        } else {
            setInGroundTick(-1);
        }
        if (activated && !this.method_37908().field_9236) {
            this.tickDespawn();
        }
        checkEntityCollision();
        boolean flag = field_5960;
        class_243 vec3 = this.method_18798();
        if (this.field_6004 == 0.0F && this.field_5982 == 0.0F) {
            double d0 = vec3.method_37267();
            this.method_36456(FOFUtils.toAngle(class_3532.method_15349(vec3.field_1352, vec3.field_1350)));
            this.method_36457(FOFUtils.toAngle(class_3532.method_15349(vec3.field_1351, d0)));
            this.field_5982 = this.method_36454();
            this.field_6004 = this.method_36455();
        }

        class_2338 blockpos = this.method_24515();
        class_2680 blockstate = this.method_37908().method_8320(blockpos);
        class_243 vec33;
        if (!blockstate.method_26215() && !flag) {
            class_265 voxelshape = blockstate.method_26220(this.method_37908(), blockpos);
            if (!voxelshape.method_1110()) {
                vec33 = this.method_19538();

                for (class_238 aabb : voxelshape.method_1090()) {
                    if (aabb.method_996(blockpos).method_1006(vec33)) {
                        inGround = true;
                        break;
                    }
                }
            }
        }
        if (inGround && !flag) {
            if (!activated) {
                activated = true;
                onActivated();
            }
            if (this.lastState != blockstate && this.shouldFall()) {
                this.startFalling();
            }

            ++this.inGroundTime;
        } else {
            this.inGroundTime = 0;
            class_243 vec32 = this.method_19538();
            vec33 = vec32.method_1019(vec3);
            class_239 hitResult = this.method_37908().method_17742(new class_3959(vec32, vec33, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, this));
            if (hitResult.method_17783() != class_239.class_240.field_1333) {
                vec33 = hitResult.method_17784();
            }

            while (!this.method_31481()) {
                class_3966 entityHitResult = findHitEntity(vec32, vec33);
                if (entityHitResult != null) {
                    hitResult = entityHitResult;
                    if (hitResult.method_17783() == class_239.class_240.field_1331) {
                        class_1297 entity = entityHitResult.method_17782();
                        class_1297 entity1 = this.method_24921();
                        if (entity instanceof class_1657 && entity1 instanceof class_1657 && !((class_1657) entity1).method_7256((class_1657) entity)) {
                            hitResult = null;
                            entityHitResult = null;
                        }
                    }
                }
                if (hitResult != null && !flag) {
                    class_9109 projectileDeflection = this.method_59860(hitResult);
                    this.field_6007 = true;
                    if (projectileDeflection != class_9109.field_48347) {
                        break;
                    }
                }
                if (entityHitResult == null) {
                    break;
                }
                hitResult = null;
            }

            vec3 = this.method_18798();
            double dx = vec3.field_1352;
            double dy = vec3.field_1351;
            double dz = vec3.field_1350;

            double d4 = vec3.method_37267();
            if (flag) {
                this.method_36456(FOFUtils.toAngle(class_3532.method_15349(-dx, -dz)));
            } else {
                this.method_36456(FOFUtils.toAngle(class_3532.method_15349(dx, dz)));
            }

            this.method_36457(FOFUtils.toAngle(class_3532.method_15349(dy, d4)));
            this.method_36457(method_26960(this.field_6004, this.method_36455()));
            this.method_36456(method_26960(this.field_5982, this.method_36454()));
        }
    }

    protected void onActivated(){

    }

    @Override
    public void method_5652(class_2487 compound) {
        super.method_5652(compound);
        compound.method_10575("life", life);
        compound.method_10556("activated", activated);
        compound.method_10556("inGround", inGround);
        if (this.lastState != null) {
            compound.method_10566("inBlockState", class_2512.method_10686(this.lastState));
        }
    }

    @Override
    public void method_5749(class_2487 compound) {
        super.method_5749(compound);
        life = compound.method_10568("life");
        activated = compound.method_10577("activated");
        inGround = compound.method_10577("inGround");
        if (compound.method_10573("inBlockState", class_2487.field_33260)) {
            this.lastState = class_2512.method_10681(this.method_37908().method_45448(class_7924.field_41254), compound.method_10562("inBlockState"));
        }
    }

    @Override
    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(IN_GROUND_TICK, -1);
    }

    public void setInGroundTick(int value) {
        field_6011.method_12778(IN_GROUND_TICK, value);
    }

    public int getInGroundTick() {
        return field_6011.method_12789(IN_GROUND_TICK);
    }

    protected int getMaxLife() {
        return 300;
    }

    @Override
    protected boolean shoudlCreateParticle() {
        return false;
    }

    @Override
    protected double method_7490() {
        return 0.05;
    }

    @Override
    protected boolean method_26958(class_1297 target) {
        return false;
    }
}
