package me.rufia.fightorflight.entity.projectile;

import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import me.rufia.fightorflight.entity.PokemonAttackEffect;
import me.rufia.fightorflight.utils.PokemonUtils;
import me.rufia.fightorflight.utils.explosion.FOFExplosion;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2945;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_5712;

public abstract class ExplosivePokemonProjectile extends AbstractPokemonProjectile {
    public ExplosivePokemonProjectile(class_1299<? extends AbstractPokemonProjectile> entityType, class_1937 level) {
        super(entityType, level);
    }

    protected void explode(PokemonEntity owner) {
        method_37908().method_8421(this, (byte) 17);
        this.method_32875(class_5712.field_28178, this.method_24921());
        this.dealExplosionDamage(owner);
        this.method_31472();
    }

    protected void dealExplosionDamage(PokemonEntity owner) {
        if (owner == null) {
            return;
        }
        FOFExplosion explosion = FOFExplosion.createExplosion(this, owner, method_23317(), method_23318(), method_23321(), true, true);
        if (explosion != null) {
            explosion.method_8348();
            explosion.finalizeExplosion();
        }
    }

    @Override
    protected void method_24920(class_3965 result) {
        class_2338 blockPos = new class_2338(result.method_17777());
        this.method_37908().method_8320(blockPos).method_26178(this.method_37908(), blockPos, this);
        if (!this.method_37908().method_8608() && method_24921() instanceof PokemonEntity pokemonEntity) {
            this.explode(pokemonEntity);
        }
        super.method_24920(result);
    }

    @Override
    protected void method_7454(class_3966 result) {
        class_1297 owner = method_24921();
        if (owner instanceof PokemonEntity pokemonEntity && result.method_17782() instanceof class_1309 hurtTarget) {
            if (!PokemonUtils.pokemonTryForceEncounter(pokemonEntity, hurtTarget) && PokemonAttackEffect.shouldHurtAllyMob(pokemonEntity, hurtTarget)) {
                PokemonAttackEffect.applyPostEffect(pokemonEntity, hurtTarget, PokemonUtils.getMove(pokemonEntity), true);
                explode(pokemonEntity);
            }
        }
    }

    @Override
    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
    }
}
